/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.jaxb.ui.internal.navigator;

import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.ModelItemTreeContentProvider;
import org.eclipse.jpt.common.ui.internal.jface.NullItemTreeContentProviderFactory;
import org.eclipse.jpt.common.ui.internal.model.value.WorkspaceProjectsModel;
import org.eclipse.jpt.common.ui.jface.ItemStructuredContentProvider;
import org.eclipse.jpt.common.ui.jface.ItemTreeContentProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.model.value.PropertyCollectionValueModelAdapter;
import org.eclipse.jpt.common.utility.internal.model.value.TransformationPropertyValueModel;
import org.eclipse.jpt.common.utility.internal.transformer.TransformerTools;
import org.eclipse.jpt.common.utility.model.value.CollectionValueModel;
import org.eclipse.jpt.common.utility.model.value.PropertyValueModel;
import org.eclipse.jpt.common.utility.transformer.Transformer;
import org.eclipse.jpt.jaxb.core.JaxbProject;
import org.eclipse.jpt.jaxb.core.context.JaxbContextNode;
import org.eclipse.jpt.jaxb.core.context.JaxbContextRoot;
import org.eclipse.jpt.jaxb.core.platform.JaxbPlatform;
import org.eclipse.jpt.jaxb.ui.JaxbProjectModel;
import org.eclipse.jpt.jaxb.ui.platform.JaxbPlatformUi;

public class JaxbNavigatorItemContentProviderFactory
implements ItemTreeContentProvider.Factory {
    private HashMap<JaxbPlatform, ItemTreeContentProvider.Factory> delegates = new HashMap();

    public ItemStructuredContentProvider buildProvider(Object input, ItemStructuredContentProvider.Manager manager) {
        if (input instanceof IWorkspaceRoot) {
            return this.buildItemStructuredContentProvider(input, this.buildWorkspaceRootProjectsModel((IWorkspaceRoot)input), manager);
        }
        if (input instanceof IProject) {
            return this.buildItemStructuredContentProvider(input, this.buildProjectChildrenModel((IProject)input), manager);
        }
        return this.getDelegate(input).buildProvider(input, manager);
    }

    protected ItemStructuredContentProvider buildItemStructuredContentProvider(Object input, CollectionValueModel<?> elementsModel, ItemStructuredContentProvider.Manager manager) {
        return new ModelItemStructuredContentProvider(input, elementsModel, manager);
    }

    protected CollectionValueModel<IProject> buildWorkspaceRootProjectsModel(IWorkspaceRoot workspaceRoot) {
        return new WorkspaceProjectsModel(workspaceRoot);
    }

    public ItemTreeContentProvider buildProvider(Object item, Object parent, ItemTreeContentProvider.Manager manager) {
        return item instanceof IProject ? this.buildItemTreeContentProvider(item, parent, this.buildProjectChildrenModel((IProject)item), manager) : this.getDelegate(item).buildProvider(item, parent, manager);
    }

    protected ItemTreeContentProvider buildItemTreeContentProvider(Object item, Object parent, CollectionValueModel<?> childrenModel, ItemTreeContentProvider.Manager manager) {
        return new ModelItemTreeContentProvider(item, parent, childrenModel, manager);
    }

    protected CollectionValueModel<JaxbContextRoot> buildProjectChildrenModel(IProject project) {
        return new PropertyCollectionValueModelAdapter(this.buildProjectJaxbContextRootModel(project));
    }

    protected PropertyValueModel<JaxbContextRoot> buildProjectJaxbContextRootModel(IProject project) {
        return new TransformationPropertyValueModel(this.buildProjectJaxbProjectModel(project), TransformerTools.nullCheck((Transformer)JaxbProject.CONTEXT_ROOT_TRANSFORMER));
    }

    protected PropertyValueModel<JaxbProject> buildProjectJaxbProjectModel(IProject project) {
        return (JaxbProjectModel)project.getAdapter(JaxbProjectModel.class);
    }

    private ItemTreeContentProvider.Factory getDelegate(Object item) {
        return item instanceof JaxbContextNode ? this.getDelegate((JaxbContextNode)item) : NullItemTreeContentProviderFactory.instance();
    }

    private ItemTreeContentProvider.Factory getDelegate(JaxbContextNode contextNode) {
        JaxbPlatform jaxbPlatform = contextNode.getJaxbProject().getPlatform();
        ItemTreeContentProvider.Factory delegate = this.delegates.get(jaxbPlatform);
        if (delegate == null) {
            delegate = this.buildDelegate(jaxbPlatform);
            this.delegates.put(jaxbPlatform, delegate);
        }
        return delegate;
    }

    private ItemTreeContentProvider.Factory buildDelegate(JaxbPlatform jaxbPlatform) {
        JaxbPlatformUi platformUI = (JaxbPlatformUi)jaxbPlatform.getAdapter(JaxbPlatformUi.class);
        return platformUI != null ? platformUI.getNavigatorUi().getTreeItemContentProviderFactory() : NullItemTreeContentProviderFactory.instance();
    }

    public String toString() {
        return ObjectTools.toString((Object)this);
    }
}

