/******************************************************************************
 * Copyright (c) 2010 Oracle
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * Contributors:
 *    Konstantin Komissarchik - initial implementation and ongoing maintenance
 ******************************************************************************/

package org.eclipse.jst.common.project.facet.core.libprov;

import org.eclipse.core.resources.IProject;
import org.eclipse.wst.common.project.facet.core.IProjectFacet;

/**
 * This class should be subclassed to provide detection of legacy library providers in the project.
 * It is used together with the org.eclipse.jst.common.project.facet.core.legacyLibraryProviderDetectors
 * extension point when migrating an existing facet to use the Library Provider Framework.
 * 
 * @author <a href="mailto:konstantin.komissarchik@oracle.com">Konstantin Komissarchik</a>
 * @since 1.4
 */

public abstract class LegacyLibraryProviderDetector
{
    /**
     * Attempts to detect the presence of the legacy library provider in the project.
     * 
     * @param project the project in question
     * @param facet the facet that is making the request for libraries
     * @return the legacy library provider or <code>null</code> if not detected
     */
    
    public abstract ILibraryProvider detect( final IProject project,
                                             final IProjectFacet facet );
}
