/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.j2ee.internal.ui;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jst.j2ee.componentcore.J2EEModuleVirtualComponent;
import org.eclipse.jst.j2ee.internal.plugin.J2EEUIPlugin;
import org.eclipse.jst.j2ee.internal.ui.IJavaEEDeploymentAssemblySectionBuilder;
import org.eclipse.jst.j2ee.internal.ui.Messages;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.wst.common.componentcore.internal.ComponentResource;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.impl.TaskModel;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.ui.internal.propertypage.ResourceMappingFilterExtensionRegistry;
import org.eclipse.wst.common.componentcore.ui.propertypage.AddModuleDependenciesPropertiesPage;

public class JavaEEDeploymentAssemblyAdvancedSectionBuilder
implements IJavaEEDeploymentAssemblySectionBuilder,
SelectionListener {
    private Label defaulDDFolderLabel;
    private Combo rootSourceMappings;
    private IVirtualComponent rootComponent;
    private AddModuleDependenciesPropertiesPage page;
    private String currentSelectedDDFolder = null;
    private List<String> resourceMappingsList = new ArrayList<String>();
    boolean shouldDisplaySection;
    String folderToLook;
    String fileToLook;
    String projectType;

    public JavaEEDeploymentAssemblyAdvancedSectionBuilder(IVirtualComponent component, AddModuleDependenciesPropertiesPage page) {
        this.rootComponent = component;
        this.page = page;
        this.shouldDisplaySection = !JavaEEProjectUtilities.isUtilityProject((IProject)this.rootComponent.getProject());
        IVirtualFolder rootFolder = this.rootComponent.getRootFolder();
        IPath defaultDDFolder = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)rootFolder);
        this.shouldDisplaySection &= defaultDDFolder == null;
        this.projectType = JavaEEProjectUtilities.getJ2EEProjectType((IProject)component.getProject());
        if (this.projectType.equals("jst.appclient")) {
            this.folderToLook = "META-INF";
            this.fileToLook = "META-INF/application-client.xml";
        } else if (this.projectType.equals("jst.connector")) {
            this.folderToLook = "META-INF";
            this.fileToLook = "META-INF/ra.xml";
        } else if (this.projectType.equals("jst.ejb")) {
            this.folderToLook = "META-INF";
            this.fileToLook = "META-INF/ejb-jar.xml";
        } else if (this.projectType.equals("jst.web")) {
            this.folderToLook = "WEB-INF";
            this.fileToLook = "WEB-INF/web.xml";
        } else if (this.projectType.equals("jst.ear")) {
            this.folderToLook = "META-INF";
            this.fileToLook = "META-INF/application.xml";
        } else if (this.projectType.equals("jst.webfragment")) {
            this.folderToLook = "META-INF";
            this.fileToLook = "META-INF/web-fragment.xml";
        }
    }

    @Override
    public void buildSection(Composite parent) {
        if (this.shouldDisplaySection()) {
            Composite advancedSectionComposite = this.createAdvancedSection(parent);
            this.addDefaultDeploymentDescriptorFolderFields(advancedSectionComposite);
        }
    }

    @Override
    public void loadContents() {
        if (this.shouldDisplaySection()) {
            this.loadDefaultDeploymentDescriptorFolderContents();
        }
    }

    @Override
    public boolean saveContents() {
        boolean success = true;
        if (this.shouldDisplaySection()) {
            success = this.saveDefaultDeploymentDescriptorFolderContents();
            this.loadContents();
        }
        return success;
    }

    private void loadDefaultDeploymentDescriptorFolderContents() {
        this.resourceMappingsList.clear();
        IPath[] allRootMappings = this.findAllRootMappings();
        IVirtualFolder rootFolder = this.rootComponent.getRootFolder();
        IPath defaultDDFolder = J2EEModuleVirtualComponent.getDefaultDeploymentDescriptorFolder((IVirtualFolder)rootFolder);
        this.currentSelectedDDFolder = defaultDDFolder == null ? null : defaultDDFolder.toString();
        IPath[] iPathArray = allRootMappings;
        int n = allRootMappings.length;
        int n2 = 0;
        while (n2 < n) {
            IPath mapping = iPathArray[n2];
            this.resourceMappingsList.add(mapping.toString());
            ++n2;
        }
        this.updateSourceMappingsCombo(this.currentSelectedDDFolder, this.resourceMappingsList);
    }

    private List<String> filterMappings(List<String> mappings) {
        HashSet<String> mappingWithDD = new HashSet<String>();
        HashSet<String> mappingWithFolder = new HashSet<String>();
        IProject project = this.rootComponent.getProject();
        for (String mapping : mappings) {
            IFolder ddFolder;
            IFile ddFile;
            if (this.fileToLook != null && !this.fileToLook.equals("") && (ddFile = project.getFile(String.valueOf(new Path(mapping).addTrailingSeparator()) + this.fileToLook)) != null && ddFile.exists()) {
                mappingWithDD.add(mapping);
            }
            if (this.folderToLook == null || this.folderToLook.equals("") || (ddFolder = project.getFolder(String.valueOf(new Path(mapping).addTrailingSeparator()) + this.folderToLook)) == null || !ddFolder.exists()) continue;
            mappingWithFolder.add(mapping);
        }
        if (!mappingWithDD.isEmpty()) {
            return new ArrayList<String>(mappingWithDD);
        }
        return new ArrayList<String>(mappingWithFolder);
    }

    private void updateSourceMappingsCombo(String selectedDDFolder, List<String> resourceMappings) {
        List<String> filteredMappings = this.filterMappings(resourceMappings);
        ArrayList<String> tmpList = new ArrayList<String>(filteredMappings);
        if (selectedDDFolder == null) {
            tmpList.add(0, Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_NODEFAULTDDFOLDER);
        }
        this.rootSourceMappings.setItems(tmpList.toArray(new String[0]));
        if (selectedDDFolder == null) {
            this.rootSourceMappings.select(tmpList.indexOf(Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_NODEFAULTDDFOLDER));
        } else {
            this.rootSourceMappings.select(tmpList.indexOf(selectedDDFolder.toString()));
        }
    }

    private boolean saveDefaultDeploymentDescriptorFolderContents() {
        if (this.currentSelectedDDFolder != null) {
            IVirtualFolder rootFolder = this.rootComponent.getRootFolder();
            J2EEModuleVirtualComponent.setDefaultDeploymentDescriptorFolder((IVirtualFolder)rootFolder, (IPath)new Path(this.currentSelectedDDFolder), null);
        }
        return true;
    }

    private IPath[] findAllRootMappings() {
        StructureEdit structureEdit = null;
        try {
            structureEdit = StructureEdit.getStructureEditForRead((IProject)this.rootComponent.getProject());
            WorkbenchComponent component = structureEdit.getComponent();
            Object[] arr = component.getResources().toArray();
            LinkedHashSet<IPath> result = new LinkedHashSet<IPath>();
            int i = 0;
            while (i < arr.length) {
                ComponentResource resource = (ComponentResource)arr[i];
                if (resource.getRuntimePath().equals((Object)IVirtualComponent.ROOT) && !ResourceMappingFilterExtensionRegistry.shouldFilter((IPath)resource.getSourcePath())) {
                    result.add(((ComponentResource)arr[i]).getSourcePath());
                }
                ++i;
            }
            IPath[] iPathArray = result.toArray(new IPath[0]);
            return iPathArray;
        }
        catch (NullPointerException e) {
            J2EEUIPlugin.logError(e);
        }
        finally {
            if (structureEdit != null) {
                structureEdit.dispose();
            }
        }
        return new IPath[0];
    }

    protected boolean shouldDisplaySection() {
        return this.shouldDisplaySection;
    }

    private Composite createAdvancedSection(Composite parent) {
        ExpandableComposite excomposite = new ExpandableComposite(parent, 0, 50);
        excomposite.setText(Messages.J2EEModuleDependenciesPropertyPage_ADVANCED);
        excomposite.setExpanded(false);
        excomposite.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        excomposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        excomposite.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                JavaEEDeploymentAssemblyAdvancedSectionBuilder.this.expandedStateChanged((ExpandableComposite)e.getSource());
            }
        });
        Composite innerComposite = new Composite((Composite)excomposite, 0);
        excomposite.setClient((Control)innerComposite);
        GridLayout gl = new GridLayout(2, false);
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        innerComposite.setLayout((Layout)gl);
        return innerComposite;
    }

    private void addDefaultDeploymentDescriptorFolderFields(Composite parent) {
        this.defaulDDFolderLabel = new Label(parent, 0);
        this.defaulDDFolderLabel.setText(Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_DDFOLDER);
        this.rootSourceMappings = new Combo(parent, 8);
        this.rootSourceMappings.setLayoutData((Object)new GridData(768));
        this.rootSourceMappings.addSelectionListener((SelectionListener)this);
    }

    private final void expandedStateChanged(ExpandableComposite expandable) {
        Composite[] composites = this.getCompositesToResize((Control)expandable);
        ScrolledComposite parentScrolledComposite = (ScrolledComposite)composites[0];
        Composite childComposite = composites[1];
        if (parentScrolledComposite != null && childComposite != null) {
            parentScrolledComposite.layout(true, true);
            parentScrolledComposite.setMinSize(childComposite.computeSize(-1, -1, true));
        }
    }

    private Composite[] getCompositesToResize(Control control) {
        Composite parent = control.getParent();
        Composite previousParent = null;
        Composite[] result = new Composite[2];
        while (!(parent instanceof ScrolledComposite) && parent != null) {
            previousParent = parent;
            parent = parent.getParent();
        }
        if (parent instanceof ScrolledComposite) {
            result[0] = (ScrolledComposite)parent;
        }
        if (previousParent instanceof Composite) {
            result[1] = previousParent;
        }
        return result;
    }

    @Override
    public void directiveAdded(Object element) {
        if (this.shouldDisplaySection()) {
            if (!(element instanceof TaskModel)) {
                return;
            }
            TaskModel model = (TaskModel)element;
            Object folderMapping = model.getObject("folder.mapping");
            if (folderMapping != null && folderMapping instanceof AddModuleDependenciesPropertiesPage.ComponentResourceProxy) {
                AddModuleDependenciesPropertiesPage.ComponentResourceProxy proxy = (AddModuleDependenciesPropertiesPage.ComponentResourceProxy)folderMapping;
                if (proxy.runtimePath.equals((Object)IVirtualComponent.ROOT)) {
                    this.resourceMappingsList.add(proxy.source.toString());
                    this.updateSourceMappingsCombo(this.currentSelectedDDFolder, this.resourceMappingsList);
                }
            }
        }
    }

    @Override
    public void directiveRemoved(Object element) {
        if (this.shouldDisplaySection() && element instanceof AddModuleDependenciesPropertiesPage.ComponentResourceProxy) {
            String proxySource;
            AddModuleDependenciesPropertiesPage.ComponentResourceProxy proxy = (AddModuleDependenciesPropertiesPage.ComponentResourceProxy)element;
            if (proxy.runtimePath.equals((Object)IVirtualComponent.ROOT) && this.resourceMappingsList.contains(proxySource = proxy.source.toString())) {
                this.resourceMappingsList.remove(proxySource);
                if (proxySource.equals(this.currentSelectedDDFolder)) {
                    this.currentSelectedDDFolder = null;
                }
                this.updateSourceMappingsCombo(this.currentSelectedDDFolder, this.resourceMappingsList);
            }
        }
    }

    public void widgetDefaultSelected(SelectionEvent event) {
    }

    public void widgetSelected(SelectionEvent event) {
        String tmp;
        if (event.getSource() == this.rootSourceMappings && (tmp = this.rootSourceMappings.getText()) != null) {
            boolean shouldRefresh;
            if (tmp.equals(Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_NODEFAULTDDFOLDER) && this.currentSelectedDDFolder == null) {
                return;
            }
            if (tmp.equals(Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_NODEFAULTDDFOLDER)) {
                J2EEUIPlugin.logWarning("Unexpected condition when validating deployment descriptor folder");
                return;
            }
            if (this.rootSourceMappings.indexOf(Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_NODEFAULTDDFOLDER) != -1) {
                this.rootSourceMappings.remove(Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_NODEFAULTDDFOLDER);
            }
            boolean bl = shouldRefresh = this.currentSelectedDDFolder == null;
            if (!tmp.equals(this.currentSelectedDDFolder)) {
                this.currentSelectedDDFolder = tmp;
                if (shouldRefresh) {
                    this.page.refresh();
                }
            }
        }
    }

    @Override
    public IStatus validate(IStatus currentStatus) {
        IStatus status;
        IStatus iStatus = status = currentStatus != null ? currentStatus : Status.OK_STATUS;
        if (this.shouldDisplaySection() && this.currentSelectedDDFolder == null && this.resourceMappingsList.size() > 1) {
            int severity = 2;
            status = this.appendStatusMessage(status, Messages.J2EEModuleDependenciesPropertyPage_ADVANCED_NODEFAULTDDFOLDERWARNING, severity);
        }
        return status;
    }

    private IStatus appendStatusMessage(IStatus existingStatus, String message, int severity) {
        MultiStatus multiStatus;
        Status newStatus = new Status(severity, "org.eclipse.jst.j2ee.ui", message);
        int newSeverity = severity;
        if (existingStatus.getSeverity() > severity) {
            newSeverity = existingStatus.getSeverity();
        }
        if (existingStatus instanceof MultiStatus) {
            multiStatus = (MultiStatus)existingStatus;
            multiStatus.merge((IStatus)newStatus);
        } else {
            if (!existingStatus.isMultiStatus() && existingStatus.isOK()) {
                return newStatus;
            }
            IStatus[] children = new IStatus[]{existingStatus, newStatus};
            multiStatus = new MultiStatus("org.eclipse.jst.j2ee.ui", newSeverity, children, null, null);
        }
        return multiStatus;
    }

    @Override
    public void componentResourceModified(AddModuleDependenciesPropertiesPage.ComponentResourceProxy originalResource, AddModuleDependenciesPropertiesPage.ComponentResourceProxy modifiedResource) {
        if (this.shouldDisplaySection()) {
            if (originalResource.runtimePath.isRoot() && !modifiedResource.runtimePath.isRoot()) {
                this.resourceMappingsList.remove(originalResource.source.toString());
                if (originalResource.source.toString().equals(this.currentSelectedDDFolder)) {
                    this.currentSelectedDDFolder = null;
                }
                this.updateSourceMappingsCombo(this.currentSelectedDDFolder, this.resourceMappingsList);
                this.page.refresh();
            } else if (!originalResource.runtimePath.isRoot() && modifiedResource.runtimePath.isRoot()) {
                this.resourceMappingsList.add(originalResource.source.toString());
                this.updateSourceMappingsCombo(this.currentSelectedDDFolder, this.resourceMappingsList);
                this.page.refresh();
            }
        }
    }
}

