/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.core.internal.contenttype;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.content.IContentDescription;
import org.eclipse.core.runtime.content.ITextContentDescriber;
import org.eclipse.wst.html.core.internal.contenttype.HTMLResourceEncodingDetector;
import org.eclipse.wst.sse.core.internal.encoding.EncodingMemento;
import org.eclipse.wst.sse.core.internal.encoding.IContentDescriptionExtended;
import org.eclipse.wst.sse.core.internal.encoding.IResourceCharsetDetector;
import org.eclipse.wst.sse.core.utils.StringUtils;
import org.eclipse.wst.xml.core.internal.parser.XMLTokenizer;

public abstract class AbstractContentDescriberForFacelets
implements ITextContentDescriber {
    private static final QualifiedName[] SUPPORTED_OPTIONS = new QualifiedName[]{IContentDescription.CHARSET, IContentDescription.BYTE_ORDER_MARK, IContentDescriptionExtended.DETECTED_CHARSET, IContentDescriptionExtended.UNSUPPORTED_CHARSET, IContentDescriptionExtended.APPROPRIATE_DEFAULT};

    protected abstract Pattern[] getNSValuePatterns();

    public int describe(InputStream contents, IContentDescription description) throws IOException {
        Object value;
        int result = 1;
        byte[] bom = null;
        if (description != null) {
            this.calculateSupportedOptions(contents, description);
            value = description.getProperty(IContentDescription.BYTE_ORDER_MARK);
            if (value instanceof byte[]) {
                bom = (byte[])value;
            }
        } else {
            contents.reset();
            bom = AbstractContentDescriberForFacelets.getByteOrderMark(contents);
        }
        value = description != null ? description.getProperty(IContentDescription.CHARSET) : null;
        String charsetName = null;
        charsetName = value != null ? value.toString() : (Arrays.equals(IContentDescription.BOM_UTF_16BE, bom) ? "UTF-16BE" : (Arrays.equals(IContentDescription.BOM_UTF_16LE, bom) ? "UTF-16LE" : "UTF-8"));
        contents.reset();
        result = this.checkCriteria(new InputStreamReader(contents, Charset.forName(charsetName)));
        return result;
    }

    public int describe(Reader contents, IContentDescription description) throws IOException {
        int result = 1;
        if (description != null) {
            this.calculateSupportedOptions(contents, description);
        }
        contents.reset();
        result = this.checkCriteria(contents);
        return result;
    }

    public QualifiedName[] getSupportedOptions() {
        return SUPPORTED_OPTIONS;
    }

    private void calculateSupportedOptions(InputStream contents, IContentDescription description) throws IOException {
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            detector.set(contents);
            this.handleCalculations(description, detector);
        }
    }

    private void calculateSupportedOptions(Reader contents, IContentDescription description) throws IOException {
        if (this.isRelevent(description)) {
            IResourceCharsetDetector detector = this.getDetector();
            detector.set(contents);
            this.handleCalculations(description, detector);
        }
    }

    private IResourceCharsetDetector getDetector() {
        return new HTMLResourceEncodingDetector();
    }

    private void handleCalculations(IContentDescription description, IResourceCharsetDetector detector) throws IOException {
        Object existingCharset;
        Object existingByteOrderMark;
        EncodingMemento encodingMemento = ((HTMLResourceEncodingDetector)detector).getEncodingMemento();
        byte[] detectedByteOrderMark = encodingMemento.getUnicodeBOM();
        if (detectedByteOrderMark != null && !detectedByteOrderMark.equals(existingByteOrderMark = description.getProperty(IContentDescription.BYTE_ORDER_MARK))) {
            description.setProperty(IContentDescription.BYTE_ORDER_MARK, (Object)detectedByteOrderMark);
        }
        if (!encodingMemento.isValid()) {
            description.setProperty(IContentDescriptionExtended.UNSUPPORTED_CHARSET, (Object)encodingMemento.getInvalidEncoding());
            description.setProperty(IContentDescriptionExtended.APPROPRIATE_DEFAULT, (Object)encodingMemento.getAppropriateDefault());
        }
        String detectedCharset = encodingMemento.getDetectedCharsetName();
        String javaCharset = encodingMemento.getJavaCharsetName();
        if (detectedCharset != null) {
            description.setProperty(IContentDescriptionExtended.DETECTED_CHARSET, (Object)detectedCharset);
        }
        if (javaCharset != null && !javaCharset.equals(existingCharset = description.getProperty(IContentDescription.CHARSET))) {
            String defaultCharset = detector.getSpecDefaultEncoding();
            if (defaultCharset != null) {
                if (!defaultCharset.equals(javaCharset)) {
                    description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
                }
            } else {
                description.setProperty(IContentDescription.CHARSET, (Object)javaCharset);
            }
        }
    }

    private boolean isRelevent(IContentDescription description) {
        boolean result = false;
        if (description != null) {
            if (description.isRequested(IContentDescription.BYTE_ORDER_MARK)) {
                result = true;
            } else if (description.isRequested(IContentDescription.CHARSET)) {
                result = true;
            } else if (description.isRequested(IContentDescriptionExtended.APPROPRIATE_DEFAULT)) {
                result = true;
            } else if (description.isRequested(IContentDescriptionExtended.DETECTED_CHARSET)) {
                result = true;
            } else if (description.isRequested(IContentDescriptionExtended.UNSUPPORTED_CHARSET)) {
                result = true;
            }
        }
        return result;
    }

    private int checkCriteria(Reader contents) throws IOException {
        Pattern[] nsValuePatterns = this.getNSValuePatterns();
        if (nsValuePatterns == null || nsValuePatterns.length == 0) {
            return 0;
        }
        Pattern nsNamePattern = Pattern.compile("xmlns:.*");
        String attributeName = null;
        String attributeValue = null;
        XMLTokenizer tokenizer = new XMLTokenizer(contents);
        String token = tokenizer.primGetNextToken();
        while (token != null && !"XML_TAG_CLOSE".equals(token) && !"XML_EMPTY_TAG_CLOSE".equals(token)) {
            if ("XML_TAG_ATTRIBUTE_NAME".equals(token)) {
                attributeName = tokenizer.yytext();
            } else if ("XML_TAG_ATTRIBUTE_VALUE".equals(token)) {
                attributeValue = StringUtils.strip((String)tokenizer.yytext());
                int i = 0;
                while (i < nsValuePatterns.length) {
                    if (nsNamePattern.matcher(attributeName).matches() && nsValuePatterns[i].matcher(attributeValue).matches()) {
                        return 2;
                    }
                    ++i;
                }
            }
            token = tokenizer.primGetNextToken();
        }
        return 0;
    }

    private static byte[] getByteOrderMark(InputStream contents) throws IOException {
        int first = contents.read();
        if (first == 239) {
            int second = contents.read();
            int third = contents.read();
            if (second == 187 && third == 191) {
                return IContentDescription.BOM_UTF_8;
            }
        } else if (first == 254) {
            if (contents.read() == 255) {
                return IContentDescription.BOM_UTF_16BE;
            }
        } else if (first == 255 && contents.read() == 254) {
            return IContentDescription.BOM_UTF_16LE;
        }
        return null;
    }
}

