/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.designtime.symbols;

import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jst.jsf.common.internal.types.ValueType;
import org.eclipse.jst.jsf.context.structureddocument.IStructuredDocumentContext;
import org.eclipse.jst.jsf.context.symbol.ERuntimeSource;
import org.eclipse.jst.jsf.context.symbol.ISymbol;
import org.eclipse.jst.jsf.core.internal.JSFCorePlugin;
import org.eclipse.jst.jsf.designtime.symbols.JSFSymbolFactory;
import org.eclipse.jst.jsf.designtime.symbols.Messages;
import org.eclipse.jst.jsf.validation.internal.appconfig.AppConfigValidationUtil;
import org.w3c.dom.Element;

public abstract class AbstractDataModelVariableFactory {
    private final JSFSymbolFactory _symbolFactory = new JSFSymbolFactory();

    public final ValueType createValueExpression(String elText, IStructuredDocumentContext elContext, IFile file) {
        return this.getSymbolFactory().getValueTypeFromEL(elText, elContext, file);
    }

    public final JSFSymbolFactory getSymbolFactory() {
        return this._symbolFactory;
    }

    protected final ISymbol createArraySymbol(String symbolName, String signature, IJavaProject javaProject) {
        return this.getSymbolFactory().createArraySymbol(symbolName, signature, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, javaProject);
    }

    public ISymbol createFromType(String symbolName, ValueType valueType, IJavaProject javaProject) {
        return this.internalCreateFromBaseType(symbolName, valueType, javaProject);
    }

    private ISymbol internalCreateFromBaseType(String symbolName, ValueType valueType, IJavaProject javaProject) {
        if (Signature.getArrayCount((String)valueType.getSignature()) > 0) {
            return this.getSymbolFactory().createArraySymbol(symbolName, valueType.getSignature(), ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, javaProject);
        }
        if (valueType.isInstanceOf("Ljava.util.List;")) {
            return this.getSymbolFactory().createFromList(symbolName, valueType, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, null, javaProject);
        }
        if (valueType.isInstanceOf("Ljavax.servlet.jsp.jstl.sql.Result;") || valueType.isInstanceOf("Ljava.sql.ResultSet;") || valueType.isInstanceOf("Ljavax.faces.model.DataModel;")) {
            return this.getSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, Messages.getString("AbstractDataModelVariableFactory.DataModel.Symbol.RowVariable.DetailedDescription"));
        }
        return this.getSymbolFactory().createScalarSymbol(symbolName, valueType.getSignature(), ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, javaProject);
    }

    protected final ISymbol createFromList(String symbolName, ValueType valueType, IJavaProject javaProject) {
        return this.getSymbolFactory().createFromList(symbolName, valueType, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, null, javaProject);
    }

    protected final ISymbol createScalarSymbol(String symbolName, String signature, IJavaProject javaProject) {
        return this.getSymbolFactory().createScalarSymbol(symbolName, signature, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, javaProject);
    }

    public final ISymbol createDefaultSymbol(String symbolName) {
        return this.getSymbolFactory().createDefaultSymbol(symbolName, ERuntimeSource.TAG_INSTANTIATED_SYMBOL_LITERAL, Messages.getString("AbstractDataModelVariableFactory.DataModel.Symbol.RowVariable.DetailedDescription"));
    }

    protected static String getELText(Element dataTableElement) {
        assert (dataTableElement != null);
        String attrVal = dataTableElement.getAttribute("value");
        if (attrVal != null) {
            return AppConfigValidationUtil.extractELExpression(attrVal).getElText();
        }
        return null;
    }

    protected final String internalGetVariableSourceName() {
        String variableSourceName = this.getVariableSourceName();
        if (variableSourceName == null) {
            JSFCorePlugin.log("Missing variableSourceName", new Throwable());
            return "**missing variable source name**";
        }
        return variableSourceName;
    }

    protected abstract String getVariableSourceName();
}

