/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.taglibprocessing.attributevalues;

import java.util.List;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.Messages;
import org.eclipse.jst.jsf.taglibprocessing.attributevalues.NumberType;
import org.eclipse.osgi.util.NLS;

public class LongType
extends NumberType {
    private static final String INVALID_LONG = Messages.LongType_invalid_long;

    @Override
    protected String getReturnType() {
        return "long";
    }

    @Override
    public boolean isValidValue(String value) {
        try {
            List validVals;
            Long aLong = Long.valueOf(value);
            this.exceedsMaxValue(aLong);
            this.lessThanMinValue(aLong);
            if (!(this.minFound || this.maxFound || (validVals = this.getMDValidValues()).isEmpty() || validVals.contains(value))) {
                this.addNewValidationMessage(Messages.LongType_invalid_member);
            }
            return this.getValidationMessages().isEmpty();
        }
        catch (NumberFormatException numberFormatException) {
            this.addNewValidationMessage(INVALID_LONG);
            return false;
        }
    }

    private void exceedsMaxValue(long aLong) {
        String strMax = this.getValidMaximumValue();
        if (strMax != null) {
            try {
                long max = Long.valueOf(strMax);
                this.maxFound = true;
                if (aLong > max) {
                    this.addNewValidationMessage(NLS.bind((String)this.EXCEEDS_MAX, (Object)strMax));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }

    private void lessThanMinValue(long aLong) {
        String strMin = this.getValidMinimumValue();
        if (strMin != null) {
            try {
                long min = Long.valueOf(strMin);
                this.minFound = true;
                if (aLong < min) {
                    this.addNewValidationMessage(NLS.bind((String)this.LESS_THAN_MIN, (Object)strMin));
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
    }
}

