/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.facesconfig.ui.pageflow.editpart;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Text;

final class PageflowDirectEditManager
extends DirectEditManager {
    private Font scaledFont;
    private VerifyListener verifyListener;
    private final Label label;

    public PageflowDirectEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, Label label) {
        super(source, editorType, locator);
        this.label = label;
    }

    protected void bringDown() {
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null && !disposeFont.isDisposed()) {
            disposeFont.dispose();
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text_ = (Text)PageflowDirectEditManager.this.getCellEditor().getControl();
                String oldText = text_.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text_);
                Point size = gc.textExtent(leftText + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text_.computeSize(size.x, -1);
                }
                PageflowDirectEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        String initialLabelText = this.label.getText();
        this.getCellEditor().setValue((Object)initialLabelText);
        IFigure figure = this.getEditPart().getFigure();
        Font figureFont = figure.getFont();
        FontData data = figureFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.label.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        if (this.scaledFont != null && !this.scaledFont.isDisposed()) {
            this.scaledFont.dispose();
        }
        this.scaledFont = new Font(figureFont.getDevice(), data);
        text.setFont(this.scaledFont);
        text.selectAll();
    }

    protected void unhookListeners() {
        super.unhookListeners();
        Text text = (Text)this.getCellEditor().getControl();
        text.removeVerifyListener(this.verifyListener);
        this.verifyListener = null;
    }
}

