/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsp.ui.internal.format;

import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.jface.text.TypedPosition;
import org.eclipse.jface.text.formatter.ContextBasedFormattingStrategy;
import org.eclipse.jface.text.formatter.IFormattingContext;
import org.eclipse.jst.jsp.core.internal.Logger;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslation;
import org.eclipse.jst.jsp.core.internal.java.JSPTranslationUtil;
import org.eclipse.text.edits.MalformedTreeException;
import org.eclipse.text.edits.TextEdit;

public class FormattingStrategyJSPJava
extends ContextBasedFormattingStrategy {
    private final LinkedList fDocuments = new LinkedList();
    private final LinkedList fPartitions = new LinkedList();
    JSPTranslation translation = null;

    public void format() {
        super.format();
        IDocument document = (IDocument)this.fDocuments.removeFirst();
        TypedPosition partition = (TypedPosition)this.fPartitions.removeFirst();
        if (document != null && partition != null) {
            try {
                JSPTranslationUtil translationUtil = new JSPTranslationUtil(document);
                ICompilationUnit cu = translationUtil.getCompilationUnit();
                if (cu != null) {
                    String cuSource = cu.getSource();
                    TextEdit textEdit = this.formatString(8, cuSource, translationUtil.getTranslation().getJavaOffset(partition.getOffset()), partition.getLength(), TextUtilities.getDefaultLineDelimiter((IDocument)document), this.getPreferences());
                    TextEdit jspEdit = translationUtil.getTranslation().getJspEdit(textEdit);
                    if (jspEdit != null && jspEdit.hasChildren()) {
                        jspEdit.apply(document);
                    }
                }
            }
            catch (MalformedTreeException exception) {
                Logger.logException((Throwable)exception);
            }
            catch (BadLocationException exception) {
                Logger.logException((Throwable)exception);
            }
            catch (JavaModelException exception) {
                Logger.logException((Throwable)exception);
            }
        }
    }

    private TextEdit formatString(int kind, String cuSource, int javaOffset, int length, String defaultLineDelimiter, Map preferences) {
        return ToolFactory.createCodeFormatter((Map)preferences).format(kind, cuSource, javaOffset, length, 0, defaultLineDelimiter);
    }

    public void formatterStarts(IFormattingContext context) {
        super.formatterStarts(context);
        this.fPartitions.addLast(context.getProperty((Object)"formatting.context.partition"));
        this.fDocuments.addLast(context.getProperty((Object)"formatting.context.medium"));
    }

    public void formatterStops() {
        super.formatterStops();
        this.fPartitions.clear();
        this.fDocuments.clear();
    }

    public TextEdit formatString(int kind, String string, int indentationLevel, String lineSeparator, Map options) {
        return ToolFactory.createCodeFormatter((Map)options).format(kind, string, 0, string.length(), indentationLevel, lineSeparator);
    }
}

