/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions;

import java.util.Vector;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jem.java.Method;
import org.eclipse.jst.ws.internal.consumption.ConsumptionMessages;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.DetectNonJavaCharsParameterVisitorAction;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitoractions.VisitorActionImpl;
import org.eclipse.jst.ws.internal.consumption.codegen.javamofvisitors.JavaMofParameterVisitor;

public class DetectNonJavaCharsMethodVisitorAction
extends VisitorActionImpl {
    private static char UNDERSCORE = (char)95;
    private boolean serviceBean = false;

    public DetectNonJavaCharsMethodVisitorAction(Vector messages, Vector beans) {
        super(messages, beans);
        if (beans.size() == 1) {
            this.serviceBean = true;
        }
    }

    @Override
    public IStatus visit(Object imethod) {
        Method method = (Method)imethod;
        String className = method.getContainingJavaClass().getName();
        String name = method.getName();
        if (this.serviceBean && !method.isConstructor()) {
            this.checkUpperCase(name, className);
        }
        if (this.serviceBean || name.startsWith("get") || name.startsWith("set") || name.startsWith("is")) {
            this.checkUnderScore(name, className);
            this.checkNumericDigits(name, className);
            this.checkBooleanProperties(method, className);
            DetectNonJavaCharsParameterVisitorAction parameterVisitorAction = new DetectNonJavaCharsParameterVisitorAction(this.getMessages(), this.getBeansVisited());
            JavaMofParameterVisitor parameterVisitor = new JavaMofParameterVisitor(null);
            parameterVisitor.run(method, parameterVisitorAction);
        }
        return Status.OK_STATUS;
    }

    private void checkUpperCase(String name, String className) {
        if (Character.isUpperCase(name.charAt(0))) {
            this.addMessage(ConsumptionMessages.MSG_WARN_JAVA_METHOD_START_WITH_UPPER_CASE, new String[]{name, className});
        }
    }

    private void checkUnderScore(String name, String className) {
        int underScoreIndex = name.indexOf(UNDERSCORE);
        String tempName = name;
        while (underScoreIndex != -1) {
            if (Character.isLowerCase((tempName = tempName.substring(underScoreIndex + 1)).charAt(0))) {
                this.addMessage(ConsumptionMessages.MSG_WARN_METHOD_NAME_INVALID, new String[]{name, className});
                break;
            }
            underScoreIndex = tempName.indexOf(UNDERSCORE);
        }
    }

    private void checkNumericDigits(String name, String className) {
        int i = 0;
        while (i < name.length()) {
            if (Character.isDigit(name.charAt(i)) && Character.isLowerCase(name.charAt(i + 1))) {
                this.addMessage(ConsumptionMessages.MSG_WARN_METHOD_NAME_INVALID, new String[]{name, className});
                break;
            }
            ++i;
        }
    }

    private void checkBooleanProperties(Method method, String className) {
        if (!this.serviceBean && method.getName().startsWith("get") && (method.getReturnType().getName().equals("boolean") || method.getReturnType().getName().equals("java.lang.Boolean"))) {
            this.addMessage(ConsumptionMessages.MSG_WARN_BOOLEAN_PROPERTY_ACCESSORS, new String[]{method.getName(), className});
        }
    }
}

