/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.parser;

import java.io.DataInput;
import java.io.IOException;
import java.io.PrintStream;
import org.eclipse.cdt.core.IBinaryParser;
import org.eclipse.linuxtools.internal.gprof.Messages;
import org.eclipse.linuxtools.internal.gprof.parser.GmonDecoder;
import org.eclipse.linuxtools.internal.gprof.symbolManager.Bucket;
import org.eclipse.linuxtools.internal.gprof.view.histogram.HistRoot;

public class HistogramDecoder {
    private static final int GMON_HDRSIZE_BSD44 = 12;
    private static final int GMON_HDRSIZE_BSD44_32 = 32;
    private static final int GMON_HDRSIZE_BSD44_64 = 40;
    private static final int GMON_HDRSIZE_OLDBSD_32 = 12;
    private static final int GMON_HDRSIZE_OLDBSD_64 = 20;
    protected final GmonDecoder decoder;
    protected long lowpc;
    protected long highpc;
    protected int profRate;
    protected char dimenAbbrev;
    private boolean initialized = false;
    protected int[] hist_sample;
    protected double total_time;
    protected long bucketSize;

    public HistogramDecoder(GmonDecoder decoder) {
        this.decoder = decoder;
    }

    protected long readAddress(DataInput stream) throws IOException {
        return (long)stream.readInt() & 0xFFFFFFFFL;
    }

    public boolean hasValues() {
        return this.hist_sample != null && this.hist_sample.length > 0;
    }

    public void decodeHeader(DataInput stream) throws IOException {
        long lowpc = this.readAddress(stream);
        long highpc = this.readAddress(stream);
        int hist_num_bins = stream.readInt();
        int prof_rate = stream.readInt();
        byte[] bytes = new byte[15];
        stream.readFully(bytes);
        byte b = stream.readByte();
        if (!this.isCompatible(lowpc, highpc, prof_rate, hist_num_bins)) {
            throw new RuntimeException(Messages.HistogramDecoder_INCOMPATIBLE_HIST_HEADER_ERROR_MSG);
        }
        this.lowpc = lowpc;
        this.highpc = highpc;
        this.profRate = prof_rate;
        this.hist_sample = new int[hist_num_bins];
        this.dimenAbbrev = (char)b;
        long temp = highpc - lowpc;
        this.bucketSize = Math.round((double)temp / (double)hist_num_bins);
    }

    public void decodeOldHeader(DataInput stream) throws IOException {
        int headerSize;
        long lowPC = this.readAddress(stream);
        long highPC = this.readAddress(stream);
        int ncnt = stream.readInt();
        int version = stream.readInt();
        int profrate = 0;
        if (version == 333945) {
            profrate = stream.readInt();
            stream.skipBytes(12);
            headerSize = this.decoder._32_bit_platform ? 32 : 40;
        } else {
            headerSize = this.decoder._32_bit_platform ? 12 : 20;
        }
        int sampBytes = ncnt - headerSize;
        int histNumBins = sampBytes / 2;
        if (!this.isCompatible(lowPC, highPC, profrate, histNumBins)) {
            throw new RuntimeException(Messages.HistogramDecoder_INCOMPATIBLE_HIST_HEADER_ERROR_MSG);
        }
        this.lowpc = lowPC;
        this.highpc = highPC;
        this.profRate = profrate;
        this.hist_sample = new int[histNumBins];
        this.dimenAbbrev = (char)115;
        long temp = this.highpc - this.lowpc;
        this.bucketSize = Math.round((double)temp / (double)histNumBins);
    }

    private boolean isCompatible(long lowpc, long highpc, int profrate, int sampleCount) {
        if (!this.initialized) {
            return true;
        }
        return this.lowpc == lowpc && this.highpc == highpc && this.profRate == profrate && this.hist_sample.length == sampleCount;
    }

    public void decodeHistRecord(DataInput stream) throws IOException {
        for (int i = 0; i < this.hist_sample.length; ++i) {
            short rv = stream.readShort();
            if (rv == 0) continue;
            int hist_size = rv & 0xFFFF;
            int n = i;
            this.hist_sample[n] = this.hist_sample[n] + hist_size;
        }
    }

    public void printHistHeader(PrintStream ps) {
        ps.println(" \nHistogram Header : \n");
        ps.print("  Base pc address of sample buffer = 0x");
        ps.println(Long.toHexString(this.lowpc));
        ps.print("  Max pc address of sampled buffer = 0x");
        ps.println(Long.toHexString(this.highpc));
        ps.print("  Number of histogram samples      = ");
        ps.println(this.hist_sample.length);
        ps.print("  Profiling clock rate             = ");
        ps.println(this.profRate);
        ps.print("  Physical dimension abreviation : 's' for \"seconds\"  'm' for \"milliseconds\" = ");
        ps.println(this.dimenAbbrev);
    }

    public void printHistRecords(PrintStream ps) {
        ps.println();
        ps.println(" ==  HISTOGRAM RECORDS  == ");
        ps.println(" ========================= ");
        this.printHistHeader(ps);
    }

    public void assignSamplesSymbol() {
        if (this.hist_sample == null || this.hist_sample.length == 0) {
            return;
        }
        IBinaryParser.ISymbol[] symblist = this.decoder.getProgram().getSymbols();
        int j = 1;
        block0: for (int i = 0; i < this.hist_sample.length; ++i) {
            int ccnt = this.hist_sample[i];
            if (ccnt == 0) continue;
            long pcl = this.lowpc + this.bucketSize * (long)i;
            long pch = pcl + this.bucketSize;
            this.total_time += (double)ccnt;
            long svalue1 = symblist[j - 1].getAddress().getValue().longValue();
            --j;
            while (j < symblist.length - 1) {
                long start_addr;
                long end_addr;
                long overlap;
                long svalue0 = svalue1;
                svalue1 = symblist[j + 1].getAddress().getValue().longValue();
                if (pch < svalue0) continue block0;
                if (pcl < svalue1 && (overlap = (end_addr = pch < svalue1 ? pch : svalue1) - (start_addr = pcl > svalue0 ? pcl : svalue0)) > 0L) {
                    IBinaryParser.ISymbol symbol = symblist[j];
                    int time = (int)(overlap * (long)ccnt / this.bucketSize);
                    Bucket bck = new Bucket(start_addr, end_addr, time);
                    this.addBucket(bck, symbol);
                }
                ++j;
            }
        }
    }

    private void addBucket(Bucket b, IBinaryParser.ISymbol s) {
        HistRoot root = this.decoder.getRootNode();
        root.addBucket(b, s, this.decoder.getProgram());
    }

    public int getProfRate() {
        return this.profRate;
    }

    public char getTimeDimension() {
        return this.dimenAbbrev;
    }

    public long getBucketSize() {
        return this.bucketSize;
    }
}

