/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.linuxtools.internal.gprof.utils;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;

public class LEDataInputStream
extends FilterInputStream
implements DataInput {
    private final DataInputStream in;
    private final byte[] buffer = new byte[8];

    public LEDataInputStream(DataInputStream in) {
        super(in);
        this.in = in;
    }

    @Override
    public final short readShort() throws IOException {
        this.in.readFully(this.buffer, 0, 2);
        return (short)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        this.in.readFully(this.buffer, 0, 2);
        return (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    @Override
    public final char readChar() throws IOException {
        this.in.readFully(this.buffer, 0, 2);
        return (char)((this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF);
    }

    @Override
    public final int readInt() throws IOException {
        this.in.readFully(this.buffer, 0, 4);
        return this.buffer[3] << 24 | (this.buffer[2] & 0xFF) << 16 | (this.buffer[1] & 0xFF) << 8 | this.buffer[0] & 0xFF;
    }

    @Override
    public final long readLong() throws IOException {
        this.in.readFully(this.buffer, 0, 8);
        return (long)this.buffer[7] << 56 | (long)(this.buffer[6] & 0xFF) << 48 | (long)(this.buffer[5] & 0xFF) << 40 | (long)(this.buffer[4] & 0xFF) << 32 | (long)(this.buffer[3] & 0xFF) << 24 | (long)(this.buffer[2] & 0xFF) << 16 | (long)(this.buffer[1] & 0xFF) << 8 | (long)(this.buffer[0] & 0xFF);
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.in.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.in.readFully(b, off, len);
    }

    @Override
    @Deprecated
    public String readLine() throws IOException {
        return this.in.readLine();
    }

    @Override
    public String readUTF() throws IOException {
        return this.in.readUTF();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.in.readUnsignedByte();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.in.skipBytes(n);
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }
}

