/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.m2e.core.ui.internal.M2EUIPluginActivator;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MavenPropertyDialog
extends Dialog {
    private static final String DIALOG_SETTINGS = MavenPropertyDialog.class.getName();
    private final String title;
    private final String initialName;
    private final String initialValue;
    private final VerifyListener verifyListener;
    protected Text nameText;
    protected Text valueText;
    private String name;
    private String value;

    public MavenPropertyDialog(Shell shell, String title, String initialName, String initialValue, VerifyListener verifyListener) {
        super(shell);
        this.title = title;
        this.initialName = initialName;
        this.initialValue = initialValue;
        this.verifyListener = verifyListener;
    }

    protected Control createDialogArea(Composite parent) {
        Composite comp = new Composite(parent, 0);
        comp.setLayoutData((Object)new GridData(768));
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginTop = 7;
        gridLayout.marginWidth = 12;
        comp.setLayout((Layout)gridLayout);
        Label nameLabel = new Label(comp, 0);
        nameLabel.setText(Messages.launchPropertyDialogName);
        nameLabel.setFont(comp.getFont());
        this.nameText = new Text(comp, 2052);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        this.nameText.setLayoutData((Object)gd);
        this.nameText.setFont(comp.getFont());
        this.nameText.setText(this.initialName == null ? "" : this.initialName);
        this.nameText.addModifyListener(e -> this.updateButtons());
        Label valueLabel = new Label(comp, 0);
        valueLabel.setText(Messages.launchPropertyDialogValue);
        valueLabel.setFont(comp.getFont());
        this.valueText = new Text(comp, 2052);
        gd = new GridData(768);
        gd.widthHint = 300;
        this.valueText.setLayoutData((Object)gd);
        this.valueText.setFont(comp.getFont());
        this.valueText.setText(this.initialValue == null ? "" : this.initialValue);
        this.valueText.addModifyListener(e -> this.updateButtons());
        return comp;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.name = this.nameText.getText();
            this.value = this.valueText.getText();
        } else {
            this.name = null;
            this.value = null;
        }
        super.buttonPressed(buttonId);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected void updateButtons() {
        String name = this.nameText.getText().trim();
        String value = this.valueText.getText().trim();
        Event e = new Event();
        e.widget = this.nameText;
        VerifyEvent ev = new VerifyEvent(e);
        ev.doit = true;
        if (this.verifyListener != null) {
            ev.text = name;
            this.verifyListener.verifyText(ev);
        }
        this.getButton(0).setEnabled(name.length() > 0 && value.length() > 0 && ev.doit);
    }

    public void create() {
        super.create();
        this.updateButtons();
    }

    protected boolean isResizable() {
        return true;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings pluginSettings = M2EUIPluginActivator.getDefault().getDialogSettings();
        IDialogSettings dialogSettings = pluginSettings.getSection(DIALOG_SETTINGS);
        if (dialogSettings == null) {
            dialogSettings = new DialogSettings(DIALOG_SETTINGS);
            pluginSettings.addSection(dialogSettings);
        }
        return dialogSettings;
    }
}

