/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.core.ui.internal.dialogs;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.ui.internal.MavenImages;
import org.eclipse.m2e.core.ui.internal.Messages;
import org.eclipse.m2e.core.ui.internal.components.NestedProjectsComposite;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class UpdateMavenProjectsDialog
extends TitleAreaDialog {
    private NestedProjectsComposite nestedProjectsComposite;
    private Button offlineModeBtn;
    private Button forceUpdateBtn;
    private final IProject[] initialSelection;
    private List<IProject> selectedProjects;
    private boolean offlineMode;
    private boolean forceUpdateDependencies;
    private boolean updateConfiguration;
    private boolean cleanProjects;
    private boolean refreshFromLocal;
    protected String dialogTitle;
    protected String dialogMessage;
    private Button btnUpdateProjectConfiguration;
    private Button btnCleanProjects;
    private Button btnRefreshFromLocal;

    public UpdateMavenProjectsDialog(Shell parentShell, IProject[] initialSelection) {
        super(parentShell);
        this.initialSelection = initialSelection;
        this.dialogTitle = Messages.UpdateMavenProjectDialog_title;
        this.dialogMessage = Messages.UpdateMavenProjectDialog_dialogMessage;
        this.offlineMode = MavenPlugin.getMavenConfiguration().isOffline();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.getDialogTitle());
    }

    protected Control createDialogArea(Composite parent) {
        Composite area = (Composite)super.createDialogArea(parent);
        GridLayout gridLayout = (GridLayout)area.getLayout();
        gridLayout.verticalSpacing = 5;
        gridLayout.marginBottom = 5;
        gridLayout.marginRight = 5;
        gridLayout.marginLeft = 5;
        this.nestedProjectsComposite = new NestedProjectsComposite(area, 0, this.initialSelection, true);
        this.nestedProjectsComposite.setLayoutData(new GridData(4, 4, true, true, 1, 1));
        Composite optionsComposite = new Composite(area, 0);
        optionsComposite.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        GridLayout gl_optionsComposite = new GridLayout(1, false);
        gl_optionsComposite.marginHeight = 0;
        gl_optionsComposite.marginWidth = 0;
        optionsComposite.setLayout((Layout)gl_optionsComposite);
        this.offlineModeBtn = new Button(optionsComposite, 32);
        this.offlineModeBtn.setText(Messages.UpdateDepenciesDialog_offline);
        this.offlineModeBtn.setSelection(this.offlineMode);
        Button btnCheckButton = new Button(optionsComposite, 32);
        btnCheckButton.setEnabled(false);
        btnCheckButton.setSelection(true);
        btnCheckButton.setText(Messages.UpdateMavenProjectDialog_btnCheckButton_text);
        this.forceUpdateBtn = new Button(optionsComposite, 32);
        GridData gd_forceUpdateBtn = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_forceUpdateBtn.horizontalIndent = 15;
        this.forceUpdateBtn.setLayoutData((Object)gd_forceUpdateBtn);
        this.forceUpdateBtn.setText(Messages.UpdateDepenciesDialog_forceUpdate);
        this.btnUpdateProjectConfiguration = new Button(optionsComposite, 32);
        this.btnUpdateProjectConfiguration.setSelection(true);
        this.btnUpdateProjectConfiguration.setText(Messages.UpdateMavenProjectDialog_btnUpdateProjectConfiguration_text);
        this.btnRefreshFromLocal = new Button(optionsComposite, 32);
        this.btnRefreshFromLocal.setSelection(true);
        this.btnRefreshFromLocal.setText(Messages.UpdateMavenProjectsDialog_btnRefreshFromLocal_text);
        this.btnCleanProjects = new Button(optionsComposite, 32);
        this.btnCleanProjects.setSelection(true);
        this.btnCleanProjects.setText(Messages.UpdateMavenProjectDialog_btnCleanProjects_text);
        this.setTitle(this.getDialogTitle());
        this.setMessage(this.getDialogMessage());
        Image image = MavenImages.WIZ_UPDATE_PROJECT.createImage();
        this.setTitleImage(image);
        area.addDisposeListener(e -> image.dispose());
        return area;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
    }

    protected void okPressed() {
        this.selectedProjects = this.nestedProjectsComposite.getSelectedProjects();
        this.offlineMode = this.offlineModeBtn.getSelection();
        this.forceUpdateDependencies = this.forceUpdateBtn.getSelection();
        this.updateConfiguration = this.btnUpdateProjectConfiguration.getSelection();
        this.cleanProjects = this.btnCleanProjects.getSelection();
        this.refreshFromLocal = this.btnRefreshFromLocal.getSelection();
        super.okPressed();
    }

    public List<IProject> getSelectedProjects() {
        return this.selectedProjects;
    }

    public boolean isOffline() {
        return this.offlineMode;
    }

    public boolean isForceUpdateDependencies() {
        return this.forceUpdateDependencies;
    }

    public boolean isUpdateConfiguration() {
        return this.updateConfiguration;
    }

    public boolean isCleanProjects() {
        return this.cleanProjects;
    }

    public boolean isRefreshFromLocal() {
        return this.refreshFromLocal;
    }

    public String getDialogTitle() {
        if (this.dialogTitle == null) {
            this.dialogTitle = "";
        }
        return this.dialogTitle;
    }

    public String getDialogMessage() {
        if (this.dialogMessage == null) {
            this.dialogMessage = "";
        }
        return this.dialogMessage;
    }

    public void setDialogTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    public void setDialogMessage(String dialogMessage) {
        this.dialogMessage = dialogMessage;
    }
}

