/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.editor.lemminx.bnd;

import aQute.bnd.help.Syntax;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.wildwebdeveloper.xml.LemminxClasspathExtensionProvider;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;

public class BndClasspathExtensionProvider
implements LemminxClasspathExtensionProvider {
    public List<File> get() {
        ArrayList<File> list = new ArrayList<File>();
        LinkedHashSet<Bundle> bundleRequirements = new LinkedHashSet<Bundle>();
        bundleRequirements.add(FrameworkUtil.getBundle(this.getClass()));
        this.collectBundles(FrameworkUtil.getBundle(Syntax.class), bundleRequirements);
        for (Bundle bundle : bundleRequirements) {
            FileLocator.getBundleFileLocation((Bundle)bundle).ifPresent(file -> {
                File outputFolder;
                if (file.isDirectory() && (outputFolder = new File((File)file, "bin")).exists()) {
                    list.add(outputFolder);
                }
                list.add((File)file);
            });
        }
        return list;
    }

    private void collectBundles(Bundle bundle, Set<Bundle> bundleRequirements) {
        if (this.isValid(bundle) && bundleRequirements.add(bundle)) {
            BundleWiring wiring = (BundleWiring)bundle.adapt(BundleWiring.class);
            List wires = wiring.getRequiredWires("osgi.wiring.package");
            for (BundleWire bundleWire : wires) {
                this.collectBundles(bundleWire.getProvider().getBundle(), bundleRequirements);
            }
        }
    }

    private boolean isValid(Bundle bundle) {
        if (bundle == null) {
            return false;
        }
        String bsn = bundle.getSymbolicName();
        return !"slf4j.api".equals(bsn);
    }
}

