/*
 Licensed to the Apache Software Foundation (ASF) under one
 or more contributor license agreements.  See the NOTICE file
 distributed with this work for additional information
 regarding copyright ownership.  The ASF licenses this file
 to you under the Apache License, Version 2.0 (the
 "License"); you may not use this file except in compliance
 with the License.  You may obtain a copy of the License at
 
     http://www.apache.org/licenses/LICENSE-2.0
 
 Unless required by applicable law or agreed to in writing,
 software distributed under the License is distributed on an
 "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 KIND, either express or implied.  See the License for the
 specific language governing permissions and limitations
 under the License.
 =================== DO NOT EDIT THIS FILE ====================
 Generated by Modello 2.5.1,
 any modifications will be overwritten.
 ==============================================================
 */

package org.apache.maven.toolchain.model.io.xpp3;

  //---------------------------------/
 //- Imported classes and packages -/
//---------------------------------/

import java.io.OutputStream;
import java.io.Writer;
import java.util.Iterator;
import org.apache.maven.toolchain.model.PersistedToolchains;
import org.apache.maven.toolchain.model.ToolchainModel;
import org.apache.maven.toolchain.model.TrackableBase;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.pull.MXSerializer;
import org.codehaus.plexus.util.xml.pull.XmlSerializer;

/**
 * Class MavenToolchainsXpp3Writer.
 * 
 * @version $Revision$ $Date$
 */
@SuppressWarnings( "all" )
public class MavenToolchainsXpp3Writer
{

      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field NAMESPACE.
     */
    private static final String NAMESPACE = null;

    /**
     * Field fileComment.
     */
    private String fileComment = null;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Method setFileComment.
     * 
     * @param fileComment a fileComment object.
     */
    public void setFileComment( String fileComment )
    {
        this.fileComment = fileComment;
    } //-- void setFileComment( String )

    /**
     * Method write.
     * 
     * @param writer a writer object.
     * @param persistedToolchains a persistedToolchains object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( Writer writer, PersistedToolchains persistedToolchains )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( writer );
        serializer.startDocument( persistedToolchains.getModelEncoding(), null );
        writePersistedToolchains( persistedToolchains, "toolchains", serializer );
        serializer.endDocument();
    } //-- void write( Writer, PersistedToolchains )

    /**
     * Method write.
     * 
     * @param stream a stream object.
     * @param persistedToolchains a persistedToolchains object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    public void write( OutputStream stream, PersistedToolchains persistedToolchains )
        throws java.io.IOException
    {
        XmlSerializer serializer = new MXSerializer();
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-indentation", "  " );
        serializer.setProperty( "http://xmlpull.org/v1/doc/properties.html#serializer-line-separator", "\n" );
        serializer.setOutput( stream, persistedToolchains.getModelEncoding() );
        serializer.startDocument( persistedToolchains.getModelEncoding(), null );
        writePersistedToolchains( persistedToolchains, "toolchains", serializer );
        serializer.endDocument();
    } //-- void write( OutputStream, PersistedToolchains )

    /**
     * Method writePersistedToolchains.
     * 
     * @param persistedToolchains a persistedToolchains object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writePersistedToolchains( PersistedToolchains persistedToolchains, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        if ( this.fileComment != null )
        {
        serializer.comment(this.fileComment);
        }
        serializer.setPrefix( "", "http://maven.apache.org/TOOLCHAINS/1.1.0" );
        serializer.setPrefix( "xsi", "http://www.w3.org/2001/XMLSchema-instance" );
        serializer.startTag( NAMESPACE, tagName );
        serializer.attribute( "", "xsi:schemaLocation", "http://maven.apache.org/TOOLCHAINS/1.1.0 https://maven.apache.org/xsd/toolchains-1.1.0.xsd" );
        if ( ( persistedToolchains.getToolchains() != null ) && ( persistedToolchains.getToolchains().size() > 0 ) )
        {
            for ( Iterator iter = persistedToolchains.getToolchains().iterator(); iter.hasNext(); )
            {
                ToolchainModel o = (ToolchainModel) iter.next();
                writeToolchainModel( o, "toolchain", serializer );
            }
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writePersistedToolchains( PersistedToolchains, String, XmlSerializer )

    /**
     * Method writeToolchainModel.
     * 
     * @param toolchainModel a toolchainModel object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeToolchainModel( ToolchainModel toolchainModel, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        if ( toolchainModel.getType() != null )
        {
            serializer.startTag( NAMESPACE, "type" ).text( toolchainModel.getType() ).endTag( NAMESPACE, "type" );
        }
        if ( ( toolchainModel.getProvides() != null ) && ( toolchainModel.getProvides().size() > 0 ) )
        {
            serializer.startTag( NAMESPACE, "provides" );
            for ( Iterator iter = toolchainModel.getProvides().keySet().iterator(); iter.hasNext(); )
            {
                String key = (String) iter.next();
                String value = (String) toolchainModel.getProvides().get( key );
                serializer.startTag( NAMESPACE, key ).text( value ).endTag( NAMESPACE, key );
            }
            serializer.endTag( NAMESPACE, "provides" );
        }
        if ( toolchainModel.getConfiguration() != null )
        {
            ((Xpp3Dom) toolchainModel.getConfiguration()).writeToSerializer( NAMESPACE, serializer );
        }
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeToolchainModel( ToolchainModel, String, XmlSerializer )

    /**
     * Method writeTrackableBase.
     * 
     * @param trackableBase a trackableBase object.
     * @param serializer a serializer object.
     * @param tagName a tagName object.
     * @throws java.io.IOException java.io.IOException if any.
     */
    private void writeTrackableBase( TrackableBase trackableBase, String tagName, XmlSerializer serializer )
        throws java.io.IOException
    {
        serializer.startTag( NAMESPACE, tagName );
        serializer.endTag( NAMESPACE, tagName );
    } //-- void writeTrackableBase( TrackableBase, String, XmlSerializer )

}
