/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.wtp.jpa;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlPersistenceUnit;
import org.eclipse.jpt.jpa.core.resource.persistence.XmlProperty;
import org.eclipse.m2e.wtp.jpa.AbstractPlatformIdentifier;
import org.eclipse.m2e.wtp.jpa.IPlatformIdentifier;

public class PlatformIdentifierManager {
    private List<IPlatformIdentifier> platformIdentifiers = new ArrayList<IPlatformIdentifier>();

    public PlatformIdentifierManager() {
        this.platformIdentifiers.add(new ReallySimplePlatformIdentifer("hibernate"));
        this.platformIdentifiers.add(new ReallySimplePlatformIdentifer("eclipselink"));
    }

    public String identify(XmlPersistenceUnit xmlPersistenceUnit) {
        String platformId = null;
        for (IPlatformIdentifier identifier : this.platformIdentifiers) {
            platformId = identifier.getPlatformId(xmlPersistenceUnit);
            if (platformId == null) continue;
            return platformId;
        }
        return null;
    }

    private class ReallySimplePlatformIdentifer
    extends AbstractPlatformIdentifier {
        private final String platformName;

        ReallySimplePlatformIdentifer(String platformName) {
            this.platformName = platformName;
        }

        @Override
        protected String identifyProvider(String provider) {
            if (provider != null && provider.contains(this.platformName)) {
                return this.platformName;
            }
            return null;
        }

        @Override
        protected String identifyProperty(XmlProperty property) {
            return this.identifyProvider(property.getName());
        }
    }
}

