/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.core.emf;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLParserPoolImpl;
import org.eclipse.m2m.atl.common.ATLResourceProvider;
import org.eclipse.m2m.atl.core.ATLCoreException;
import org.eclipse.m2m.atl.core.IModel;
import org.eclipse.m2m.atl.core.IReferenceModel;
import org.eclipse.m2m.atl.core.ModelFactory;
import org.eclipse.m2m.atl.core.emf.EMFModel;
import org.eclipse.m2m.atl.core.emf.EMFReferenceModel;
import org.eclipse.m2m.atl.core.emf.Messages;

public class EMFModelFactory
extends ModelFactory {
    public static final String MODEL_FACTORY_NAME = "EMF";
    public static final String OPTION_CONTENT_TYPE = "OPTION_CONTENT_TYPE";
    public static final String OPTION_URI = "path";
    private EMFReferenceModel metametamodel;
    private ResourceSet resourceSet;

    public EMFModelFactory() {
        Map etfm = Resource.Factory.Registry.INSTANCE.getExtensionToFactoryMap();
        if (!etfm.containsKey("*")) {
            etfm.put("*", new XMIResourceFactoryImpl());
        }
        this.resourceSet = new ResourceSetImpl();
        Map loadOptions = this.resourceSet.getLoadOptions();
        loadOptions.put("DEFER_IDREF_RESOLUTION", Boolean.TRUE);
        loadOptions.put("USE_PARSER_POOL", new XMLParserPoolImpl());
        loadOptions.put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
    }

    public EMFReferenceModel getMetametamodel() {
        if (this.metametamodel == null) {
            this.metametamodel = new EMFReferenceModel(null, this);
            this.metametamodel.setResource(EcorePackage.eINSTANCE.eResource());
            this.metametamodel.referenceModel = this.metametamodel;
            this.metametamodel.register();
        }
        return this.metametamodel;
    }

    public IReferenceModel newReferenceModel(Map<String, Object> options) {
        return this.newReferenceModel();
    }

    public IReferenceModel newReferenceModel() {
        return new EMFReferenceModel(this.getMetametamodel(), this);
    }

    public IModel newModel(IReferenceModel referenceModel, Map<String, Object> options) {
        return this.newModel(referenceModel);
    }

    public IModel newModel(IReferenceModel referenceModel) {
        return new EMFModel((EMFReferenceModel)referenceModel, this);
    }

    public EMFModel newModel(EMFReferenceModel referenceModel, String uri) {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put(OPTION_URI, uri);
        return (EMFModel)this.newModel((IReferenceModel)referenceModel, options);
    }

    public String getDefaultExtractorName() {
        return MODEL_FACTORY_NAME;
    }

    public String getDefaultInjectorName() {
        return MODEL_FACTORY_NAME;
    }

    public ResourceSet getResourceSet() {
        return this.resourceSet;
    }

    public IReferenceModel getBuiltInResource(String name) throws ATLCoreException {
        EMFReferenceModel model = new EMFReferenceModel(this.getMetametamodel(), this);
        URL url = ATLResourceProvider.getURL((String)name);
        if (url == null) {
            throw new ATLCoreException(Messages.getString("EMFModelFactory.BUILT_IN_NOT_FOUND", name));
        }
        Resource builtin = this.resourceSet.createResource(URI.createURI((String)name));
        try {
            builtin.load(url.openStream(), Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            throw new ATLCoreException(Messages.getString("EMFModelFactory.BUILT_IN_NOT_FOUND", name), (Throwable)e);
        }
        model.setResource(builtin);
        model.register();
        return model;
    }

    public void unload(EMFModel model) {
        Resource r = model.getResource();
        EList resources = this.getResourceSet().getResources();
        if (resources.contains((Object)r)) {
            resources.remove((Object)r);
            this.finalizeResource(r);
        }
    }

    protected void finalizeResource(Resource r) {
    }
}

