/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.editor.ui.completion;

import java.util.ArrayList;
import java.util.LinkedList;
import lpg.runtime.IPrsStream;
import lpg.runtime.IToken;
import lpg.runtime.PrsStream;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnv;
import org.eclipse.m2m.internal.qvt.oml.ast.env.QvtOperationalEnvFactory;
import org.eclipse.m2m.internal.qvt.oml.ast.parser.QvtOperationalVisitorCS;
import org.eclipse.m2m.internal.qvt.oml.compiler.QvtCompilerOptions;
import org.eclipse.m2m.internal.qvt.oml.compiler.UnitProxy;
import org.eclipse.m2m.internal.qvt.oml.cst.TypeSpecCS;
import org.eclipse.m2m.internal.qvt.oml.cst.completion.parser.LightweightParser;
import org.eclipse.m2m.internal.qvt.oml.cst.completion.parser.LightweightTypeParser;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOLexer;
import org.eclipse.m2m.internal.qvt.oml.cst.parser.QVTOParsersym;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.Activator;
import org.eclipse.m2m.internal.qvt.oml.editor.ui.completion.QvtCompletionData;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.OCLInput;
import org.eclipse.ocl.ParserException;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.cst.OCLExpressionCS;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.parser.OCLLexer;

public class LightweightParserUtil {
    public static final int[] IMPERATIVE_OPERATION_TOKENS = new int[]{97, 99, 98, 93};
    public static final int[] OCLEXPRESSION_START_TOKENS = new int[]{70, 74, 69, 81, 90, 76, 77, 78, 79, 85, 86, 88, 91, 37, 71, 9, 4, 72, 82, 117, 68, 66, 115, 40, 119, 83, 67, 63, 1, 94, 109, 51};
    public static final int[] OCLEXPRESSION_END_TOKENS = new int[]{82, 117, 68, 66, 115, 119, 83, 84, 75, 114, 5, 94};
    public static final int[] OCLEXPRESSION_MANDATORY_TERMINATION_TOKENS = LightweightParserUtil.uniteIntArrays(IMPERATIVE_OPERATION_TOKENS, new int[]{140, 96, 107, 144, 145, 141, 108});
    public static final int[][] BRACING_PAIRS = new int[][]{{40, 84}, {1, 5}, {67, 75}, {63, 114}};
    public static final int[] RESOLVE_FAMILY_TERMINALS = new int[]{55, 56, 57, 58, 59, 60, 61, 62};
    public static final int[] RESOLVEIN_FAMILY_TERMINALS = new int[]{57, 58, 61, 62};
    public static final String[] OCL_ITERATOR_TERMINALS = new String[]{"select", "reject", "collect", "forAll", "exists", "isUnique", "one", "any", "collectNested", "sortedBy", "closure"};
    public static final int[] QVTO_ITERATOR_TERMINALS_WITH_IMPLICIT_ITERATOR = new int[]{131, 132, 133, 134};
    public static final int[] QVTO_ITERATOR_TERMINALS = LightweightParserUtil.uniteIntArrays(QVTO_ITERATOR_TERMINALS_WITH_IMPLICIT_ITERATOR, new int[]{135, 136});
    public static final int[] MAPPING_CLAUSE_TOKENS = new int[]{109, 112};
    public static final int[] MAPPING_CALL_TERMINALS = new int[]{33, 34};
    public static final int[] FOR_EXP_TERMINALS = new int[]{137, 138};

    public static int[] uniteIntArrays(int[] array1, int[] array2) {
        int[] result = new int[array1.length + array2.length];
        System.arraycopy(array1, 0, result, 0, array1.length);
        System.arraycopy(array2, 0, result, array1.length, array2.length);
        return result;
    }

    public static final IToken getNextToken(IToken token) {
        IPrsStream prsStream = token.getIPrsStream();
        int nextTokenIndex = token.getTokenIndex() + 1;
        if (nextTokenIndex < prsStream.getSize()) {
            return prsStream.getTokenAt(nextTokenIndex);
        }
        return null;
    }

    public static final IToken getPreviousToken(IToken token) {
        IPrsStream prsStream = token.getIPrsStream();
        int nextTokenIndex = token.getTokenIndex() - 1;
        if (nextTokenIndex >= 0) {
            return prsStream.getTokenAt(nextTokenIndex);
        }
        return null;
    }

    public static final IToken getNextTokenByKind(IToken startToken, int kind) {
        return LightweightParserUtil.getNextTokenByKind(startToken, new int[]{kind});
    }

    public static final IToken getNextTokenByKind(IToken startToken, int[] kinds) {
        IPrsStream prsStream = startToken.getIPrsStream();
        int i = startToken.getTokenIndex();
        int n = prsStream.getSize();
        while (i < n) {
            IToken token = prsStream.getTokenAt(i);
            if (QvtCompletionData.isKindOf(token, kinds)) {
                return token;
            }
            ++i;
        }
        return null;
    }

    public static final IToken getPreviousTokenByKind(IToken startToken, int kind) {
        return LightweightParserUtil.getPreviousTokenByKind(startToken, new int[]{kind});
    }

    public static final IToken getPreviousTokenByKind(IToken startToken, int[] kinds) {
        IToken currentToken = startToken;
        while ((currentToken = LightweightParserUtil.getPreviousToken(currentToken)) != null) {
            if (!QvtCompletionData.isKindOf(currentToken, kinds)) continue;
            return currentToken;
        }
        return null;
    }

    public static final String getTokenText(int tokenKind) {
        return QVTOParsersym.orderedTerminalSymbols[tokenKind];
    }

    public static final OCLExpression<EClassifier> getOclExpression(IToken trailingToken, QvtCompletionData data, ParserTypeEnum parserType) {
        OCLExpressionCS oclExpressionCS = LightweightParserUtil.getOclExpressionCS(trailingToken, data, parserType);
        return LightweightParserUtil.getOclExpression(oclExpressionCS, data);
    }

    public static final OCLExpression<EClassifier> getOclExpression(IToken[] tokens, QvtCompletionData data, ParserTypeEnum parserType) {
        OCLExpressionCS oclExpressionCS = LightweightParserUtil.getOclExpressionCS(tokens, data, parserType);
        if (oclExpressionCS != null) {
            return LightweightParserUtil.getOclExpression(oclExpressionCS, data);
        }
        return null;
    }

    public static final OCLExpression<EClassifier> getOclExpression(OCLExpressionCS oclExpressionCS, QvtCompletionData data) {
        if (oclExpressionCS != null) {
            OCLLexer oclLexer = new OCLLexer((Environment)data.getEnvironment(), new char[0], data.getCFile().getName(), 4);
            QvtCompilerOptions options = new QvtCompilerOptions();
            options.setReportErrors(false);
            options.setShowAnnotations(false);
            options.setSourceLineNumbersEnabled(false);
            QvtOperationalVisitorCS visitor = new QvtOperationalVisitorCS(oclLexer, options);
            return visitor.analyzeExpressionCS(oclExpressionCS, (Environment)data.getEnvironment());
        }
        return null;
    }

    public static final OCLExpressionCS getOclExpressionCS(IToken[] tokens, QvtCompletionData data, ParserTypeEnum parserType) {
        if (tokens != null) {
            CSTNode cstNode = LightweightParserUtil.parse(tokens, data.getCFile(), parserType);
            if (cstNode instanceof OCLExpressionCS) {
                return (OCLExpressionCS)cstNode;
            }
            if (cstNode instanceof TypeSpecCS) {
                return ((TypeSpecCS)cstNode).getTypeCS();
            }
        }
        return null;
    }

    public static final String getText(IToken start, IToken end) {
        int startOffset = start.getStartOffset();
        int endOffset = end.getEndOffset();
        IPrsStream prsStream = start.getIPrsStream();
        return LightweightParserUtil.getText(startOffset, endOffset, prsStream);
    }

    public static final String getText(CSTNode cstNode, PrsStream prsStream) {
        int startOffset = cstNode.getStartOffset();
        int endOffset = cstNode.getEndOffset();
        return LightweightParserUtil.getText(startOffset, endOffset, (IPrsStream)prsStream);
    }

    private static String getText(int startOffset, int endOffset, IPrsStream prsStream) {
        return new String(prsStream.getInputChars(), startOffset, endOffset - startOffset + 1);
    }

    public static final String getText(IToken[] tokens) {
        if (tokens.length == 0) {
            return "";
        }
        return LightweightParserUtil.getText(tokens[0], tokens[tokens.length - 1]);
    }

    public static final CSTNode parse(IToken[] tokens, UnitProxy unit, ParserTypeEnum parserType) {
        String script = LightweightParserUtil.getText(tokens);
        return LightweightParserUtil.parse(script, unit, parserType);
    }

    public static final CSTNode parse(String script, UnitProxy unit, ParserTypeEnum parserType) {
        try {
            QvtOperationalEnv env = new QvtOperationalEnvFactory().createEnvironment();
            QVTOLexer lexer = new QVTOLexer((Environment)env, new OCLInput(script).getContent(), unit.getName(), 4);
            ILightweightParser parser = null;
            switch (parserType) {
                case LIGHTWEIGHT_PARSER: {
                    parser = new RunnableLightweightParser(lexer);
                    break;
                }
                case LIGHTWEIGHT_TYPE_PARSER: {
                    parser = new RunnableLightweightTypeParser(lexer);
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown parserType: " + (Object)((Object)parserType));
                }
            }
            parser.getIPrsStream().resetTokenStream();
            lexer.lexer(parser.getIPrsStream());
            return (CSTNode)((ILightweightParser)parser).runParser();
        }
        catch (Exception ex) {
            Activator.log(ex);
            return null;
        }
    }

    private static final OCLExpressionCS getOclExpressionCS(IToken trailingToken, QvtCompletionData data, ParserTypeEnum parserType) {
        IToken[] tokens = LightweightParserUtil.extractOclExpressionCSTokens(trailingToken, data);
        return LightweightParserUtil.getOclExpressionCS(tokens, data, parserType);
    }

    public static final IToken[] extractOclExpressionCSTokens(IToken trailingToken, QvtCompletionData data) {
        ArrayList<IToken> tokens = new ArrayList<IToken>();
        IPrsStream prsStream = data.getPrsStream();
        int mode = BRACING_PAIRS.length;
        int depth = 0;
        int i = trailingToken.getTokenIndex() - 1;
        while (i >= 0) {
            IToken token = prsStream.getTokenAt(i);
            if (QvtCompletionData.isKindOf(token, OCLEXPRESSION_MANDATORY_TERMINATION_TOKENS)) {
                return null;
            }
            if (depth == 0) {
                IToken caseToken;
                IToken lParen;
                if (QvtCompletionData.isKindOf(token, OCLEXPRESSION_START_TOKENS)) {
                    return tokens.toArray(new IToken[tokens.size()]);
                }
                if (QvtCompletionData.isKindOf(token, 5) && (lParen = LightweightParserUtil.getPairingBrace(token, false)) != null && (caseToken = LightweightParserUtil.getPreviousToken(lParen)) != null && QvtCompletionData.isKindOf(caseToken, 120)) {
                    return tokens.toArray(new IToken[tokens.size()]);
                }
                int j = 0;
                while (j < BRACING_PAIRS.length) {
                    if (token.getKind() == BRACING_PAIRS[j][1]) {
                        mode = j;
                        ++depth;
                        break;
                    }
                    ++j;
                }
            } else if (token.getKind() == BRACING_PAIRS[mode][0]) {
                --depth;
            } else if (token.getKind() == BRACING_PAIRS[mode][1]) {
                ++depth;
            }
            tokens.add(0, token);
            --i;
        }
        return null;
    }

    public static final IToken getPairingBrace(IToken brace, boolean isForward) {
        int bracingPairKind = LightweightParserUtil.getBracingPairKind(brace, isForward);
        int lBraceKind = BRACING_PAIRS[bracingPairKind][0];
        int rBraceKind = BRACING_PAIRS[bracingPairKind][1];
        int depth = 0;
        IToken token = brace;
        while (token != null) {
            if (QvtCompletionData.isKindOf(token, lBraceKind)) {
                ++depth;
            } else if (QvtCompletionData.isKindOf(token, rBraceKind)) {
                --depth;
            } else if (QvtCompletionData.isKindOf(token, OCLEXPRESSION_MANDATORY_TERMINATION_TOKENS)) {
                return null;
            }
            if (depth == 0) {
                return token;
            }
            IToken iToken = token = isForward ? LightweightParserUtil.getNextToken(token) : LightweightParserUtil.getPreviousToken(token);
        }
        return null;
    }

    public static final int getBracingPairKind(IToken token, boolean isStart) {
        int i = 0;
        while (i < BRACING_PAIRS.length) {
            int kind;
            int n = kind = isStart ? BRACING_PAIRS[i][0] : BRACING_PAIRS[i][1];
            if (QvtCompletionData.isKindOf(token, kind)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static final IToken[] getScopedIdentifier(IToken trailingToken) {
        boolean isColonColonExpected = QvtCompletionData.isKindOf(trailingToken, 80);
        LinkedList<IToken> tokens = new LinkedList<IToken>();
        IToken currentToken = trailingToken;
        do {
            if (isColonColonExpected) {
                if (!QvtCompletionData.isKindOf(currentToken, 80)) {
                    return tokens.toArray(new IToken[tokens.size()]);
                }
            } else if (QvtCompletionData.isKindOf(currentToken, 3, 93)) {
                tokens.add(0, currentToken);
            } else {
                return null;
            }
            boolean bl = isColonColonExpected = !isColonColonExpected;
        } while ((currentToken = LightweightParserUtil.getPreviousToken(currentToken)) != null);
        return null;
    }

    private static interface ILightweightParser {
        public EObject runParser() throws ParserException;
    }

    public static enum ParserTypeEnum {
        LIGHTWEIGHT_PARSER,
        LIGHTWEIGHT_TYPE_PARSER;

    }

    private static class RunnableLightweightParser
    extends LightweightParser
    implements ILightweightParser {
        public RunnableLightweightParser(QVTOLexer lexStream) {
            super(lexStream);
        }

        public CSTNode runParser() throws ParserException {
            return this.parser(-1);
        }
    }

    private static class RunnableLightweightTypeParser
    extends LightweightTypeParser
    implements ILightweightParser {
        public RunnableLightweightTypeParser(QVTOLexer lexStream) {
            super(lexStream);
        }

        public CSTNode runParser() throws ParserException {
            return this.parser(-1);
        }
    }
}

