/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.ILaunchGroup;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.AbstractCompositeWizardPage;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.LaunchConfigurationTreeContentProvider;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.Messages;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.ant.TaskModel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchViewerComparator;

public class ChooseDataSourcePage
extends AbstractCompositeWizardPage {
    private TreeViewer myViewer;
    private Button myConfigButton;
    private ILaunchConfiguration myConfig;
    private ILaunchConfiguration myCreatedConfig;
    private TaskModel myTaskModel;
    private static final String QVTO_ANTTASK_NAME = "qvto:transformation";

    protected ChooseDataSourcePage() {
        super("dataSourcePage");
        this.setTitle(Messages.SourcePage_title1);
        this.setDescription(Messages.SourcePage_descr1);
    }

    public void setVisible(boolean visible) {
        if (visible && this.getSelectedLaunchConfiguration() == null) {
            this.myViewer.setSelection((ISelection)new IStructuredSelection(){

                public Object getFirstElement() {
                    Object[] array = this.toArray();
                    if (array.length == 0) {
                        return null;
                    }
                    return array[0];
                }

                public Iterator<Object> iterator() {
                    return this.toList().iterator();
                }

                public int size() {
                    return this.toArray().length;
                }

                public Object[] toArray() {
                    return ((ITreeContentProvider)ChooseDataSourcePage.this.myViewer.getContentProvider()).getElements(null);
                }

                public List<Object> toList() {
                    Object[] array = this.toArray();
                    ArrayList<Object> list = new ArrayList<Object>(array.length);
                    Object[] objectArray = array;
                    int n = array.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object o = objectArray[n2];
                        list.add(o);
                        ++n2;
                    }
                    return list;
                }

                public boolean isEmpty() {
                    return this.toArray().length > 0;
                }
            });
        }
        super.setVisible(visible);
    }

    @Override
    protected void doCreateControl(Composite parent) {
        this.myViewer = new TreeViewer(parent);
        GridData data = new GridData(4, 4, true, true);
        this.myViewer.getControl().setLayoutData((Object)data);
        this.myViewer.setLabelProvider((IBaseLabelProvider)new TypeNamesWithTaskTypes((ILabelProvider)DebugUITools.newDebugModelPresentation()));
        this.myViewer.setComparator((ViewerComparator)new WorkbenchViewerComparator());
        this.myViewer.setContentProvider((IContentProvider)new LaunchConfigurationTreeContentProvider("run", parent.getShell()));
        this.myViewer.addFilter((ViewerFilter)new AntFilter());
        this.myViewer.setInput((Object)ResourcesPlugin.getWorkspace().getRoot());
        this.myViewer.expandAll();
        this.myViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChooseDataSourcePage.this.getContainer().updateButtons();
                ChooseDataSourcePage.this.myConfigButton.setEnabled(ChooseDataSourcePage.this.getSelectedConfigType() != null);
            }
        });
        this.myConfigButton = new Button(parent, 0);
        this.myConfigButton.setText(Messages.SourcePage_configBtn);
        this.myConfigButton.setEnabled(false);
        this.myConfigButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                ILaunchConfigurationType configType = ChooseDataSourcePage.this.getSelectedConfigType();
                if (configType == null) {
                    return;
                }
                try {
                    if (ChooseDataSourcePage.this.myCreatedConfig == null || !configType.equals(ChooseDataSourcePage.this.myCreatedConfig.getType())) {
                        ILaunchConfigurationWorkingCopy wc = configType.newInstance(null, "qvto.antTask.newConfiguration");
                        wc.setAttribute("org.eclipse.debug.ui.private", true);
                        ChooseDataSourcePage.this.myCreatedConfig = wc.doSave();
                    }
                    ILaunchGroup launchGroup = DebugUITools.getLaunchGroup((ILaunchConfiguration)ChooseDataSourcePage.this.myCreatedConfig, (String)"run");
                    if (DebugUITools.openLaunchConfigurationPropertiesDialog((Shell)ChooseDataSourcePage.this.getShell(), (ILaunchConfiguration)ChooseDataSourcePage.this.myCreatedConfig, (String)launchGroup.getIdentifier()) == 0) {
                        ChooseDataSourcePage.this.myConfig = ChooseDataSourcePage.this.myCreatedConfig;
                        if (ChooseDataSourcePage.this.canFlipToNextPage()) {
                            ChooseDataSourcePage.this.getContainer().showPage(ChooseDataSourcePage.this.getNextPage());
                            ChooseDataSourcePage.this.myConfig = null;
                        }
                    }
                    ChooseDataSourcePage.this.getContainer().updateButtons();
                }
                catch (CoreException e1) {
                    e1.printStackTrace();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
    }

    public boolean canFlipToNextPage() {
        this.setErrorMessage(null);
        this.myTaskModel = null;
        ILaunchConfiguration conf = this.getSelectedLaunchConfiguration();
        if (conf == null) {
            return false;
        }
        try {
            this.myTaskModel = new TaskModel(conf, QVTO_ANTTASK_NAME);
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            return false;
        }
        return true;
    }

    public TaskModel getTaskModel() {
        return this.myTaskModel;
    }

    private ILaunchConfiguration getSelectedLaunchConfiguration() {
        IStructuredSelection ssel;
        Object firstElement;
        if (this.myConfig != null) {
            return this.myConfig;
        }
        ISelection selection = this.myViewer.getSelection();
        if (selection instanceof IStructuredSelection && (firstElement = (ssel = (IStructuredSelection)selection).getFirstElement()) instanceof ILaunchConfiguration) {
            return (ILaunchConfiguration)firstElement;
        }
        return null;
    }

    private ILaunchConfigurationType getSelectedConfigType() {
        ISelection selection = this.myViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection ssel = (IStructuredSelection)selection;
            Object firstElement = ssel.getFirstElement();
            if (firstElement instanceof ILaunchConfigurationType) {
                return (ILaunchConfigurationType)firstElement;
            }
            if (firstElement instanceof ILaunchConfiguration) {
                try {
                    return ((ILaunchConfiguration)firstElement).getType();
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private class AntFilter
    extends ViewerFilter {
        private AntFilter() {
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof ILaunchConfigurationType) {
                ILaunchConfigurationType type = (ILaunchConfigurationType)element;
                return this.isTypeSupported(type);
            }
            if (element instanceof ILaunchConfiguration) {
                ILaunchConfiguration config = (ILaunchConfiguration)element;
                boolean priv = false;
                try {
                    priv = config.getAttribute("org.eclipse.debug.ui.private", false);
                }
                catch (CoreException coreException) {
                    // empty catch block
                }
                if (priv) {
                    return false;
                }
                ILaunchConfigurationType type = null;
                try {
                    type = config.getType();
                }
                catch (CoreException e) {
                    return false;
                }
                return this.isTypeSupported(type);
            }
            return false;
        }

        private boolean isTypeSupported(ILaunchConfigurationType type) {
            return "org.eclipse.m2m.qvt.oml.QvtTransformation".equals(type.getIdentifier());
        }
    }

    private static class TypeNamesWithTaskTypes
    implements ILabelProvider {
        private final ILabelProvider myWrapped;

        TypeNamesWithTaskTypes(ILabelProvider dmp) {
            this.myWrapped = dmp;
        }

        public Image getImage(Object element) {
            return this.myWrapped.getImage(element);
        }

        public String getText(Object element) {
            String suffix = "";
            if (element instanceof ILaunchConfigurationType) {
                ILaunchConfigurationType type = (ILaunchConfigurationType)element;
                suffix = " (" + this.getTaskName(type) + ")";
            }
            return String.valueOf(this.myWrapped.getText(element)) + suffix;
        }

        private String getTaskName(ILaunchConfigurationType type) {
            return ChooseDataSourcePage.QVTO_ANTTASK_NAME;
        }

        public void addListener(ILabelProviderListener listener) {
            this.myWrapped.addListener(listener);
        }

        public void dispose() {
            this.myWrapped.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.myWrapped.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.myWrapped.removeListener(listener);
        }
    }
}

