/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.EObjectNode;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.Node;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.NodeContentProvider;
import org.eclipse.m2m.internal.qvt.oml.runtime.ui.trace.presentation.StringNode;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingContext;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingParameters;
import org.eclipse.m2m.internal.qvt.oml.trace.EMappingResults;
import org.eclipse.m2m.internal.qvt.oml.trace.ETuplePartValue;
import org.eclipse.m2m.internal.qvt.oml.trace.EValue;
import org.eclipse.m2m.internal.qvt.oml.trace.Trace;
import org.eclipse.m2m.internal.qvt.oml.trace.TraceRecord;
import org.eclipse.m2m.internal.qvt.oml.trace.VarParameterValue;

public class TraceViewContentProvider
implements ITreeContentProvider {
    private final NodeContentProvider myNodeContentProvider = new NodeContentProvider();

    public Object[] getChildren(Object parentElement) {
        return this.getElements(parentElement);
    }

    public Object getParent(Object element) {
        if (element instanceof Node) {
            Object parent = this.myNodeContentProvider.getParent(element);
            if (parent instanceof EValue) {
                if (((EValue)parent).eContainer() instanceof EValue) {
                    return parent;
                }
                return this.getParent(parent);
            }
            return parent;
        }
        EObject container = ((EObject)element).eContainer();
        if (container instanceof EMappingParameters) {
            return this.getParent(container);
        }
        if (container instanceof EMappingContext) {
            return this.getParent(container);
        }
        if (container instanceof EMappingResults) {
            return this.getParent(container);
        }
        if (container instanceof ETuplePartValue) {
            return this.getParent(container);
        }
        if (container instanceof EValue) {
            if (container.eContainer() instanceof EValue) {
                return container;
            }
            return this.getParent(container);
        }
        return container;
    }

    public boolean hasChildren(Object element) {
        return this.getElements(element).length != 0;
    }

    public Object[] getElements(Object element) {
        if (element instanceof Trace) {
            Trace trace = (Trace)element;
            return trace.getTraceRecords().toArray();
        }
        if (element instanceof TraceRecord) {
            TraceRecord traceRecord = (TraceRecord)element;
            ArrayList<VarParameterValue> children = new ArrayList<VarParameterValue>();
            if (traceRecord.getContext().getContext() != null) {
                children.add(traceRecord.getContext().getContext());
            }
            for (VarParameterValue varParameterValue : traceRecord.getParameters().getParameters()) {
                children.add(varParameterValue);
            }
            for (VarParameterValue varParameterValue : traceRecord.getResult().getResult()) {
                children.add(varParameterValue);
            }
            return children.toArray();
        }
        if (element instanceof VarParameterValue) {
            VarParameterValue varParameterValue = (VarParameterValue)element;
            return this.getElements(varParameterValue.getValue());
        }
        if (element instanceof ETuplePartValue) {
            ETuplePartValue tuplePartValue = (ETuplePartValue)element;
            return this.getElements(tuplePartValue.getValue());
        }
        if (element instanceof EValue) {
            EValue eValue = (EValue)element;
            if (eValue.getModelElement() != null) {
                return new Object[]{new EObjectNode(element, eValue.getModelElement())};
            }
            if (eValue.getPrimitiveValue() != null) {
                return new Object[]{new StringNode(element, eValue.getPrimitiveValue())};
            }
            if (eValue.getIntermediateElement() != null) {
                return new Object[]{new EObjectNode(element, eValue.getIntermediateElement())};
            }
            if (!eValue.getCollection().isEmpty()) {
                return eValue.getCollection().toArray();
            }
            return new Object[0];
        }
        return this.myNodeContentProvider.getElements(element);
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }
}

