/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.ui.wizards;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public abstract class NamesInScopeChecker {
    protected NamesInScopeChecker() {
    }

    protected abstract boolean isDefined(String var1);

    protected abstract void doDefine(String var1);

    public boolean defineName(String name) {
        if (name == null) {
            throw new IllegalArgumentException();
        }
        if (this.isDefined(name)) {
            return false;
        }
        this.doDefine(name);
        return true;
    }

    public String checkedDefineName(String name) {
        if (this.defineName(name)) {
            return name;
        }
        int MAX_TRIALS_COUNT = 200;
        int i = 1;
        while (i < 200) {
            String newName = String.valueOf(name) + i;
            if (this.defineName(newName)) {
                return newName;
            }
            ++i;
        }
        return name;
    }

    public static class UniqueNameSet
    extends NamesInScopeChecker {
        private Set<String> definedNames;

        public UniqueNameSet() {
            this.definedNames = new HashSet<String>(5);
        }

        public UniqueNameSet(String[] initialNames) {
            this.definedNames = new HashSet<String>(Arrays.asList(initialNames));
        }

        @Override
        protected void doDefine(String newName) {
            this.definedNames.add(newName);
        }

        @Override
        protected boolean isDefined(String newName) {
            return this.definedNames.contains(newName);
        }
    }
}

