/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.modisco.java.composition.ui.strategies;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.modisco.infra.common.core.logging.MoDiscoLogger;
import org.eclipse.modisco.java.composition.ui.Activator;
import org.eclipse.modisco.java.emf.JavaPackage;
import org.eclipse.modisco.kdm.source.extension.ui.interfaces.RevealingStrategy;
import org.eclipse.modisco.omg.kdm.source.SourceRegion;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.texteditor.AbstractTextEditor;

public class StrategyRevealingJava
implements RevealingStrategy {
    private static final String METAMODEL_URI = JavaPackage.eINSTANCE.getNsURI();

    public void revealInTextEditor(final IFile inputFile, final SourceRegion sourceRegion) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                IEditorPart iEditorPart = null;
                IEditorReference[] iEditorReferenceArray = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
                int n = iEditorReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IEditorReference editorReference = iEditorReferenceArray[n2];
                    IEditorPart editorTmp = editorReference.getEditor(false);
                    if (editorTmp instanceof AbstractTextEditor) {
                        AbstractTextEditor abstractTextEditor = (AbstractTextEditor)editorTmp;
                        if (inputFile.getName().equalsIgnoreCase(abstractTextEditor.getEditorInput().getName())) {
                            iEditorPart = editorTmp;
                            break;
                        }
                    }
                    ++n2;
                }
                if (iEditorPart == null) {
                    try {
                        iEditorPart = IDE.openEditor((IWorkbenchPage)activePage, (IFile)inputFile, (boolean)true);
                    }
                    catch (PartInitException e) {
                        MoDiscoLogger.logError((Throwable)e, (Plugin)Activator.getDefault());
                    }
                }
                StrategyRevealingJava.this.selectInTextEditor(iEditorPart, sourceRegion);
            }
        });
    }

    public boolean isApplicableTo(Notifier target) {
        if (target instanceof EObject) {
            return ((EObject)target).eClass().getEPackage().getNsURI().equalsIgnoreCase(METAMODEL_URI);
        }
        return false;
    }

    public void selectInTextEditor(IEditorPart iEditorPart, SourceRegion sourceRegion) {
        if (iEditorPart != null) {
            AbstractTextEditor abstractTextEditor = (AbstractTextEditor)iEditorPart;
            abstractTextEditor.getSite().getPage().activate(abstractTextEditor.getSite().getPart());
            abstractTextEditor.selectAndReveal(sourceRegion.getStartPosition().intValue(), sourceRegion.getEndPosition() - sourceRegion.getStartPosition());
        }
    }
}

