/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.versions.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.mylyn.commons.core.StatusHandler;
import org.eclipse.mylyn.versions.core.spi.ScmConnector;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.RepositoryProvider;

public class ScmCore {
    private static HashMap<String, ScmConnector> connectorById = new HashMap();

    public static IResource findResource(String file) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path path = new Path(file);
        path.makeRelative();
        IResource resource = ScmCore.findResource(root, (IPath)path);
        if (resource == null) {
            IProject[] iProjectArray = root.getProjects();
            int n = iProjectArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProject project = iProjectArray[n2];
                resource = project.findMember((IPath)path);
                if (resource != null) break;
                ++n2;
            }
        }
        return resource;
    }

    private static IResource findResource(IWorkspaceRoot root, IPath path) {
        while (path.segmentCount() > 1) {
            IResource resource = root.findMember(path);
            if (resource != null) {
                return resource;
            }
            path = path.removeFirstSegments(1);
        }
        return null;
    }

    public static List<ScmConnector> getAllRegisteredConnectors() {
        String[] teamProviderIds;
        ArrayList<ScmConnector> scmConnectors = new ArrayList<ScmConnector>();
        String[] stringArray = teamProviderIds = RepositoryProvider.getAllProviderTypeIds();
        int n = teamProviderIds.length;
        int n2 = 0;
        while (n2 < n) {
            String providerId = stringArray[n2];
            ScmConnector connector = ScmCore.getScmConnectorById(providerId);
            if (connector != null) {
                scmConnectors.add(connector);
            }
            ++n2;
        }
        return scmConnectors;
    }

    public static ScmConnector getConnector(IResource resource) {
        if (!RepositoryProvider.isShared((IProject)resource.getProject())) {
            return null;
        }
        RepositoryProvider provider = RepositoryProvider.getProvider((IProject)resource.getProject());
        return ScmCore.getScmConnectorById(provider.getID());
    }

    private static synchronized ScmConnector getScmConnectorById(String id) {
        ScmConnector connector = connectorById.get(id);
        if (connector == null) {
            connector = ScmCore.loadConnector(id);
            connectorById.put(id, connector);
        }
        return connector;
    }

    private static ScmConnector loadConnector(String id) {
        IExtension[] extensions;
        Assert.isNotNull((Object)id);
        MultiStatus result = new MultiStatus("org.eclipse.mylyn.versions.core", 0, "Scm connectors failed to load.", null);
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint connectorsExtensionPoint = registry.getExtensionPoint("org.eclipse.mylyn.versions.core.connectors");
        IExtension[] iExtensionArray = extensions = connectorsExtensionPoint.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                if (id.equals(element.getAttribute("id"))) {
                    try {
                        Object object = element.createExecutableExtension("core");
                        if (object instanceof ScmConnector) {
                            return (ScmConnector)object;
                        }
                        result.add((IStatus)new Status(4, "org.eclipse.mylyn.versions.core", NLS.bind((String)"Connector core ''{0}'' does not extend expected class for extension contributed by {1}", (Object)object.getClass().getCanonicalName(), (Object)element.getContributor().getName())));
                    }
                    catch (Throwable e) {
                        result.add((IStatus)new Status(4, "org.eclipse.mylyn.versions.core", NLS.bind((String)"Connector core failed to load for extension contributed by {0}", (Object)element.getContributor().getName()), e));
                    }
                }
                ++n4;
            }
            ++n2;
        }
        if (!result.isOK()) {
            StatusHandler.log((IStatus)result);
        }
        return null;
    }
}

