/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.net4j.util.container;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.net4j.util.container.IContainer;
import org.eclipse.net4j.util.io.IORuntimeException;
import org.eclipse.net4j.util.io.IOUtil;

public abstract class ContainerPersistence<E>
implements IContainer.Persistence<E> {
    @Override
    public Collection<E> loadElements() throws IORuntimeException {
        InputStream out = null;
        try {
            Collection elements;
            out = this.openInputStream();
            ObjectInputStream oos = new ObjectInputStream(new BufferedInputStream(out));
            Collection collection = elements = (Collection)oos.readObject();
            return collection;
        }
        catch (IOException ex) {
            throw new IORuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new IORuntimeException(ex);
        }
        finally {
            IOUtil.closeSilent(out);
        }
    }

    @Override
    public void saveElements(Collection<E> elements) throws IORuntimeException {
        OutputStream out = null;
        try {
            try {
                out = this.openOutputStream();
                ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(out));
                oos.writeObject(elements);
                oos.flush();
            }
            catch (IOException ex) {
                throw new IORuntimeException(ex);
            }
        }
        finally {
            IOUtil.closeSilent(out);
        }
    }

    protected abstract InputStream openInputStream() throws IOException;

    protected abstract OutputStream openOutputStream() throws IOException;
}

