/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.eventmanager.framework;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.eventmanager.filters.OldValueClassFilter;
import org.eclipse.ocl.examples.eventmanager.framework.TableForEventFilter;

public class TableForOldValueClassFilter
extends TableForEventFilter {
    public TableForOldValueClassFilter(int numberOfFilterTables) {
        super(numberOfFilterTables);
    }

    @Override
    public Object getAffectedObject(Notification event) {
        if (event.getOldValue() == null) {
            return null;
        }
        if (event.getOldValue() instanceof EObject) {
            return ((EObject)event.getOldValue()).eClass();
        }
        if (event.getOldValue() instanceof EList) {
            HashSet<EClass> result = new HashSet<EClass>();
            for (Object o : (EList)event.getOldValue()) {
                if (!(o instanceof EObject)) continue;
                result.add(((EObject)o).eClass());
            }
            return result;
        }
        return null;
    }

    public Class<OldValueClassFilter> getIdentifier() {
        return OldValueClassFilter.class;
    }

    @Override
    protected String criterionToString(Object criterion) {
        StringBuilder result = new StringBuilder();
        if (criterion instanceof EClass) {
            result.append(((EClass)criterion).getName());
        } else {
            Set eClassSet = (Set)criterion;
            boolean first = true;
            for (Object eClass : eClassSet) {
                if (!first) {
                    result.append(", ");
                    continue;
                }
                result.append(((EClass)eClass).getName());
            }
        }
        return result.toString();
    }
}

