/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.internal.ids;

import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.TemplateParameter;
import org.eclipse.ocl.pivot.ids.AbstractSingletonScope;
import org.eclipse.ocl.pivot.ids.BindingsId;
import org.eclipse.ocl.pivot.ids.ElementId;
import org.eclipse.ocl.pivot.ids.IdHash;
import org.eclipse.ocl.pivot.ids.IdManager;
import org.eclipse.ocl.pivot.ids.IdVisitor;
import org.eclipse.ocl.pivot.ids.OperationId;
import org.eclipse.ocl.pivot.ids.ParametersId;
import org.eclipse.ocl.pivot.ids.PropertyId;
import org.eclipse.ocl.pivot.ids.SingletonScope;
import org.eclipse.ocl.pivot.ids.TemplateParameterId;
import org.eclipse.ocl.pivot.ids.TemplateableId;
import org.eclipse.ocl.pivot.ids.TypeId;
import org.eclipse.ocl.pivot.internal.ids.AbstractElementId;

public class TemplateParameterIdImpl
extends AbstractElementId
implements TemplateParameterId {
    private final @Nullable TemplateableId templateableId;
    private final int index;
    private final @NonNull String name;
    private final int hashCode;

    private static int computeHashCode(@NonNull TemplateableId generalizedId, @NonNull String name) {
        return IdHash.createChildHash(generalizedId, name);
    }

    @Deprecated
    public TemplateParameterIdImpl(@NonNull IdManager idManager, int index) {
        this.templateableId = null;
        this.index = index;
        this.name = "$" + Integer.toString(index);
        this.hashCode = TemplateParameterIdImpl.class.hashCode() + this.name.hashCode();
    }

    public TemplateParameterIdImpl(@NonNull TemplateableId templateableId, int index, @NonNull String name) {
        this.templateableId = templateableId;
        this.index = index;
        this.name = name;
        this.hashCode = TemplateParameterIdImpl.computeHashCode(templateableId, name);
    }

    @Override
    public <R> R accept(@NonNull IdVisitor<R> visitor) {
        return visitor.visitTemplateParameterId(this);
    }

    @Override
    public @NonNull String getDisplayName() {
        return this.name;
    }

    @Override
    public @Nullable TemplateableId getTemplateableId() {
        return this.templateableId;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @Deprecated
    public @Nullable String getLiteralName() {
        if (this == TypeId.T_1) {
            return "T_1";
        }
        if (this == TypeId.T_2) {
            return "T_2";
        }
        if (this == TypeId.T_3) {
            return "T_3";
        }
        return null;
    }

    @Override
    public @NonNull String getMetaTypeName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull String getName() {
        return this.name;
    }

    @Override
    public @NonNull OperationId getOperationId(int templateParameters, @NonNull String name, @NonNull ParametersId parametersId) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull PropertyId getPropertyId(@NonNull String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @NonNull TemplateParameterId getTemplateParameterId(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getTemplateParameters() {
        throw new UnsupportedOperationException();
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public boolean isTemplated() {
        return true;
    }

    @Override
    public @NonNull ElementId specialize(@NonNull BindingsId templateBindings) {
        ElementId elementId = templateBindings.getElementId(this.index);
        assert (elementId != null);
        return elementId;
    }

    @Override
    public String toString() {
        if (this.templateableId != null) {
            return String.valueOf(this.templateableId.getDisplayName()) + "::" + this.getDisplayName();
        }
        return this.getDisplayName();
    }

    public static class TemplateParameterIdSingletonScope
    extends AbstractSingletonScope<TemplateParameterId, TemplateParameter> {
        public @NonNull TemplateParameterId getSingleton(@NonNull TemplateableId generalizedId, int index, @NonNull String name) {
            return this.getSingletonFor(new TemplateParameterIdValue(generalizedId, index, name));
        }
    }

    private static class TemplateParameterIdValue
    extends SingletonScope.AbstractKeyAndValue<TemplateParameterId> {
        private final @NonNull TemplateableId generalizedId;
        private final int index;
        private final @NonNull String name;

        private TemplateParameterIdValue(@NonNull TemplateableId generalizedId, int index, @NonNull String name) {
            super(TemplateParameterIdImpl.computeHashCode(generalizedId, name));
            this.generalizedId = generalizedId;
            this.index = index;
            this.name = name;
        }

        @Override
        public @NonNull TemplateParameterId createSingleton() {
            return new TemplateParameterIdImpl(this.generalizedId, this.index, this.name);
        }

        @Override
        public boolean equals(@Nullable Object that) {
            if (that instanceof TemplateParameterIdImpl) {
                TemplateParameterIdImpl singleton = (TemplateParameterIdImpl)that;
                return this.name.equals(singleton.getName());
            }
            return false;
        }
    }
}

