/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.pivot.library;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.Operation;
import org.eclipse.ocl.pivot.OperationCallExp;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.evaluation.EvaluationHaltedException;
import org.eclipse.ocl.pivot.evaluation.Evaluator;
import org.eclipse.ocl.pivot.evaluation.Executor;
import org.eclipse.ocl.pivot.internal.evaluation.ExecutorInternal;
import org.eclipse.ocl.pivot.library.AbstractIterationOrOperation;
import org.eclipse.ocl.pivot.library.LibraryOperation;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.ValueUtil;
import org.eclipse.ocl.pivot.values.InvalidValueException;

public abstract class AbstractOperation
extends AbstractIterationOrOperation
implements LibraryOperation.LibraryOperationExtension2 {
    @Override
    public @Nullable Object basicEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] sourceAndArgumentValues) {
        throw new UnsupportedOperationException();
    }

    protected final @Nullable Object cachedEvaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] sourceAndArgumentValues) {
        if (executor instanceof ExecutorInternal.ExecutorInternalExtension) {
            return ((ExecutorInternal.ExecutorInternalExtension)executor).getCachedEvaluationResult(this, caller, sourceAndArgumentValues);
        }
        return this.basicEvaluate(executor, caller, sourceAndArgumentValues);
    }

    @Override
    public @Nullable Object evaluate(@NonNull Executor executor, @NonNull TypedElement caller, @Nullable Object @NonNull [] sourceAndArgumentValues) {
        if (executor instanceof ExecutorInternal.ExecutorInternalExtension) {
            return ((ExecutorInternal.ExecutorInternalExtension)executor).getCachedEvaluationResult(this, caller, sourceAndArgumentValues);
        }
        return this.basicEvaluate(executor, caller, sourceAndArgumentValues);
    }

    @Override
    @Deprecated
    public @Nullable Object dispatch(@NonNull Evaluator evaluator, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        return this.dispatch(AbstractOperation.getExecutor(evaluator), callExp, sourceValue);
    }

    @Override
    public @Nullable Object dispatch(@NonNull Executor executor, @NonNull OperationCallExp callExp, @Nullable Object sourceValue) {
        ExecutorInternal.ExecutorInternalExtension castExecutor = (ExecutorInternal.ExecutorInternalExtension)executor;
        Operation apparentOperation = callExp.getReferredOperation();
        assert (apparentOperation != null);
        List<@NonNull OCLExpression> arguments = ClassUtil.nullFree(callExp.getOwnedArguments());
        @Nullable Object[] sourceAndArgumentValues = new Object[1 + arguments.size()];
        int argumentIndex = 0;
        sourceAndArgumentValues[argumentIndex++] = sourceValue;
        if (!apparentOperation.isIsValidating()) {
            for (OCLExpression argument : arguments) {
                Object argValue = castExecutor.evaluate(argument);
                sourceAndArgumentValues[argumentIndex++] = argValue;
            }
        } else {
            for (OCLExpression argument : arguments) {
                Object argValue;
                try {
                    argValue = castExecutor.evaluate(argument);
                    assert (ValueUtil.isBoxed(argValue));
                }
                catch (EvaluationHaltedException e) {
                    throw e;
                }
                catch (InvalidValueException e) {
                    argValue = e;
                }
                sourceAndArgumentValues[argumentIndex++] = argValue;
            }
        }
        return castExecutor.internalExecuteOperationCallExp(callExp, sourceAndArgumentValues);
    }
}

