/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.internal.evaluation;

import java.math.BigDecimal;
import java.math.BigInteger;

public class NumberUtil {
    public static Number coerceNumber(Number number) {
        Number result = number instanceof Integer || number instanceof Double ? (Number)number : (Number)(number instanceof Byte || number instanceof Short ? (Number)number.intValue() : (Number)(number instanceof Long ? (Number)(NumberUtil.canConform((Long)number) ? (Number)number.intValue() : (Number)number) : (Number)(number instanceof BigInteger ? (Number)(NumberUtil.isInteger((BigInteger)number) ? (Number)number.intValue() : (Number)(NumberUtil.isLong((BigInteger)number) ? (Number)number.longValue() : (Number)number)) : (Number)(number instanceof Float ? (Number)number.doubleValue() : (Number)(number instanceof BigDecimal ? (Number)(NumberUtil.isDouble((BigDecimal)number) ? (Number)number.doubleValue() : (Number)number) : (Number)number)))));
        return result;
    }

    private static boolean canConform(Long number) {
        long i;
        long l = number;
        return l == (i = (long)number.intValue());
    }

    private static boolean isInteger(BigInteger number) {
        int i = number.intValue();
        BigInteger b = new BigInteger(String.valueOf(i));
        return number.equals(b);
    }

    private static boolean isLong(BigInteger number) {
        long i = number.longValue();
        BigInteger b = new BigInteger(String.valueOf(i));
        return number.equals(b);
    }

    private static boolean isDouble(BigDecimal number) {
        double doubleValue = number.doubleValue();
        return doubleValue != Double.NEGATIVE_INFINITY && doubleValue != Double.POSITIVE_INFINITY;
    }

    public static Number commonPrecisionNumber(Number number, Number referenceNumber) {
        if (number instanceof BigDecimal || referenceNumber instanceof BigDecimal) {
            if (number instanceof BigDecimal) {
                return number;
            }
            if (number instanceof BigInteger) {
                return new BigDecimal((BigInteger)number);
            }
            if (number instanceof Integer || number instanceof Long || number instanceof Short || number instanceof Byte) {
                return new BigDecimal(number.longValue());
            }
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (number instanceof BigInteger && referenceNumber instanceof Double) {
            return new BigDecimal((BigInteger)number);
        }
        if (number instanceof Double && referenceNumber instanceof BigInteger) {
            return BigDecimal.valueOf(number.doubleValue());
        }
        if (number instanceof Double || referenceNumber instanceof Double || number instanceof Float || referenceNumber instanceof Float) {
            if (number instanceof Double) {
                return number;
            }
            return number.doubleValue();
        }
        if (number instanceof BigInteger || referenceNumber instanceof BigInteger) {
            if (number instanceof BigInteger) {
                return number;
            }
            return BigInteger.valueOf(number.longValue());
        }
        if (number instanceof Long) {
            return number;
        }
        return number.longValue();
    }

    public static Number higherPrecisionNumber(Number number) {
        Number result = number instanceof Integer || number instanceof Byte || number instanceof Short ? (Number)number.longValue() : (Number)(number instanceof Long ? (Number)number : (Number)(number instanceof BigInteger ? (Number)(NumberUtil.isLong((BigInteger)number) ? (Number)number.longValue() : (Number)number) : (Number)(number instanceof Float ? (Number)number.doubleValue() : (Number)(number instanceof BigDecimal ? (Number)(NumberUtil.isDouble((BigDecimal)number) ? (Number)number.doubleValue() : (Number)number) : (Number)number))));
        return result;
    }
}

