/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.oomph.targlets.internal.core;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.oomph.targlets.Targlet;
import org.eclipse.oomph.targlets.TargletContainer;
import org.eclipse.oomph.targlets.TargletFactory;
import org.eclipse.oomph.targlets.core.ITargletContainer;
import org.eclipse.oomph.targlets.internal.core.Messages;
import org.eclipse.oomph.targlets.internal.core.TargletContainerDescriptorManager;
import org.eclipse.oomph.targlets.internal.core.TargletsCorePlugin;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.core.target.ITargetHandle;

public final class TargletContainerResource
extends ResourceImpl {
    public static final String PROTOCOL_NAME = "targlet_container";
    public static final String OPTION_MIRRORS = "MIRRORS";
    private final String targletContainerID;
    private ITargletContainer targletContainer;
    private ITargetHandle targetHandle;
    private Job updateJob;

    private TargletContainerResource(URI uri) {
        super(uri);
        this.targletContainerID = uri.opaquePart();
    }

    public String getTargletContainerID() {
        return this.targletContainerID;
    }

    public ITargetHandle getTargetHandle() {
        return this.targetHandle;
    }

    public void load(Map<?, ?> options) throws IOException {
        TargletContainer wrapper = TargletFactory.eINSTANCE.createTargletContainer();
        wrapper.setID(this.targletContainerID);
        this.targletContainer = TargletContainerDescriptorManager.getContainer(this.targletContainerID);
        if (this.targletContainer != null) {
            this.targetHandle = this.targletContainer.getTargetDefinition().getHandle();
            wrapper.getTarglets().addAll(this.targletContainer.getTarglets());
            wrapper.getComposedTargets().addAll(this.targletContainer.getComposedTargets());
        } else {
            this.targetHandle = null;
        }
        this.getContents().clear();
        this.getContents().add((Object)wrapper);
    }

    public void save(Map<?, ?> options) throws IOException {
        if (this.targletContainer != null) {
            final boolean mirrors = options != null && options.containsKey(OPTION_MIRRORS) ? (Boolean)options.get(OPTION_MIRRORS) : (this.defaultSaveOptions != null ? (Boolean)this.defaultSaveOptions.get(OPTION_MIRRORS) : Boolean.TRUE);
            try {
                TargletContainer wrapper = (TargletContainer)this.getContents().get(0);
                this.targletContainer.setTarglets((Collection<? extends Targlet>)wrapper.getTarglets(), (Collection<? extends String>)wrapper.getComposedTargets());
                if (this.updateJob != null) {
                    this.updateJob.cancel();
                    while (this.updateJob.getState() == 4) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                this.updateJob = new Job(NLS.bind((String)Messages.TargletContainerResourceFactory_Resolve_job, (Object)this.targletContainer.getID())){

                    protected IStatus run(IProgressMonitor monitor) {
                        try {
                            TargletContainerResource.this.targletContainer.forceUpdate(false, mirrors, monitor);
                        }
                        catch (CoreException ex) {
                            TargletsCorePlugin.INSTANCE.log(ex, 2);
                        }
                        return Status.OK_STATUS;
                    }
                };
                this.updateJob.schedule();
            }
            catch (CoreException ex) {
                TargletsCorePlugin.INSTANCE.log(ex, 2);
            }
        }
    }

    public static final class Factory
    implements Resource.Factory {
        public Resource createResource(URI uri) {
            return new TargletContainerResource(uri);
        }
    }
}

