/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.bnd.ui.templating;

import org.bndtools.templating.Category;
import org.bndtools.templating.Template;
import org.eclipse.core.runtime.Adapters;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.pde.bnd.ui.BoldStyler;
import org.eclipse.pde.bnd.ui.Resources;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;
import org.osgi.framework.Version;

public class RepoTemplateLabelProvider
extends StyledCellLabelProvider
implements ILabelProvider {
    private static final Image IMG_FOLDER = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        Category cat = (Category)Adapters.adapt((Object)element, Category.class);
        if (cat != null) {
            cell.setText(cat.getName());
            cell.setImage(IMG_FOLDER);
            cell.setStyleRanges(new StyleRange[0]);
            return;
        }
        Template template = (Template)Adapters.adapt((Object)element, Template.class);
        if (template != null) {
            String description;
            StyledString label = new StyledString(template.getName(), (StyledString.Styler)BoldStyler.INSTANCE_DEFAULT);
            Version version = template.getVersion();
            if (version != null) {
                label.append(" ");
                label.append(String.format("%d.%d.%d", version.getMajor(), version.getMinor(), version.getMicro()), (StyledString.Styler)BoldStyler.INSTANCE_COUNTER);
                String q = version.getQualifier();
                if (q != null && !q.isEmpty()) {
                    label.append("." + q, StyledString.COUNTER_STYLER);
                }
            }
            if ((description = template.getShortDescription()) != null) {
                label.append(" \u2014 [", StyledString.QUALIFIER_STYLER).append(template.getShortDescription(), StyledString.QUALIFIER_STYLER).append("]", StyledString.QUALIFIER_STYLER);
            }
            cell.setText(label.toString());
            cell.setStyleRanges(label.getStyleRanges());
            Image image = (Image)Adapters.adapt((Object)template, Image.class);
            if (image == null) {
                cell.setImage(Resources.getImage("/icons/template.gif"));
            } else {
                cell.setImage(image);
            }
            return;
        }
        cell.setStyleRanges(new StyleRange[0]);
        cell.setText(this.getText(element));
        cell.setImage(this.getImage(element));
    }

    public Image getImage(Object element) {
        return null;
    }

    public String getText(Object element) {
        return null;
    }
}

