/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.outline;

import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class QuickOutlineMouseMoveListener
implements MouseMoveListener {
    private TreeItem fLastItem = null;
    private final TreeViewer fTreeViewer;

    public QuickOutlineMouseMoveListener(TreeViewer treeViewer) {
        this.fTreeViewer = treeViewer;
    }

    public void mouseMove(MouseEvent e) {
        TreeItem o;
        Tree tree = this.fTreeViewer.getTree();
        if (tree.equals(e.getSource()) && (o = tree.getItem(new Point(e.x, e.y))) instanceof TreeItem) {
            if (!o.equals(this.fLastItem)) {
                this.fLastItem = o;
                tree.setSelection(new TreeItem[]{this.fLastItem});
            } else if (e.y < tree.getItemHeight() / 4) {
                Point p = tree.toDisplay(e.x, e.y);
                Item item = this.fTreeViewer.scrollUp(p.x, p.y);
                if (item instanceof TreeItem) {
                    this.fLastItem = (TreeItem)item;
                    tree.setSelection(new TreeItem[]{this.fLastItem});
                }
            } else if (e.y > tree.getBounds().height - tree.getItemHeight() / 4) {
                Point p = tree.toDisplay(e.x, e.y);
                Item item = this.fTreeViewer.scrollDown(p.x, p.y);
                if (item instanceof TreeItem) {
                    this.fLastItem = (TreeItem)item;
                    tree.setSelection(new TreeItem[]{this.fLastItem});
                }
            }
        }
    }
}

