/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.core.builtin.xml;

import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.php.internal.server.core.builtin.xml.PathMapping;
import org.eclipse.php.internal.server.core.builtin.xml.Port;
import org.eclipse.php.internal.server.core.builtin.xml.Server;

public class ServerInstance {
    protected Server server;
    protected IStatus status = Status.OK_STATUS;

    public ServerInstance(Server server) {
        if (server == null) {
            throw new IllegalArgumentException("Server argument may not be null.");
        }
        this.server = server;
    }

    public IStatus getStatus() {
        return this.status;
    }

    public Port[] getPorts() {
        this.status = Status.OK_STATUS;
        int size = this.server.getPortCount();
        Port[] ports = new Port[size];
        int i = 0;
        while (i < size) {
            ports[i] = this.server.getPort(i);
            ++i;
        }
        return ports;
    }

    public Port getPort(int index) {
        this.status = Status.OK_STATUS;
        return this.server.getPort(index);
    }

    public PathMapping[] getPathMapping() {
        this.status = Status.OK_STATUS;
        int size = this.server.getPathMappingCount();
        PathMapping[] mappings = new PathMapping[size];
        int i = 0;
        while (i < size) {
            mappings[i] = this.server.getPathMapping(i);
            ++i;
        }
        return mappings;
    }

    public PathMapping getPathMapping(int index) {
        this.status = Status.OK_STATUS;
        return this.server.getPathMapping(index);
    }

    public PathMapping createPathMapping() {
        this.status = Status.OK_STATUS;
        return (PathMapping)this.server.createElement("PathMapping");
    }

    public boolean removePathMapping(int index) {
        this.status = Status.OK_STATUS;
        return this.server.removeElement("PathMapping", index);
    }
}

