/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.core.format;

import java.util.HashSet;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.php.internal.core.documentModel.parser.regions.IPHPScriptRegion;
import org.eclipse.php.internal.core.documentModel.partitioner.PHPPartitionTypes;
import org.eclipse.php.internal.core.format.FormatterUtils;
import org.eclipse.php.internal.core.format.IndentationUtils;
import org.eclipse.php.internal.core.format.PHPHeuristicScanner;
import org.eclipse.php.internal.core.util.text.PHPTextSequenceUtilities;
import org.eclipse.wst.sse.core.internal.parser.ContextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocument;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegionContainer;

public class IndentationBaseDetector {
    private IStructuredDocument document;
    private int currLineIndex;
    private int offset;
    private Region textSequenceRegion;

    public IndentationBaseDetector(IStructuredDocument document, int currLineIndex, int offset) throws BadLocationException {
        this.document = document;
        this.currLineIndex = currLineIndex;
        this.offset = offset;
        IRegion lineInfo = document.getLineInformation(currLineIndex);
        this.textSequenceRegion = PHPTextSequenceUtilities.getStatementRegion(lineInfo.getOffset(), document.getRegionAtCharacterOffset(lineInfo.getOffset()), true);
    }

    public int getIndentationBaseLine(boolean checkMultiLineStatement) throws BadLocationException {
        if (checkMultiLineStatement) {
            this.currLineIndex = this.adjustLine(this.currLineIndex, this.offset);
        }
        while (this.currLineIndex > 0) {
            if (this.isIndentationBase(this.offset, this.currLineIndex, checkMultiLineStatement)) {
                return this.currLineIndex;
            }
            this.currLineIndex = this.getNextLineIndex(this.offset, this.currLineIndex, checkMultiLineStatement);
        }
        return 0;
    }

    private int adjustLine(int currLineIndex, int offset) throws BadLocationException {
        int peer;
        PHPHeuristicScanner scanner;
        int token;
        IRegion lineInfo = this.document.getLineInformation(currLineIndex);
        int lineEnd = lineInfo.getOffset() + lineInfo.getLength();
        if ((lineEnd = Math.min(lineEnd, offset)) == lineInfo.getOffset()) {
            lineEnd = IndentationUtils.moveLineStartToNonBlankChar(this.document, lineEnd, currLineIndex, false);
        }
        if (lineEnd == this.document.getLength() && lineEnd > 0) {
            --lineEnd;
        }
        if ((token = (scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, lineEnd, true)).previousToken(lineEnd, -2)) == 7) {
            token = scanner.previousToken(scanner.getPosition(), -2);
        }
        if (token == 6 ? (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')')) != -1 : token == 4 && (peer = scanner.findOpeningPeer(scanner.getPosition(), -2, '[', ']')) != -1) {
            return this.document.getLineOfOffset(scanner.getPosition());
        }
        return currLineIndex;
    }

    /*
     * Unable to fully structure code
     */
    private boolean isIndentationBase(int offset, int currLineIndex, boolean checkMultiLineStatement) throws BadLocationException {
        lineInfo = this.document.getLineInformation(currLineIndex);
        if (lineInfo.getLength() == 0) {
            return false;
        }
        checkedOffset = Math.min(lineInfo.getOffset() + lineInfo.getLength(), offset);
        lineStartOffset = lineInfo.getOffset();
        if (IndentationUtils.isBlanks(this.document, lineStartOffset, checkedOffset)) {
            return false;
        }
        scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, checkedOffset, true);
        if (!IndentationUtils.inBracelessBlock(scanner, this.document, checkedOffset)) ** GOTO lbl12
        return true;
lbl-1000:
        // 1 sources

        {
            ++lineStartOffset;
lbl12:
            // 2 sources

            ** while (Character.isWhitespace((char)this.document.getChar((int)lineStartOffset)))
        }
lbl13:
        // 1 sources

        checkedLineBeginState = FormatterUtils.getPartitionType(this.document, lineStartOffset);
        checkedLineEndState = FormatterUtils.getPartitionType(this.document, checkedOffset);
        forLineEndState = FormatterUtils.getPartitionType(this.document, offset);
        if (this.isMultilineAfterBraceless(checkedOffset)) {
            return false;
        }
        shouldNotConsiderAsIndentationBase = this.shouldNotConsiderAsIndentationBase(checkedLineBeginState, forLineEndState);
        if ((shouldNotConsiderAsIndentationBase || checkMultiLineStatement && this.isInMultiLineStatement(currLineIndex) && !this.isMultilineContentInsideBraceless(checkedOffset)) && !this.lineContainIncompleteBlock(checkedOffset, lineStartOffset)) {
            return false;
        }
        if ((checkedLineBeginState == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || checkedLineBeginState == "org.eclipse.php.PHP_DOC") && checkedLineBeginState == forLineEndState) {
            sdRegion = this.document.getRegionAtCharacterOffset(lineStartOffset);
            phpScriptRegion = sdRegion.getRegionAtCharacterOffset(lineStartOffset);
            phpContentStartOffset = sdRegion.getStartOffset(phpScriptRegion);
            if (phpScriptRegion instanceof ITextRegionContainer) {
                container = (ITextRegionContainer)phpScriptRegion;
                phpScriptRegion = container.getRegionAtCharacterOffset(lineStartOffset);
                phpContentStartOffset += phpScriptRegion.getStart();
            }
            if (phpScriptRegion instanceof IPHPScriptRegion) {
                scriptRegion = (IPHPScriptRegion)phpScriptRegion;
                checkedRegion = (ContextRegion)scriptRegion.getPHPToken(lineStartOffset - phpContentStartOffset);
                currentRegion = (ContextRegion)scriptRegion.getPHPToken(offset - phpContentStartOffset);
                checkedType = checkedRegion.getType();
                currentType = currentRegion.getType();
                if (PHPPartitionTypes.isPHPDocStartRegion(currentType) || PHPPartitionTypes.isPHPMultiLineCommentStartRegion(currentType)) {
                    return PHPPartitionTypes.isPHPDocStartRegion(checkedType) != false || PHPPartitionTypes.isPHPMultiLineCommentStartRegion(checkedType) != false;
                }
            }
        }
        return this.lineShouldIndent(checkedLineBeginState, checkedLineEndState) != false || forLineEndState == checkedLineBeginState;
    }

    private int getMultiLineStatementStartOffset(int currLineIndex) throws BadLocationException {
        if (this.textSequenceRegion.getLength() != 0 && IndentationUtils.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(this.document, this.textSequenceRegion.getOffset())) && this.document.getLineOfOffset(this.textSequenceRegion.getOffset()) < currLineIndex) {
            return this.document.getLineOfOffset(this.textSequenceRegion.getOffset());
        }
        return -1;
    }

    private boolean lineContainIncompleteBlock(int checkedOffset, int lineStartOffset) throws BadLocationException {
        if (checkedOffset == this.document.getLength() && checkedOffset > 0) {
            --checkedOffset;
        }
        if (this.textSequenceRegion.getLength() != 0 && IndentationUtils.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(this.document, this.textSequenceRegion.getOffset()))) {
            int statementStart;
            PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, lineStartOffset, true);
            int openParenPeer = scanner.findOpeningPeer(checkedOffset - 1, statementStart = this.document.getLineInformationOfOffset(checkedOffset).getOffset(), '(', ')');
            int bound = openParenPeer != -1 ? Math.max(statementStart, openParenPeer) : statementStart;
            int openBracePeer = scanner.findOpeningPeer(checkedOffset - 1, bound, '{', '}');
            bound = openBracePeer != -1 || openParenPeer != -1 ? Math.max(statementStart, Math.max(openParenPeer, openBracePeer)) : statementStart;
            int openBracketPeer = scanner.findOpeningPeer(checkedOffset - 1, bound, '[', ']');
            int biggest = Math.max(openParenPeer, openBracePeer);
            if ((biggest = Math.max(biggest, openBracketPeer)) != -1 && biggest >= lineStartOffset) {
                IStructuredDocumentRegion sdRegion = this.document.getRegionAtCharacterOffset(lineStartOffset);
                ITextRegion tRegion = sdRegion.getRegionAtCharacterOffset(lineStartOffset);
                int regionStart = sdRegion.getStartOffset(tRegion);
                if (tRegion instanceof ITextRegionContainer) {
                    ITextRegionContainer container = (ITextRegionContainer)tRegion;
                    tRegion = container.getRegionAtCharacterOffset(lineStartOffset);
                    regionStart += tRegion.getStart();
                }
                if (tRegion instanceof IPHPScriptRegion) {
                    IPHPScriptRegion scriptRegion = (IPHPScriptRegion)tRegion;
                    ITextRegion[] tokens = null;
                    try {
                        tokens = scriptRegion.getPHPTokens(lineStartOffset - regionStart, biggest - lineStartOffset);
                    }
                    catch (BadLocationException badLocationException) {}
                    if (tokens != null && tokens.length > 0) {
                        HashSet<String> tokenTypeSet = new HashSet<String>();
                        int i = 0;
                        while (i < tokens.length) {
                            tokenTypeSet.add(tokens[i].getType());
                            ++i;
                        }
                        if (biggest == openParenPeer) {
                            if (tokenTypeSet.contains("PHP_NEW") || tokenTypeSet.contains("PHP_FUNCTION") || tokenTypeSet.contains("PHP_FN") || tokenTypeSet.contains("PHP_ARRAY")) {
                                return true;
                            }
                        } else if (biggest == openBracePeer) {
                            if (tokenTypeSet.contains("PHP_NEW") || tokenTypeSet.contains("PHP_FUNCTION")) {
                                return true;
                            }
                        } else {
                            if (biggest == openBracketPeer && scanner.previousToken(biggest - 1, -2) < 2000) {
                                return true;
                            }
                            if (tokenTypeSet.contains("PHP_ARRAY")) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private int getNextLineIndex(int offset, int currLineIndex, boolean checkMultiLineStatement) throws BadLocationException {
        int index;
        IRegion lineInfo = this.document.getLineInformation(currLineIndex);
        int currLineEndOffset = lineInfo.getOffset() + lineInfo.getLength();
        String checkedLineBeginState = FormatterUtils.getPartitionType(this.document, lineInfo.getOffset());
        String forLineEndState = FormatterUtils.getPartitionType(this.document, currLineEndOffset);
        int insideBraceless = this.getMultilineInsideBraceless(Math.min(currLineEndOffset, offset));
        if (insideBraceless >= 0) {
            return this.document.getLineOfOffset(insideBraceless);
        }
        if (this.isMultilineType(checkedLineBeginState) && (checkMultiLineStatement || this.shouldNotConsiderAsIndentationBase(checkedLineBeginState, forLineEndState)) && (index = this.getMultiLineStatementStartOffset(lineInfo.getOffset(), currLineIndex)) > -1) {
            return index;
        }
        if (checkMultiLineStatement) {
            int result = this.adjustLine(currLineIndex, currLineEndOffset);
            if (result == currLineIndex && result != 0) {
                --result;
            }
            return result;
        }
        return currLineIndex - 1;
    }

    private int getMultiLineStatementStartOffset(int lineStartOffset, int currLineIndex) {
        int textOriginalOffset;
        int textSequenceLine;
        if (this.textSequenceRegion.getLength() != 0 && (textSequenceLine = this.document.getLineOfOffset(textOriginalOffset = this.textSequenceRegion.getOffset())) < currLineIndex && IndentationUtils.isRegionTypeAllowedMultiline(FormatterUtils.getRegionType(this.document, textOriginalOffset))) {
            return textSequenceLine;
        }
        return -1;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int getMultilineInsideBraceless(int checkedOffset) {
        try {
            int openParent;
            PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, checkedOffset - 1, true);
            int start = scanner.previousToken(checkedOffset - 1, -2);
            if (start != 2) {
                return -1;
            }
            int openingPeer = scanner.findOpeningPeer(scanner.getPosition(), -2, '{', '}');
            if (openingPeer == -1) {
                return -1;
            }
            int prev = scanner.previousToken(openingPeer - 1, -2);
            if (prev == 6) {
                openParent = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')');
                if (openParent == -1) {
                    return -1;
                }
                prev = scanner.previousToken(openParent - 1, -2);
            }
            if (!IndentationUtils.inBracelessBlock(scanner, this.document, scanner.getPosition() - 1)) {
                return -1;
            }
            prev = scanner.previousToken(scanner.getPosition() - 1, -2);
            if (prev == 6 && (openParent = scanner.findOpeningPeer(scanner.getPosition(), -2, '(', ')')) == -1) {
                return -1;
            }
            prev = scanner.previousToken(scanner.getPosition() - 1, -2);
            int result = scanner.getPosition();
            if (prev != 109) return result;
            prev = scanner.previousToken(start, -2);
            if (prev != 1014) return result;
            return scanner.getPosition();
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    private boolean isMultilineContentInsideBraceless(int checkedOffset) {
        try {
            PHPHeuristicScanner scanner = PHPHeuristicScanner.createHeuristicScanner((IDocument)this.document, checkedOffset - 1, true);
            int start = scanner.previousToken(checkedOffset - 1, -2);
            if (start == 1 && scanner.isBracelessBlockStart(scanner.getPosition() - 1, -2)) {
                return true;
            }
        }
        catch (BadLocationException badLocationException) {}
        return false;
    }

    private boolean lineShouldIndent(String beginState, String endState) {
        return beginState == "org.eclipse.php.PHP_DEFAULT" || endState == "org.eclipse.php.PHP_DEFAULT";
    }

    private boolean isInMultiLineStatement(int currLineIndex) throws BadLocationException {
        return this.getMultiLineStatementStartOffset(currLineIndex) > -1;
    }

    private boolean shouldNotConsiderAsIndentationBase(String currentState, String forState) {
        return currentState != forState && this.isMultilineType(currentState);
    }

    private boolean isMultilineAfterBraceless(int checkedOffset) {
        return this.getMultilineInsideBraceless(checkedOffset) >= 0;
    }

    private boolean isMultilineType(String state) {
        return state == "org.eclipse.php.PHP_QUOTED_STRING" || state == "org.eclipse.php.PHP_MULTI_LINE_COMMENT" || state == "org.eclipse.php.PHP_DOC";
    }
}

