/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.model;

import org.eclipse.php.internal.debug.core.Logger;

public interface IPHPDataType {
    public DataType getDataType();

    public static enum DataType {
        PHP_BOOL("bool"),
        PHP_INT("int"),
        PHP_FLOAT("float"),
        PHP_STRING("string"),
        PHP_NULL("null"),
        PHP_ARRAY("array"),
        PHP_OBJECT("object"),
        PHP_RESOURCE("resource"),
        PHP_VIRTUAL_CLASS("class"),
        PHP_UNINITIALIZED("<uninitialized>"),
        UNKNOWN("<?>");

        private static final String[] TYPE_UNINITIALIZED;
        private String type;

        static {
            TYPE_UNINITIALIZED = new String[]{"uninitialised", "uninitialized"};
        }

        private DataType(String type) {
            this.type = type;
        }

        public String getText() {
            return this.type;
        }

        public static DataType find(String type) {
            DataType t;
            Object[] objectArray = DataType.values();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                t = objectArray[n2];
                if (t.getText().equalsIgnoreCase(type)) {
                    return t;
                }
                ++n2;
            }
            objectArray = TYPE_UNINITIALIZED;
            n = TYPE_UNINITIALIZED.length;
            n2 = 0;
            while (n2 < n) {
                t = objectArray[n2];
                if (((String)((Object)t)).equalsIgnoreCase(type)) {
                    return PHP_UNINITIALIZED;
                }
                ++n2;
            }
            Logger.log(2, "Unknown PHP data type: " + type);
            return UNKNOWN;
        }
    }
}

