/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.debug.core.xdebug.dbgp.session;

import org.eclipse.core.runtime.ListenerList;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.model.DBGpTarget;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.DBGpSession;
import org.eclipse.php.internal.debug.core.xdebug.dbgp.session.IDBGpSessionListener;

public class DBGpSessionHandler {
    public static final String IDEKEY_PREFIX = "ECLIPSE_DBGP";
    private static DBGpSessionHandler globalSessionHandler;
    private static Object sessionHandlerCreator;
    private ListenerList<IDBGpSessionListener> listeners = new ListenerList();
    private int sessionCount = 0;
    private Object sessionCountMonitor = new Object();

    static {
        sessionHandlerCreator = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DBGpSessionHandler getInstance() {
        Object object = sessionHandlerCreator;
        synchronized (object) {
            if (globalSessionHandler == null) {
                globalSessionHandler = new DBGpSessionHandler();
            }
        }
        return globalSessionHandler;
    }

    public boolean isCorrectSession(DBGpSession session, DBGpTarget target) {
        boolean isCorrect = false;
        if (session.getIdeKey().equals(target.getIdeKey())) {
            if (session.getSessionId() != null) {
                if (session.getSessionId().equals(target.getSessionID())) {
                    isCorrect = true;
                }
            } else if (target.getSessionID() == null) {
                isCorrect = true;
            }
        }
        if (DBGpLogger.debugSession()) {
            DBGpLogger.debug("session test:" + session.getIdeKey() + "=" + target.getIdeKey() + ", " + session.getSessionId() + "=" + target.getSessionID() + " == " + isCorrect);
        }
        return isCorrect;
    }

    public String getIDEKey() {
        return IDEKEY_PREFIX;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String generateSessionId() {
        long currentTime = System.currentTimeMillis();
        StringBuilder id = new StringBuilder(Long.toString(currentTime));
        Object object = this.sessionCountMonitor;
        synchronized (object) {
            ++this.sessionCount;
            id.append(this.sessionCount);
        }
        return id.toString();
    }

    public synchronized void addSessionListener(IDBGpSessionListener l) {
        this.listeners.add((Object)l);
    }

    public void removeSessionListener(IDBGpSessionListener l) {
        this.listeners.remove((Object)l);
    }

    public synchronized boolean fireSessionAdded(DBGpSession session) {
        boolean allocated = false;
        Object[] copiedListeners = this.listeners.getListeners();
        if (DBGpLogger.debugSession()) {
            DBGpLogger.debug("firing to " + copiedListeners.length + " active debug targets");
        }
        int i = 0;
        while (i < copiedListeners.length && !allocated) {
            IDBGpSessionListener l = (IDBGpSessionListener)copiedListeners[i];
            allocated = l.SessionCreated(session);
            ++i;
        }
        return allocated;
    }
}

