/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvti.analysis;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.CallExp;
import org.eclipse.ocl.pivot.CollectionType;
import org.eclipse.ocl.pivot.CompleteClass;
import org.eclipse.ocl.pivot.CompleteModel;
import org.eclipse.ocl.pivot.DataType;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.NamedElement;
import org.eclipse.ocl.pivot.NavigationCallExp;
import org.eclipse.ocl.pivot.OCLExpression;
import org.eclipse.ocl.pivot.OppositePropertyCallExp;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.TypedElement;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.ocl.pivot.VariableExp;
import org.eclipse.ocl.pivot.internal.prettyprint.PrettyPrinter;
import org.eclipse.ocl.pivot.util.Visitable;
import org.eclipse.ocl.pivot.util.Visitor;
import org.eclipse.ocl.pivot.utilities.ClassUtil;
import org.eclipse.ocl.pivot.utilities.EnvironmentFactory;
import org.eclipse.ocl.pivot.utilities.NameUtil;
import org.eclipse.ocl.pivot.utilities.Nameable;
import org.eclipse.ocl.pivot.utilities.PivotUtil;
import org.eclipse.ocl.pivot.utilities.TracingOption;
import org.eclipse.ocl.pivot.utilities.TreeIterable;
import org.eclipse.qvtd.compiler.CompilerConstants;
import org.eclipse.qvtd.compiler.CompilerProblem;
import org.eclipse.qvtd.compiler.CompilerStep;
import org.eclipse.qvtd.compiler.internal.qvtb2qvts.MappingProblem;
import org.eclipse.qvtd.compiler.internal.qvti.analysis.QVTimperativeDomainUsageAnalysis;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtbase.graphs.GraphStringBuilder;
import org.eclipse.qvtd.pivot.qvtbase.graphs.ToGraphHelper;
import org.eclipse.qvtd.pivot.qvtbase.utilities.QVTbaseUtil;
import org.eclipse.qvtd.pivot.qvtbase.utilities.StandardLibraryHelper;
import org.eclipse.qvtd.pivot.qvtimperative.DeclareStatement;
import org.eclipse.qvtd.pivot.qvtimperative.EntryPoint;
import org.eclipse.qvtd.pivot.qvtimperative.GuardParameter;
import org.eclipse.qvtd.pivot.qvtimperative.Mapping;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatement;
import org.eclipse.qvtd.pivot.qvtimperative.NewStatementPart;
import org.eclipse.qvtd.pivot.qvtimperative.ObservableStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SetStatement;
import org.eclipse.qvtd.pivot.qvtimperative.SpeculateStatement;
import org.eclipse.qvtd.pivot.qvtimperative.Statement;
import org.eclipse.qvtd.pivot.qvtimperative.util.AbstractExtendingQVTimperativeVisitor;
import org.eclipse.qvtd.pivot.qvtimperative.utilities.QVTimperativeUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.DomainUsage;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.Graphable;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.QVTscheduleUtil;
import org.eclipse.qvtd.pivot.qvtschedule.utilities.ToGraphVisitor2;

public class QVTiProductionConsumption
extends AbstractExtendingQVTimperativeVisitor<Object, Resource>
implements Graphable {
    public static final @NonNull TracingOption SUMMARY = new TracingOption(CompilerConstants.PLUGIN_ID, "qvti/check/summary");
    protected final @NonNull EnvironmentFactory environmentFactory;
    protected final @NonNull CompilerStep compilerStep;
    protected final @NonNull String name;
    protected final @NonNull QVTimperativeDomainUsageAnalysis domainUsageAnalysis;
    protected final @NonNull Map<@NonNull Property, @NonNull BasePropertyAnalysis> property2basePropertyAnalysis = new HashMap<Property, BasePropertyAnalysis>();
    protected final @NonNull CompleteModel completeModel;
    protected final @NonNull Iterable<@NonNull Mapping> mappings;
    protected final @NonNull DomainUsage inputUsage;
    protected final @NonNull DomainUsage outputUsage;

    public QVTiProductionConsumption(@NonNull CompilerStep compilerStep, @NonNull QVTimperativeDomainUsageAnalysis domainUsageAnalysis, @NonNull EntryPoint iEntryPoint) throws IOException {
        super((Object)((Resource)ClassUtil.nonNullState((Object)iEntryPoint.eResource())));
        this.environmentFactory = compilerStep.getEnvironmentFactory();
        this.compilerStep = compilerStep;
        this.name = PivotUtil.getName((NamedElement)iEntryPoint);
        this.domainUsageAnalysis = domainUsageAnalysis;
        this.completeModel = this.environmentFactory.getCompleteModel();
        this.mappings = QVTimperativeUtil.computeMappingClosure((EntryPoint)iEntryPoint);
        DomainUsage inputUsage = domainUsageAnalysis.getNoneUsage();
        for (TypedModel inputTypedModel : QVTimperativeUtil.getInputTypedModels((EntryPoint)iEntryPoint)) {
            inputUsage = domainUsageAnalysis.union(inputUsage, domainUsageAnalysis.getUsage((Element)inputTypedModel));
        }
        this.inputUsage = inputUsage;
        DomainUsage outputUsage = domainUsageAnalysis.getNoneUsage();
        for (TypedModel outputTypedModel : QVTimperativeUtil.getOutputTypedModels((EntryPoint)iEntryPoint)) {
            outputUsage = domainUsageAnalysis.union(outputUsage, domainUsageAnalysis.getUsage((Element)outputTypedModel));
        }
        this.outputUsage = outputUsage;
    }

    public void acceptGraphVisitor(@NonNull ToGraphVisitor2 toGraphVisitor) {
        GraphStringBuilder context = toGraphVisitor.getContext();
        ToGraph toGraph = new ToGraph(context);
        context.setLabel(this.getGraphName());
        context.setColor("black");
        context.pushCluster();
        HashMap<@NonNull Mapping, @NonNull MappingNode> mapping2mappingNode = new HashMap<Mapping, MappingNode>();
        ArrayList<@NonNull BasePropertyAnalysis> basePropertyAnalyses = new ArrayList<BasePropertyAnalysis>(this.property2basePropertyAnalysis.values());
        Collections.sort(basePropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        for (BasePropertyAnalysis basePropertyAnalysis : basePropertyAnalyses) {
            basePropertyAnalysis.appendNode(toGraph, mapping2mappingNode);
        }
        context.popCluster();
    }

    public void analyze() {
        for (Mapping mapping : this.mappings) {
            for (EObject eObject : new TreeIterable((EObject)mapping, true)) {
                if (!(eObject instanceof Visitable)) continue;
                ((Visitable)eObject).accept((Visitor)this);
            }
        }
        StandardLibraryHelper standardLibraryHelper = new StandardLibraryHelper(this.environmentFactory.getStandardLibrary());
        Property oclContainerProperty = standardLibraryHelper.getOclContainerProperty();
        BasePropertyAnalysis oclContainerPropertyAnalysis = this.property2basePropertyAnalysis.get(oclContainerProperty);
        if (oclContainerPropertyAnalysis != null) {
            for (BasePropertyAnalysis basePropertyAnalysis : this.property2basePropertyAnalysis.values()) {
                Property baseOppositeProperty;
                if (basePropertyAnalysis == oclContainerPropertyAnalysis || (baseOppositeProperty = basePropertyAnalysis.baseProperty.getOpposite()) == null || !baseOppositeProperty.isIsComposite()) continue;
                oclContainerPropertyAnalysis.accumulate(basePropertyAnalysis);
            }
        }
        for (BasePropertyAnalysis basePropertyAnalysis : this.property2basePropertyAnalysis.values()) {
            basePropertyAnalysis.analyze();
        }
    }

    protected BasePropertyAnalysis getBasePropertyAnalysis(@NonNull Property property) {
        Property baseProperty = QVTscheduleUtil.getPrimaryProperty((Property)property);
        BasePropertyAnalysis basePropertyAnalysis = this.property2basePropertyAnalysis.get(baseProperty);
        if (basePropertyAnalysis == null) {
            basePropertyAnalysis = new BasePropertyAnalysis(baseProperty);
            this.property2basePropertyAnalysis.put(baseProperty, basePropertyAnalysis);
        }
        return basePropertyAnalysis;
    }

    protected @NonNull CompleteClass getCompleteClass(@NonNull Type type) {
        return this.completeModel.getCompleteClass(type);
    }

    protected @NonNull CompleteClass getCompleteClass(@NonNull TypedElement typedElement) {
        return this.getCompleteClass(QVTimperativeUtil.getType((TypedElement)typedElement));
    }

    public @NonNull String getGraphName() {
        return this.name;
    }

    protected boolean isInput(@NonNull DomainUsage usage) {
        return (this.inputUsage.getMask() & usage.getMask()) != 0;
    }

    public void toGraph(@NonNull GraphStringBuilder s) {
        throw new UnsupportedOperationException();
    }

    public void validate() {
        ArrayList<@NonNull BasePropertyAnalysis> sortedBasePropertyAnalyses = new ArrayList<BasePropertyAnalysis>(this.property2basePropertyAnalysis.values());
        Collections.sort(sortedBasePropertyAnalyses, NameUtil.NAMEABLE_COMPARATOR);
        StringBuilder s = SUMMARY.isActive() ? new StringBuilder() : null;
        for (BasePropertyAnalysis basePropertyAnalysis : sortedBasePropertyAnalyses) {
            basePropertyAnalysis.validate(s);
        }
        if (s != null) {
            SUMMARY.println(s.toString());
        }
    }

    public @Nullable Object visiting(@NonNull Visitable visitable) {
        throw new UnsupportedOperationException("Unimplemented " + ((Object)((Object)this)).getClass().getName() + " for " + visitable.eClass().getName());
    }

    public @Nullable Object visitElement(@NonNull Element object) {
        return null;
    }

    public @Nullable Object visitGuardParameter(@NonNull GuardParameter guardParameter) {
        Property successProperty = guardParameter.getSuccessProperty();
        if (successProperty != null) {
            CompleteClass sourceClass = this.getCompleteClass(QVTimperativeUtil.getType((TypedElement)guardParameter));
            CompleteClass targetClass = this.getCompleteClass((TypedElement)successProperty);
            BasePropertyAnalysis basePropertyAnalysis = this.getBasePropertyAnalysis(successProperty);
            basePropertyAnalysis.addProducer((NamedElement)guardParameter, sourceClass, successProperty, targetClass);
        }
        return null;
    }

    public @Nullable Object visitNavigationCallExp(@NonNull NavigationCallExp navigationCallExp) {
        Mapping mapping = QVTimperativeUtil.basicGetContainingMapping((EObject)navigationCallExp);
        if (mapping != null) {
            OCLExpression ownedSource = QVTimperativeUtil.getOwnedSource((CallExp)navigationCallExp);
            DomainUsage usage = this.domainUsageAnalysis.getUsage((Element)(navigationCallExp instanceof OppositePropertyCallExp ? navigationCallExp : ownedSource));
            if (!this.isInput(usage) && !usage.isPrimitive()) {
                Property getProperty = QVTimperativeUtil.getReferredProperty((NavigationCallExp)navigationCallExp);
                BasePropertyAnalysis basePropertyAnalysis = this.getBasePropertyAnalysis(getProperty);
                CompleteClass sourceClass = this.getCompleteClass((TypedElement)ownedSource);
                EObject eContainer = navigationCallExp.eContainer();
                CompleteClass targetClass = eContainer instanceof DeclareStatement ? this.getCompleteClass(QVTimperativeUtil.getType((TypedElement)((DeclareStatement)eContainer))) : this.getCompleteClass((TypedElement)navigationCallExp);
                if (getProperty.isIsMany()) {
                    CollectionType collectionType = (CollectionType)targetClass.getPrimaryClass();
                    targetClass = this.getCompleteClass(PivotUtil.getElementType((CollectionType)collectionType));
                }
                basePropertyAnalysis.addConsumer(navigationCallExp, sourceClass, getProperty, targetClass);
            }
        }
        return null;
    }

    public @Nullable Object visitNewStatement(@NonNull NewStatement newStatement) {
        return null;
    }

    public @Nullable Object visitNewStatementPart(@NonNull NewStatementPart newStatementPart) {
        NewStatement newStatement = QVTimperativeUtil.getOwningNewStatement((NewStatementPart)newStatementPart);
        Property setProperty = QVTimperativeUtil.getReferredProperty((NewStatementPart)newStatementPart);
        BasePropertyAnalysis basePropertyAnalysis = this.getBasePropertyAnalysis(setProperty);
        CompleteClass sourceClass = this.getCompleteClass(QVTimperativeUtil.getType((TypedElement)newStatement));
        CompleteClass targetClass = this.getCompleteClass((TypedElement)QVTimperativeUtil.getOwnedExpression((NewStatementPart)newStatementPart));
        basePropertyAnalysis.addProducer((NamedElement)newStatementPart, sourceClass, setProperty, targetClass);
        return null;
    }

    public @Nullable Object visitSetStatement(@NonNull SetStatement setStatement) {
        Property setProperty = QVTimperativeUtil.getTargetProperty((SetStatement)setStatement);
        BasePropertyAnalysis basePropertyAnalysis = this.getBasePropertyAnalysis(setProperty);
        CompleteClass sourceClass = this.getCompleteClass((TypedElement)QVTimperativeUtil.getTargetVariable((SetStatement)setStatement));
        CompleteClass targetClass = this.getCompleteClass((TypedElement)QVTimperativeUtil.getOwnedExpression((SetStatement)setStatement));
        if (!setStatement.isIsPartial() && setProperty.isIsMany()) {
            CollectionType collectionType = (CollectionType)targetClass.getPrimaryClass();
            targetClass = this.getCompleteClass(PivotUtil.getElementType((CollectionType)collectionType));
        }
        basePropertyAnalysis.addProducer((NamedElement)setStatement, sourceClass, setProperty, targetClass);
        return null;
    }

    private static abstract class AbstractGraphEdge
    implements GraphStringBuilder.GraphEdge {
        private AbstractGraphEdge() {
        }

        public @NonNull String getColor() {
            throw new UnsupportedOperationException();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode getEdgeSource() {
            throw new UnsupportedOperationException();
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode getEdgeTarget() {
            throw new UnsupportedOperationException();
        }
    }

    private static abstract class AbstractGraphNode
    implements GraphStringBuilder.GraphNode {
        private AbstractGraphNode() {
        }

        public @NonNull String getColor() {
            throw new UnsupportedOperationException();
        }
    }

    private class AccessAnalysis
    implements Nameable {
        protected final @NonNull CompleteClass sourceClass;
        protected final @NonNull Property property;
        protected final @NonNull CompleteClass targetClass;
        protected final @NonNull String name;
        private final @NonNull List<@NonNull NamedElement> producers = new ArrayList<NamedElement>();
        private final @NonNull List<@NonNull NavigationCallExp> consumers = new ArrayList<NavigationCallExp>();
        private @Nullable PassRange consumptionPassRange = null;
        private @Nullable PassRange productionPassRange = null;

        public AccessAnalysis(@NonNull QVTiProductionConsumption.BasePropertyAnalysis basePropertyAnalysis, @NonNull CompleteClass sourceClass, @NonNull Property property, CompleteClass targetClass) {
            this.sourceClass = sourceClass;
            this.property = property;
            this.targetClass = targetClass;
            StringBuilder s = new StringBuilder();
            s.append(sourceClass.getName());
            s.append("::");
            s.append(property.getName());
            s.append(" : ");
            s.append(property.getType().getName());
            Property opposite = property.getOpposite();
            if (opposite != null) {
                s.append("\n");
                s.append(targetClass.getName());
                s.append("::");
                s.append(opposite.getName());
                s.append(" : ");
                s.append(opposite.getType().getName());
            }
            this.name = s.toString();
        }

        public void addConsumer(@NonNull NavigationCallExp consumer) {
            assert (this.consumptionPassRange == null);
            this.consumers.add(consumer);
        }

        public void addProducer(@NonNull NamedElement producer) {
            assert (this.productionPassRange == null);
            this.producers.add(producer);
        }

        public @NonNull PassRange getConsumptionPassRange() {
            PassRange consumptionPassRange2 = this.consumptionPassRange;
            if (consumptionPassRange2 == null) {
                this.consumptionPassRange = consumptionPassRange2 = PassRange.create(this.consumers);
            }
            return consumptionPassRange2;
        }

        public @NonNull String getName() {
            return this.name;
        }

        public @NonNull PassRange getProductionPassRange() {
            PassRange productionPassRange2 = this.productionPassRange;
            if (productionPassRange2 == null) {
                this.productionPassRange = productionPassRange2 = PassRange.create(this.producers);
            }
            return productionPassRange2;
        }

        public @NonNull String toString() {
            return this.name;
        }
    }

    private class AccessAnalysisNode
    extends AbstractGraphNode {
        protected final @NonNull AccessAnalysis accessAnalysis;
        protected final @Nullable Boolean isConsumption;

        protected AccessAnalysisNode(@Nullable QVTiProductionConsumption.AccessAnalysis accessAnalysis, Boolean isConsumption) {
            this.accessAnalysis = accessAnalysis;
            this.isConsumption = isConsumption;
        }

        public void appendNode(@NonNull ToGraphHelper toGraphHelper, @NonNull String nodeName) {
            Property property = this.accessAnalysis.property;
            Type type = property.getType();
            PassRange productionPassRange = this.accessAnalysis.getProductionPassRange();
            PassRange consumptionPassRange = this.accessAnalysis.getConsumptionPassRange();
            StringBuilder sLabel = new StringBuilder();
            sLabel.append(this.accessAnalysis.sourceClass.getName());
            sLabel.append("::");
            sLabel.append(property.getName());
            sLabel.append("\n: ");
            sLabel.append(this.accessAnalysis.targetClass.getName());
            if (property.isIsMany()) {
                sLabel.append("[*]");
            } else {
                sLabel.append(property.isIsRequired() ? "[1]" : "[?]");
            }
            sLabel.append("\n");
            if (this.isConsumption == null) {
                sLabel.append(productionPassRange);
                sLabel.append(" => ");
                sLabel.append(consumptionPassRange);
            } else {
                sLabel.append(this.isConsumption != false ? consumptionPassRange : productionPassRange);
            }
            String label = sLabel.toString();
            GraphStringBuilder s = toGraphHelper.getGraphStringBuilder();
            s.setLabel(label);
            s.setShape("rectangle");
            s.setStyle(type instanceof DataType ? "rounded" : "solid");
            s.setColor(this.isConsumption == null ? "blue" : "cyan");
            s.setPenwidth(Integer.valueOf(2));
            s.appendAttributedNode(nodeName);
        }
    }

    private class BasePropertyAnalysis
    implements Nameable {
        protected final @NonNull Property baseProperty;
        protected final @NonNull String name;
        protected final @NonNull Map<@NonNull CompleteClass, @NonNull Map<@NonNull CompleteClass, @NonNull AccessAnalysis>> sourceClass2targetClass2accessAnalysis = new HashMap<CompleteClass, Map<CompleteClass, AccessAnalysis>>();
        protected final @NonNull Map<@NonNull AccessAnalysis, @Nullable ConnectionAnalysis> consumingAnalysis2connectionAnalysis = new HashMap<AccessAnalysis, ConnectionAnalysis>();
        protected final @NonNull Map<@NonNull AccessAnalysis, @Nullable List<@NonNull ConnectionAnalysis>> producingAnalysis2connectionAnalyses = new HashMap<AccessAnalysis, List<ConnectionAnalysis>>();
        protected final @NonNull Map<@NonNull Set<@NonNull AccessAnalysis>, @NonNull ConnectionAnalysis> producingAnalyses2connectionAnalysis = new HashMap<Set<AccessAnalysis>, ConnectionAnalysis>();

        public BasePropertyAnalysis(Property baseProperty) {
            this.baseProperty = baseProperty;
            StringBuilder s = new StringBuilder();
            s.append(baseProperty.getOwningClass().getName());
            s.append("::");
            s.append(baseProperty.getName());
            if (baseProperty.isIsMany()) {
                s.append("[*]");
            } else {
                s.append(baseProperty.isIsRequired() ? "[1]" : "[?]");
            }
            Property oppositeProperty = baseProperty.getOpposite();
            if (oppositeProperty != null) {
                s.append(" <=> ");
                s.append(oppositeProperty.getOwningClass().getName());
                s.append("::");
                s.append(oppositeProperty.getName());
                if (baseProperty.isIsMany()) {
                    s.append("[*]");
                } else {
                    s.append(oppositeProperty.isIsRequired() ? "[1]" : "[?]");
                }
            }
            this.name = s.toString();
            assert (baseProperty == QVTscheduleUtil.getPrimaryProperty((Property)baseProperty));
        }

        public void accumulate(@NonNull BasePropertyAnalysis basePropertyAnalysis) {
            for (AccessAnalysis producingAnalysis : basePropertyAnalysis.producingAnalysis2connectionAnalyses.keySet()) {
                for (NamedElement producer : producingAnalysis.producers) {
                    this.addProducer(producer, producingAnalysis.sourceClass, producingAnalysis.property, producingAnalysis.targetClass);
                }
            }
            for (AccessAnalysis consumingAnalysis : basePropertyAnalysis.consumingAnalysis2connectionAnalysis.keySet()) {
                for (NavigationCallExp consumer : consumingAnalysis.consumers) {
                    this.addConsumer(consumer, consumingAnalysis.sourceClass, consumingAnalysis.property, consumingAnalysis.targetClass);
                }
            }
        }

        public void addConsumer(@NonNull NavigationCallExp navigationCallExp, @NonNull CompleteClass sourceClass, @NonNull Property property, @NonNull CompleteClass targetClass) {
            AccessAnalysis accessAnalysis = this.getAccessAnalysis(sourceClass, property, targetClass);
            accessAnalysis.addConsumer(navigationCallExp);
            if (!this.consumingAnalysis2connectionAnalysis.containsKey(accessAnalysis)) {
                this.consumingAnalysis2connectionAnalysis.put(accessAnalysis, null);
            }
        }

        public void addProducer(@NonNull NamedElement producer, @NonNull CompleteClass sourceClass, @NonNull Property property, @NonNull CompleteClass targetClass) {
            AccessAnalysis accessAnalysis = this.getAccessAnalysis(sourceClass, property, targetClass);
            accessAnalysis.addProducer(producer);
            if (!this.producingAnalysis2connectionAnalyses.containsKey(accessAnalysis)) {
                this.producingAnalysis2connectionAnalyses.put(accessAnalysis, null);
            }
        }

        public void analyze() {
            for (AccessAnalysis consumingAnalysis : this.consumingAnalysis2connectionAnalysis.keySet()) {
                HashSet<@NonNull AccessAnalysis> conformingProducingAnalyses = null;
                for (AccessAnalysis producingAnalysis : this.producingAnalysis2connectionAnalyses.keySet()) {
                    if (!this.isConforming(producingAnalysis, consumingAnalysis)) continue;
                    if (conformingProducingAnalyses == null) {
                        conformingProducingAnalyses = new HashSet<AccessAnalysis>();
                    }
                    conformingProducingAnalyses.add(producingAnalysis);
                }
                if (conformingProducingAnalyses == null) continue;
                ConnectionAnalysis connectionAnalysis = this.getConnectionAnalysis(conformingProducingAnalyses);
                connectionAnalysis.addConsumingAnalysis(consumingAnalysis);
                this.consumingAnalysis2connectionAnalysis.put(consumingAnalysis, connectionAnalysis);
            }
        }

        private void appendComplexPropertyAnalysis(@NonNull ToGraph toGraph, @NonNull Map<@NonNull Mapping, @NonNull MappingNode> mapping2mappingNode) {
            MappingNode mappingNode;
            HashMap<@NonNull ConnectionAnalysis, @NonNull ConnectionAnalysisNode> connectionAnalysis2connectionAnalysisNode = new HashMap<ConnectionAnalysis, ConnectionAnalysisNode>();
            HashMap<@NonNull AccessAnalysis, @NonNull AccessAnalysisNode> consumingAnalysis2accessAnalysisNode = new HashMap<AccessAnalysis, AccessAnalysisNode>();
            HashMap<@NonNull AccessAnalysis, @NonNull AccessAnalysisNode> producingAnalysis2accessAnalysisNode = new HashMap<AccessAnalysis, AccessAnalysisNode>();
            StringBuilder sLabel = new StringBuilder();
            sLabel.append(this.baseProperty.getOwningClass().getName());
            sLabel.append("::");
            sLabel.append(this.baseProperty.getName());
            String label = sLabel.toString();
            GraphStringBuilder context = toGraph.context;
            context.setLabel(label);
            context.setColor("blue");
            context.setStyle(this.baseProperty.getType() instanceof DataType ? "rounded" : "solid");
            context.setPenwidth(Integer.valueOf(2));
            context.pushCluster();
            for (ConnectionAnalysis connectionAnalysis : this.producingAnalyses2connectionAnalysis.values()) {
                this.getConnectionAnalysisNode(toGraph, connectionAnalysis, connectionAnalysis2connectionAnalysisNode);
            }
            for (AccessAnalysis producingAnalysis : this.producingAnalysis2connectionAnalyses.keySet()) {
                this.getAccessAnalysisNode(toGraph, producingAnalysis, producingAnalysis2accessAnalysisNode, false);
            }
            for (AccessAnalysis consumingAnalysis : this.consumingAnalysis2connectionAnalysis.keySet()) {
                this.getAccessAnalysisNode(toGraph, consumingAnalysis, consumingAnalysis2accessAnalysisNode, true);
            }
            context.popCluster();
            for (ConnectionAnalysis connectionAnalysis : connectionAnalysis2connectionAnalysisNode.keySet()) {
                ConnectionAnalysisNode connectionAnalysisNode = (ConnectionAnalysisNode)connectionAnalysis2connectionAnalysisNode.get(connectionAnalysis);
                assert (connectionAnalysisNode != null);
                for (AccessAnalysis consumingAnalysis : connectionAnalysis.consumingAnalyses) {
                    AccessAnalysisNode consumingAnalysisNode = (AccessAnalysisNode)consumingAnalysis2accessAnalysisNode.get(consumingAnalysis);
                    assert (consumingAnalysisNode != null);
                    context.appendEdge((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)connectionAnalysisNode, (GraphStringBuilder.GraphEdge)new ConnectionEdge(), (GraphStringBuilder.GraphNode)consumingAnalysisNode);
                }
                for (AccessAnalysis producingAnalysis : connectionAnalysis.producingAnalyses) {
                    AccessAnalysisNode producingAnalysisNode = (AccessAnalysisNode)producingAnalysis2accessAnalysisNode.get(producingAnalysis);
                    assert (producingAnalysisNode != null);
                    context.appendEdge((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)producingAnalysisNode, (GraphStringBuilder.GraphEdge)new ConnectionEdge(), (GraphStringBuilder.GraphNode)connectionAnalysisNode);
                }
            }
            for (AccessAnalysis producingAnalysis : this.producingAnalysis2connectionAnalyses.keySet()) {
                AccessAnalysisNode producingAnalysisNode = (AccessAnalysisNode)producingAnalysis2accessAnalysisNode.get(producingAnalysis);
                assert (producingAnalysisNode != null);
                for (NamedElement producer : producingAnalysis.producers) {
                    mappingNode = this.getMappingNode(mapping2mappingNode, producer);
                    context.appendEdge((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)mappingNode, (GraphStringBuilder.GraphEdge)new ProductionEdge(this.isNotify(producer)), (GraphStringBuilder.GraphNode)producingAnalysisNode);
                }
            }
            for (AccessAnalysis consumingAnalysis : this.consumingAnalysis2connectionAnalysis.keySet()) {
                AccessAnalysisNode consumingAnalysisNode = (AccessAnalysisNode)consumingAnalysis2accessAnalysisNode.get(consumingAnalysis);
                assert (consumingAnalysisNode != null);
                for (NavigationCallExp consumer : consumingAnalysis.consumers) {
                    mappingNode = this.getMappingNode(mapping2mappingNode, (NamedElement)consumer);
                    context.appendEdge((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)consumingAnalysisNode, (GraphStringBuilder.GraphEdge)new ConsumptionEdge(this.isObserve(consumer)), (GraphStringBuilder.GraphNode)mappingNode);
                }
            }
        }

        public void appendNode(@NonNull ToGraph toGraph, @NonNull Map<@NonNull Mapping, @NonNull MappingNode> mapping2mappingNode) {
            HashSet<@NonNull AccessAnalysis> allAccessAnalyses = new HashSet<AccessAnalysis>(this.consumingAnalysis2connectionAnalysis.keySet());
            allAccessAnalyses.addAll(this.producingAnalysis2connectionAnalyses.keySet());
            if (allAccessAnalyses.size() <= 1) {
                this.appendSimplePropertyAnalysis(toGraph, mapping2mappingNode, (AccessAnalysis)allAccessAnalyses.iterator().next());
            } else {
                this.appendComplexPropertyAnalysis(toGraph, mapping2mappingNode);
            }
        }

        private void appendSimplePropertyAnalysis(@NonNull ToGraph toGraph, @NonNull Map<@NonNull Mapping, @NonNull MappingNode> mapping2mappingNode, @NonNull AccessAnalysis accessAnalysis) {
            MappingNode mappingNode;
            GraphStringBuilder context = toGraph.context;
            AccessAnalysisNode accessAnalysisNode = new AccessAnalysisNode(accessAnalysis, null);
            context.appendNode((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)accessAnalysisNode);
            for (NavigationCallExp consumer : accessAnalysis.consumers) {
                mappingNode = this.getMappingNode(mapping2mappingNode, (NamedElement)consumer);
                ConsumptionEdge consumptionEdge = new ConsumptionEdge(this.isObserve(consumer));
                context.appendEdge((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)accessAnalysisNode, (GraphStringBuilder.GraphEdge)consumptionEdge, (GraphStringBuilder.GraphNode)mappingNode);
            }
            for (NamedElement producer : accessAnalysis.producers) {
                mappingNode = this.getMappingNode(mapping2mappingNode, producer);
                ProductionEdge productionEdge = new ProductionEdge(this.isNotify(producer));
                context.appendEdge((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)mappingNode, (GraphStringBuilder.GraphEdge)productionEdge, (GraphStringBuilder.GraphNode)accessAnalysisNode);
            }
        }

        public @NonNull AccessAnalysis getAccessAnalysis(@NonNull CompleteClass sourceClass, @NonNull Property property, @NonNull CompleteClass targetClass) {
            AccessAnalysis accessAnalysis;
            assert (!PivotUtil.isDataType((CompleteClass)sourceClass));
            Map<@NonNull CompleteClass, @NonNull AccessAnalysis> targetClass2accessAnalysis = this.sourceClass2targetClass2accessAnalysis.get(sourceClass);
            if (targetClass2accessAnalysis == null) {
                targetClass2accessAnalysis = new HashMap<CompleteClass, AccessAnalysis>();
                this.sourceClass2targetClass2accessAnalysis.put(sourceClass, targetClass2accessAnalysis);
            }
            if ((accessAnalysis = targetClass2accessAnalysis.get(targetClass)) == null) {
                accessAnalysis = new AccessAnalysis(this, sourceClass, property, targetClass);
                targetClass2accessAnalysis.put(targetClass, accessAnalysis);
            }
            return accessAnalysis;
        }

        protected @NonNull AccessAnalysisNode getAccessAnalysisNode(@NonNull ToGraph toGraph, @NonNull AccessAnalysis accessAnalysis, @NonNull Map<@NonNull AccessAnalysis, @NonNull AccessAnalysisNode> accessAnalysis2accessAnalysisNode, boolean isConsumption) {
            AccessAnalysisNode accessAnalysisNode = accessAnalysis2accessAnalysisNode.get(accessAnalysis);
            if (accessAnalysisNode == null) {
                accessAnalysisNode = new AccessAnalysisNode(accessAnalysis, isConsumption);
                accessAnalysis2accessAnalysisNode.put(accessAnalysis, accessAnalysisNode);
                toGraph.context.appendNode((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)accessAnalysisNode);
            }
            return accessAnalysisNode;
        }

        protected @NonNull ConnectionAnalysis getConnectionAnalysis(@NonNull Set<@NonNull AccessAnalysis> producingAnalyses) {
            ConnectionAnalysis connectionAnalysis = this.producingAnalyses2connectionAnalysis.get(producingAnalyses);
            if (connectionAnalysis == null) {
                connectionAnalysis = new ConnectionAnalysis(this, producingAnalyses);
                this.producingAnalyses2connectionAnalysis.put(producingAnalyses, connectionAnalysis);
                for (AccessAnalysis producingAnalysis : producingAnalyses) {
                    List<@NonNull ConnectionAnalysis> connectionAnalyses = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
                    if (connectionAnalyses == null) {
                        connectionAnalyses = new ArrayList<ConnectionAnalysis>();
                        this.producingAnalysis2connectionAnalyses.put(producingAnalysis, connectionAnalyses);
                    }
                    connectionAnalyses.add(connectionAnalysis);
                }
            }
            return connectionAnalysis;
        }

        protected @NonNull ConnectionAnalysisNode getConnectionAnalysisNode(@NonNull ToGraph toGraph, @NonNull ConnectionAnalysis connectionAnalysis, Map<@NonNull ConnectionAnalysis, @NonNull ConnectionAnalysisNode> connectionAnalysis2connectionAnalysisNode) {
            ConnectionAnalysisNode connectionAnalysisNode = connectionAnalysis2connectionAnalysisNode.get(connectionAnalysis);
            if (connectionAnalysisNode == null) {
                connectionAnalysisNode = new ConnectionAnalysisNode(connectionAnalysis);
                connectionAnalysis2connectionAnalysisNode.put(connectionAnalysis, connectionAnalysisNode);
                toGraph.context.appendNode((ToGraphHelper)toGraph, (GraphStringBuilder.GraphNode)connectionAnalysisNode);
            }
            return connectionAnalysisNode;
        }

        protected @NonNull MappingNode getMappingNode(@NonNull Map<@NonNull Mapping, @NonNull MappingNode> mapping2mappingNode, @NonNull NamedElement element) {
            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)element);
            assert (mapping != null);
            MappingNode mappingNode = mapping2mappingNode.get(mapping);
            if (mappingNode == null) {
                mappingNode = new MappingNode(mapping);
                mapping2mappingNode.put(mapping, mappingNode);
            }
            return mappingNode;
        }

        public @NonNull String getName() {
            return this.name;
        }

        private boolean isConforming(@NonNull CompleteClass producingSourceClass, @NonNull Property producingProperty, @NonNull CompleteClass producingTargetClass, @NonNull CompleteClass consumingSourceClass, @NonNull Property consumingProperty, @NonNull CompleteClass consumingTargetClass) {
            boolean conformingTarget;
            boolean conformingSource = QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)producingSourceClass, (CompleteClass)consumingSourceClass) || QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)consumingSourceClass, (CompleteClass)producingSourceClass);
            boolean bl = conformingTarget = QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)producingTargetClass, (CompleteClass)consumingTargetClass) || QVTscheduleUtil.conformsToClassOrBehavioralClass((CompleteClass)consumingTargetClass, (CompleteClass)producingTargetClass);
            return conformingSource && conformingTarget;
        }

        protected boolean isConforming(@NonNull AccessAnalysis producingAnalysis, @NonNull AccessAnalysis consumingAnalysis) {
            CompleteClass producingTargetClass;
            CompleteClass producingSourceClass;
            CompleteClass consumingTargetClass;
            CompleteClass consumingSourceClass;
            Property consumingProperty = consumingAnalysis.property;
            if (consumingProperty == this.baseProperty) {
                consumingSourceClass = consumingAnalysis.sourceClass;
                consumingTargetClass = consumingAnalysis.targetClass;
            } else {
                consumingSourceClass = consumingAnalysis.targetClass;
                consumingTargetClass = consumingAnalysis.sourceClass;
            }
            Property producingProperty = producingAnalysis.property;
            if (producingProperty == this.baseProperty) {
                producingSourceClass = producingAnalysis.sourceClass;
                producingTargetClass = producingAnalysis.targetClass;
            } else {
                producingSourceClass = producingAnalysis.targetClass;
                producingTargetClass = producingAnalysis.sourceClass;
            }
            return this.isConforming(producingSourceClass, producingProperty, producingTargetClass, consumingSourceClass, consumingProperty, consumingTargetClass);
        }

        private boolean isNotify(@NonNull NamedElement producer) {
            if (producer instanceof SetStatement) {
                return ((SetStatement)producer).isIsNotify();
            }
            return false;
        }

        private boolean isObserve(@NonNull NavigationCallExp callExp) {
            List observedProperties;
            Statement statement = QVTimperativeUtil.getContainingStatement((EObject)callExp);
            if (statement instanceof ObservableStatement && (observedProperties = ((ObservableStatement)statement).basicGetObservedProperties()) != null) {
                boolean contains1 = observedProperties.contains(this.baseProperty);
                boolean contains2 = observedProperties.contains(this.baseProperty.getOpposite());
                if (contains1) {
                    return true;
                }
                return contains2;
            }
            return false;
        }

        private boolean isTraceSlot(@NonNull NavigationCallExp consumer) {
            EObject eContainer = consumer.eContainer();
            if (!(eContainer instanceof DeclareStatement)) {
                return false;
            }
            OCLExpression ownedSource = QVTbaseUtil.getOwnedSource((CallExp)consumer);
            if (!(ownedSource instanceof VariableExp)) {
                return false;
            }
            VariableDeclaration referredVariable = QVTbaseUtil.getReferredVariable((VariableExp)((VariableExp)ownedSource));
            if (!(referredVariable instanceof GuardParameter)) {
                return false;
            }
            Property successProperty = ((GuardParameter)referredVariable).getSuccessProperty();
            return successProperty != null;
        }

        public @NonNull String toString() {
            return this.name;
        }

        public void validate(@Nullable StringBuilder s) {
            if (s != null) {
                s.append("\n  " + this.name);
                for (AccessAnalysis producingAnalysis : this.producingAnalysis2connectionAnalyses.keySet()) {
                    List<@NonNull ConnectionAnalysis> connectionAnalyses = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
                    if (connectionAnalyses != null) continue;
                    for (NamedElement producer : producingAnalysis.producers) {
                        Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)producer);
                        s.append("\n    unconnected " + mapping.getName() + " " + PassRange.create((Element)mapping) + " " + producer);
                    }
                }
                for (ConnectionAnalysis connectionAnalysis : this.producingAnalyses2connectionAnalysis.values()) {
                    boolean needsNotify = connectionAnalysis.needsNotify();
                    s.append("\n    connect produce " + connectionAnalysis.productionPassRange + " consume " + connectionAnalysis.consumptionPassRange + (needsNotify ? " needsNotify" : " not-needsNotify"));
                    for (AccessAnalysis producingAnalysis : connectionAnalysis.producingAnalyses) {
                        boolean needsNotify2 = false;
                        List<@NonNull ConnectionAnalysis> connectionAnalyses2 = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
                        assert (connectionAnalyses2 != null);
                        for (ConnectionAnalysis connectionAnalysis2 : connectionAnalyses2) {
                            if (!connectionAnalysis2.needsNotify()) continue;
                            needsNotify2 = true;
                        }
                        s.append("\n      produce " + producingAnalysis.name + " " + producingAnalysis.getProductionPassRange() + (needsNotify2 ? " needsNotify" : " not-needsNotify"));
                        for (NamedElement producer : producingAnalysis.producers) {
                            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)producer);
                            s.append("\n        in " + mapping.getName() + " " + PassRange.create((Element)mapping) + " " + producer);
                        }
                    }
                    for (AccessAnalysis consumingAnalysis : connectionAnalysis.consumingAnalyses) {
                        boolean needsObserve = !connectionAnalysis.getProductionPassRange().precedes(consumingAnalysis.getConsumptionPassRange());
                        s.append("\n      consume " + consumingAnalysis.name + " " + consumingAnalysis.getConsumptionPassRange() + (needsObserve ? " needsObserve" : " not-needsObserve"));
                        for (NavigationCallExp consumer : consumingAnalysis.consumers) {
                            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)consumer);
                            s.append("\n        in " + mapping.getName() + " " + PassRange.create((Element)mapping) + " " + consumer);
                        }
                    }
                }
            }
            ArrayList<@NonNull AccessAnalysis> producingAnalyses = new ArrayList<AccessAnalysis>(this.producingAnalysis2connectionAnalyses.keySet());
            Collections.sort(producingAnalyses, NameUtil.NAMEABLE_COMPARATOR);
            for (AccessAnalysis producingAnalysis : producingAnalyses) {
                this.validateNotifies(s, producingAnalysis);
            }
            ArrayList<@NonNull AccessAnalysis> consumingAnalyses = new ArrayList<AccessAnalysis>(this.consumingAnalysis2connectionAnalysis.keySet());
            Collections.sort(producingAnalyses, NameUtil.NAMEABLE_COMPARATOR);
            for (AccessAnalysis consumingAnalysis : consumingAnalyses) {
                this.validateObserves(s, consumingAnalysis);
            }
        }

        private void validateNotifies(@Nullable StringBuilder s, @NonNull AccessAnalysis producingAnalysis) {
            List<@NonNull ConnectionAnalysis> connectionAnalyses = this.producingAnalysis2connectionAnalyses.get(producingAnalysis);
            if (connectionAnalyses != null) {
                PassRange overallProductionPassRange = new PassRange();
                PassRange overallConsumptionPassRange = new PassRange();
                boolean passRangeNeedsNotify = false;
                for (ConnectionAnalysis connectionAnalysis : connectionAnalyses) {
                    PassRange consumptionPassRange;
                    PassRange productionPassRange = connectionAnalysis.getProductionPassRange();
                    if (!productionPassRange.precedes(consumptionPassRange = connectionAnalysis.getConsumptionPassRange())) {
                        passRangeNeedsNotify = true;
                    }
                    overallProductionPassRange = overallProductionPassRange.max(productionPassRange);
                    overallConsumptionPassRange = overallConsumptionPassRange.max(consumptionPassRange);
                }
                for (NamedElement producer : producingAnalysis.producers) {
                    boolean needsNotify = producer instanceof GuardParameter ? false : (producer instanceof NewStatementPart ? false : passRangeNeedsNotify);
                    boolean isNotify = this.isNotify(producer);
                    if (isNotify == needsNotify) continue;
                    Property property = producingAnalysis.property;
                    StringBuilder sProblem = new StringBuilder();
                    sProblem.append("The production of: ");
                    sProblem.append(PrettyPrinter.print((Element)property));
                    sProblem.append("\n\tat ");
                    sProblem.append(overallProductionPassRange);
                    sProblem.append(" should");
                    if (isNotify) {
                        sProblem.append(" not");
                    }
                    sProblem.append(" be notified for use at ");
                    sProblem.append(overallConsumptionPassRange);
                    Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)producer);
                    QVTiProductionConsumption.this.compilerStep.addProblem(new MappingProblem(CompilerProblem.Severity.WARNING, mapping, sProblem.toString()));
                    if (s == null) continue;
                    s.append("\n      BAD " + sProblem);
                }
            }
        }

        private void validateObserves(@Nullable StringBuilder s, @NonNull AccessAnalysis consumingAnalysis) {
            ConnectionAnalysis connectionAnalysis = this.consumingAnalysis2connectionAnalysis.get(consumingAnalysis);
            PassRange productionRange = connectionAnalysis != null ? connectionAnalysis.getProductionPassRange() : null;
            for (NavigationCallExp consumer : consumingAnalysis.consumers) {
                if (productionRange == null) {
                    OCLExpression ownedSource = PivotUtil.getOwnedSource((CallExp)consumer);
                    DomainUsage sourceUsage = QVTiProductionConsumption.this.domainUsageAnalysis.getUsage((Element)ownedSource);
                    if (sourceUsage.isThis()) continue;
                    Property property = consumingAnalysis.property;
                    StringBuilder sProblem = new StringBuilder();
                    sProblem.append("No possible producer of: ");
                    sProblem.append(PrettyPrinter.print((Element)property));
                    sProblem.append("\n\tcan satisfy expression: ");
                    sProblem.append(PrettyPrinter.print((Element)consumer));
                    sProblem.append("\n\tnavigation source type: ");
                    sProblem.append(PrettyPrinter.print((Element)consumingAnalysis.sourceClass.getPrimaryClass()));
                    sProblem.append("\n\tnavigation target type: ");
                    sProblem.append(PrettyPrinter.print((Element)consumingAnalysis.targetClass.getPrimaryClass()));
                    Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)consumer);
                    QVTiProductionConsumption.this.compilerStep.addProblem(new MappingProblem(CompilerProblem.Severity.WARNING, mapping, sProblem.toString()));
                    if (s == null) continue;
                    s.append("\n      BAD " + sProblem);
                    continue;
                }
                if (consumer.eContainer() instanceof SpeculateStatement) continue;
                PassRange consumerPassRange = PassRange.create((Element)consumer);
                boolean needsObserve = !productionRange.precedes(consumerPassRange) && !this.isTraceSlot(consumer);
                boolean isObserve = this.isObserve(consumer);
                if (isObserve == needsObserve) continue;
                Property property = consumingAnalysis.property;
                StringBuilder sProblem = new StringBuilder();
                sProblem.append("The production of: ");
                sProblem.append(PrettyPrinter.print((Element)property));
                sProblem.append("\n\tfor expression: ");
                sProblem.append(PrettyPrinter.print((Element)consumer));
                sProblem.append("\n\tat ");
                sProblem.append(productionRange);
                sProblem.append(" should");
                if (isObserve) {
                    sProblem.append(" not");
                }
                sProblem.append(" be observed at ");
                sProblem.append(consumerPassRange);
                Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)consumer);
                QVTiProductionConsumption.this.compilerStep.addProblem(new MappingProblem(CompilerProblem.Severity.WARNING, mapping, sProblem.toString()));
                if (s == null) continue;
                s.append("\n      BAD " + sProblem);
            }
        }
    }

    private class ConnectionAnalysis
    implements Nameable {
        protected final @NonNull BasePropertyAnalysis basePropertyAnalysis;
        protected final @NonNull Set<@NonNull AccessAnalysis> producingAnalyses;
        protected final @NonNull PassRange productionPassRange;
        protected final @NonNull List<@NonNull AccessAnalysis> consumingAnalyses = new ArrayList<AccessAnalysis>();
        private @NonNull PassRange consumptionPassRange = new PassRange();

        public ConnectionAnalysis(/*
         * Issues handling annotations - annotations may be inaccurate
         */
        @NonNull QVTiProductionConsumption. @NonNull BasePropertyAnalysis basePropertyAnalysis, Set<AccessAnalysis> producingAnalyses) {
            this.basePropertyAnalysis = basePropertyAnalysis;
            this.producingAnalyses = producingAnalyses;
            PassRange productionPassRange = new PassRange();
            for (AccessAnalysis producingAnalysis : producingAnalyses) {
                productionPassRange = productionPassRange.max(producingAnalysis.getProductionPassRange());
            }
            this.productionPassRange = productionPassRange;
        }

        public @NonNull PassRange getConsumptionPassRange() {
            return this.consumptionPassRange;
        }

        public @NonNull PassRange getProductionPassRange() {
            return this.productionPassRange;
        }

        public void addConsumingAnalysis(@NonNull AccessAnalysis consumingAnalysis) {
            assert (!this.consumingAnalyses.contains(consumingAnalysis));
            this.consumingAnalyses.add(consumingAnalysis);
            this.consumptionPassRange = this.consumptionPassRange.max(consumingAnalysis.getConsumptionPassRange());
        }

        public boolean needsNotify() {
            return !this.productionPassRange.precedes(this.consumptionPassRange);
        }

        public @NonNull String toString() {
            return String.valueOf(this.basePropertyAnalysis.toString()) + " " + this.productionPassRange + " " + this.consumptionPassRange;
        }

        public String getName() {
            return this.basePropertyAnalysis.getName();
        }
    }

    private class ConnectionAnalysisNode
    extends AbstractGraphNode {
        protected final @NonNull ConnectionAnalysis connectionAnalysis;

        protected ConnectionAnalysisNode(ConnectionAnalysis connectionAnalysis) {
            this.connectionAnalysis = connectionAnalysis;
        }

        public void appendNode(@NonNull ToGraphHelper toGraphHelper, @NonNull String nodeName) {
            BasePropertyAnalysis basePropertyAnalysis = this.connectionAnalysis.basePropertyAnalysis;
            Property baseProperty = basePropertyAnalysis.baseProperty;
            StringBuilder sLabel = new StringBuilder();
            sLabel.append(baseProperty.getOwningClass().getName());
            sLabel.append("::");
            sLabel.append(baseProperty.getName());
            String label = sLabel.toString();
            GraphStringBuilder s = toGraphHelper.getGraphStringBuilder();
            s.setLabel(label);
            s.setShape("ellipse");
            s.setStyle("solid");
            s.setColor("cyan");
            s.setPenwidth(Integer.valueOf(2));
            s.appendAttributedNode(nodeName);
        }
    }

    protected static class ConnectionEdge
    extends AbstractGraphEdge {
        protected ConnectionEdge() {
        }

        public void appendEdgeAttributes(@NonNull ToGraphHelper toGraphHelper, @NonNull String sourceName, @NonNull String targetName) {
            GraphStringBuilder s = toGraphHelper.getGraphStringBuilder();
            s.setColor("cyan");
            s.setPenwidth(Integer.valueOf(1));
            s.appendAttributedEdge(sourceName, (GraphStringBuilder.GraphEdge)this, targetName);
        }
    }

    protected static class ConsumptionEdge
    extends AbstractGraphEdge {
        private final boolean isObserve;

        protected ConsumptionEdge(boolean isObserve) {
            this.isObserve = isObserve;
        }

        public void appendEdgeAttributes(@NonNull ToGraphHelper toGraphHelper, @NonNull String sourceName, @NonNull String targetName) {
            GraphStringBuilder s = toGraphHelper.getGraphStringBuilder();
            s.setColor(this.isObserve ? "brown" : "orange");
            s.setPenwidth(Integer.valueOf(this.isObserve ? 2 : 1));
            s.appendAttributedEdge(sourceName, (GraphStringBuilder.GraphEdge)this, targetName);
        }
    }

    private class MappingNode
    extends AbstractGraphNode {
        protected final @NonNull Mapping mapping;

        protected MappingNode(Mapping mapping) {
            this.mapping = mapping;
        }

        public void appendNode(@NonNull ToGraphHelper toGraphHelper, @NonNull String nodeName) {
            GraphStringBuilder s = toGraphHelper.getGraphStringBuilder();
            s.setLabel(String.valueOf(this.mapping.getName()) + "\n" + PassRange.create((Element)this.mapping));
            s.setShape("rectangle");
            s.setStyle("solid");
            s.setColor("green");
            s.setPenwidth(Integer.valueOf(2));
            s.appendAttributedNode(nodeName);
        }
    }

    private static class PassRange {
        private final int first;
        private final int last;

        public static @NonNull PassRange create(@NonNull Element element) {
            Mapping mapping = QVTimperativeUtil.getContainingMapping((EObject)element);
            int firstPass = mapping.getFirstPass();
            Integer lastPass = mapping.getLastPass();
            return new PassRange(firstPass, lastPass == null ? firstPass : lastPass);
        }

        public static @NonNull PassRange create(@NonNull List<? extends @NonNull Element> elements) {
            PassRange passRange = new PassRange();
            for (Element element : elements) {
                passRange = PassRange.create(element).max(passRange);
            }
            return passRange;
        }

        public PassRange() {
            this.first = Integer.MAX_VALUE;
            this.last = Integer.MIN_VALUE;
        }

        public PassRange(int first, int last) {
            this.first = first;
            this.last = last;
            assert (first <= last);
        }

        public boolean equals(Object obj) {
            PassRange that = (PassRange)obj;
            return this.first == that.first && this.last == that.last;
        }

        public int hashCode() {
            return this.first * 7 + this.last * 97;
        }

        public @NonNull PassRange max(@NonNull PassRange passRange) {
            if (this.equals(passRange)) {
                return this;
            }
            return new PassRange(Math.min(this.first, passRange.first), Math.max(this.last, passRange.last));
        }

        public boolean precedes(@NonNull PassRange passRange) {
            return this.last < passRange.first;
        }

        public @NonNull String toString() {
            if (this.first < this.last) {
                return "[" + this.first + ".." + this.last + "]";
            }
            if (this.first == this.last) {
                return "[" + this.first + "]";
            }
            return "[]";
        }
    }

    protected static class ProductionEdge
    extends AbstractGraphEdge {
        private final boolean isNotify;

        protected ProductionEdge(boolean isNotify) {
            this.isNotify = isNotify;
        }

        public void appendEdgeAttributes(@NonNull ToGraphHelper toGraphHelper, @NonNull String sourceName, @NonNull String targetName) {
            GraphStringBuilder s = toGraphHelper.getGraphStringBuilder();
            s.setColor(this.isNotify ? "brown" : "orange");
            s.setPenwidth(Integer.valueOf(this.isNotify ? 2 : 1));
            s.appendAttributedEdge(sourceName, (GraphStringBuilder.GraphEdge)this, targetName);
        }
    }

    protected class ToGraph
    implements ToGraphHelper {
        protected final @NonNull GraphStringBuilder context;

        protected ToGraph(GraphStringBuilder context) {
            this.context = context;
        }

        public @NonNull GraphStringBuilder getGraphStringBuilder() {
            return this.context;
        }

        protected @NonNull String getLabel(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode graphNode) {
            String label = "";
            if (graphNode instanceof BasePropertyAnalysis) {
                BasePropertyAnalysis node = (BasePropertyAnalysis)graphNode;
                label = node.getName();
            }
            return label;
        }

        public void setColor(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphElement element) {
            throw new UnsupportedOperationException();
        }

        public void setHead(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode node) {
            throw new UnsupportedOperationException();
        }

        public void setLabel(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode node) {
            String label = this.getLabel(node);
            this.context.setLabel(label);
        }

        public void setPenwidth(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode node) {
            throw new UnsupportedOperationException();
        }

        public void setShapeAndStyle(// Could not load outer class - annotation placement on inner may be incorrect
        @NonNull GraphStringBuilder.GraphNode node) {
            throw new UnsupportedOperationException();
        }
    }
}

