/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.qvtd.compiler.internal.qvtr2qvts;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.ocl.pivot.Class;
import org.eclipse.ocl.pivot.Element;
import org.eclipse.ocl.pivot.Property;
import org.eclipse.ocl.pivot.Type;
import org.eclipse.ocl.pivot.VariableDeclaration;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.InvocationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.QVTrelationScheduleManager;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.RelationAnalysis;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Invocation2TraceProperty;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2MiddleType;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceClass;
import org.eclipse.qvtd.compiler.internal.qvtr2qvts.trace.Relation2TraceGroup;
import org.eclipse.qvtd.pivot.qvtbase.Rule;
import org.eclipse.qvtd.pivot.qvtbase.TypedModel;
import org.eclipse.qvtd.pivot.qvtrelation.Relation;
import org.eclipse.qvtd.pivot.qvtrelation.utilities.QVTrelationUtil;
import org.eclipse.qvtd.pivot.qvtschedule.ClassDatum;
import org.eclipse.qvtd.pivot.qvtschedule.NavigableEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Node;
import org.eclipse.qvtd.pivot.qvtschedule.SuccessEdge;
import org.eclipse.qvtd.pivot.qvtschedule.Utility;

public abstract class AbstractInvocationAnalysis
implements InvocationAnalysis {
    protected final @NonNull RelationAnalysis invokingRelationAnalysis;
    protected final @NonNull RelationAnalysis invokedRelationAnalysis;
    protected final @NonNull QVTrelationScheduleManager scheduleManager;
    protected final @NonNull Map<@NonNull VariableDeclaration, @NonNull Node> rootVariable2argumentNode;
    protected final @NonNull Utility utility;
    private @Nullable Node invokingNode = null;
    private final @NonNull Map<@NonNull Node, @NonNull Boolean> argumentNode2isOutput = new HashMap<Node, Boolean>();

    public AbstractInvocationAnalysis(@NonNull RelationAnalysis invokingRelationAnalysis, @NonNull RelationAnalysis invokedRelationAnalysis, @NonNull Utility utility, @NonNull Map<@NonNull VariableDeclaration, @NonNull Node> rootVariable2argumentNode) {
        this.invokingRelationAnalysis = invokingRelationAnalysis;
        this.invokedRelationAnalysis = invokedRelationAnalysis;
        this.scheduleManager = invokedRelationAnalysis.getScheduleManager();
        this.rootVariable2argumentNode = rootVariable2argumentNode;
        this.utility = utility;
    }

    protected abstract @NonNull NavigableEdge createInputEdge(@NonNull Node var1, @NonNull Property var2, @NonNull Node var3);

    protected void createInvocationEdges(@NonNull Node invokedNode) {
        Relation2MiddleType baseInvokedRule2MiddleType = this.getBaseInvokedRule2MiddleType();
        Relation baseInvokedRelation = this.getBaseInvokedRelation();
        for (VariableDeclaration rootVariable : this.rootVariable2argumentNode.keySet()) {
            Node argumentNode = this.rootVariable2argumentNode.get(rootVariable);
            assert (argumentNode != null);
            VariableDeclaration overriddenRootVariable = QVTrelationUtil.getOverriddenVariable((Relation)baseInvokedRelation, (VariableDeclaration)rootVariable);
            Property invocationProperty = baseInvokedRule2MiddleType.getTraceProperty(overriddenRootVariable);
            boolean isOutput = this.scheduleManager.isOutputInRule((Rule)baseInvokedRelation, (Element)overriddenRootVariable);
            if (isOutput) {
                this.createOutputEdge(invokedNode, invocationProperty, argumentNode);
            } else {
                this.createInputEdge(invokedNode, invocationProperty, argumentNode);
            }
            this.argumentNode2isOutput.put(argumentNode, isOutput);
        }
    }

    protected abstract @NonNull Node createInvocationNode();

    protected void createInvokingTraceEdge(@NonNull Node invokedNode, @NonNull Node invokingTraceNode) {
        Relation2TraceGroup invokingRule2TraceGroup = this.invokingRelationAnalysis.getRule2TraceGroup();
        Relation2TraceClass invokingRule2TraceClass = invokingRule2TraceGroup.getRule2TraceClass();
        Invocation2TraceProperty invokingInvocation2TraceProperty = invokingRule2TraceClass.getInvocation2TraceProperty(this);
        Property invocationTraceProperty = invokingInvocation2TraceProperty.getTraceProperty();
        boolean isPartial = this.scheduleManager.computeIsPartial(invokedNode, invocationTraceProperty);
        this.invokingRelationAnalysis.createRealizedNavigationEdge(this.utility, invokingTraceNode, invocationTraceProperty, invokedNode, isPartial);
    }

    protected abstract @NonNull NavigableEdge createOutputEdge(@NonNull Node var1, @NonNull Property var2, @NonNull Node var3);

    @Override
    public @NonNull Iterable<@NonNull Node> getArgumentNodes() {
        return this.rootVariable2argumentNode.values();
    }

    protected @NonNull Relation getBaseInvokedRelation() {
        return QVTrelationUtil.getBaseRelation((Relation)this.invokedRelationAnalysis.getRule());
    }

    protected @NonNull Relation2MiddleType getBaseInvokedRule2MiddleType() {
        Relation invokedRelation = this.invokedRelationAnalysis.getRule();
        Relation baseInvokedRelation = this.getBaseInvokedRelation();
        RelationAnalysis baseInvokedRelationAnalysis = this.scheduleManager.getRuleAnalysis((Rule)baseInvokedRelation);
        Relation2TraceGroup baseInvokedrelation2traceGroup = baseInvokedRelationAnalysis.getRule2TraceGroup();
        Relation2MiddleType baseInvokedRule2MiddleType = QVTrelationUtil.hasOverrides((Relation)invokedRelation) ? baseInvokedrelation2traceGroup.getRule2DispatchClass() : (this.isTop() ? baseInvokedrelation2traceGroup.getRule2TraceInterface() : baseInvokedrelation2traceGroup.getRule2InvocationInterface());
        return baseInvokedRule2MiddleType;
    }

    protected @NonNull ClassDatum getInvokedClassDatum() {
        TypedModel traceTypedModel = this.scheduleManager.getTraceTypedModel();
        Relation2MiddleType invokedRelation2InvocationInterface = this.getInvokedRelation2InvocationInterface();
        Class invokedInvocationInterface = invokedRelation2InvocationInterface.getMiddleClass();
        return this.scheduleManager.getClassDatum(traceTypedModel, (Type)invokedInvocationInterface);
    }

    @Override
    public @NonNull RelationAnalysis getInvokedRelationAnalysis() {
        return this.invokedRelationAnalysis;
    }

    protected @NonNull Relation2MiddleType getInvokedRelation2InvocationInterface() {
        Relation2TraceGroup invokedBaserelation2traceGroup = this.invokedRelationAnalysis.getRule2TraceGroup().getBaseRelation2TraceGroup();
        Relation2MiddleType invokedRelation2InvocationInterface = invokedBaserelation2traceGroup.getRule2InvocationInterface();
        return invokedRelation2InvocationInterface;
    }

    @Override
    public @NonNull Node getInvokingNode() {
        Node invokingNode2 = this.invokingNode;
        if (invokingNode2 == null) {
            this.invokingNode = invokingNode2 = this.createInvocationNode();
        }
        return invokingNode2;
    }

    @Override
    public @NonNull RelationAnalysis getInvokingRelationAnalysis() {
        return this.invokingRelationAnalysis;
    }

    @Override
    public @Nullable SuccessEdge getGlobalSuccessEdge(@Nullable Boolean successStatus) {
        return null;
    }

    @Override
    public final boolean isOptional() {
        return this.utility.isNullable() || this.utility.isConditional();
    }

    @Override
    public @Nullable Boolean isOutput(@NonNull Node node) {
        return this.argumentNode2isOutput.get(node);
    }

    @Override
    public boolean isRealized() {
        assert (this.invokingNode != null);
        return this.invokingNode.isRealized();
    }

    @Override
    public boolean needsInvocationTraceProperty() {
        return true;
    }

    @Override
    public void setStrict(boolean isStrict) {
        assert (this.invokingNode != null);
        this.invokingNode.setStrict(isStrict);
    }

    @Override
    public @NonNull Node synthesizeInvocationNodes(@NonNull Node invokingTraceNode) {
        Node invokingNode = this.getInvokingNode();
        this.createInvokingTraceEdge(invokingNode, invokingTraceNode);
        this.getGlobalSuccessEdge(Boolean.TRUE);
        this.createInvocationEdges(invokingNode);
        return invokingNode;
    }
}

