/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.tools.launch.rwt.internal.shortcut;

import java.util.Arrays;
import java.util.List;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;

class TypeInspector {
    private static final String[] NO_PARAMETERS = new String[0];
    private static final String[] COMPOSITE_PARAMETER = new String[]{"QComposite;"};
    private static final String[] APPLICATION_PARAMETER = new String[]{"QApplication;"};
    private final IType type;

    TypeInspector(IType type) {
        this.type = type;
    }

    boolean isEntryPointType() throws JavaModelException {
        boolean result = false;
        if (this.type.isClass() && !this.isAbstract()) {
            if (this.implementsEntryPoint()) {
                result = this.hasCreateUIMethod();
            } else if (this.extendsAbstractEntryPoint()) {
                result = this.hasCreateContentsMethod();
            }
        }
        return result;
    }

    boolean isApplicationConfigurationType() throws JavaModelException {
        return this.type.isClass() && !this.isAbstract() && this.implementsApplicationConfiguration() && this.hasConfigureMethod();
    }

    private boolean implementsEntryPoint() throws JavaModelException {
        List<String> superInterfaceNames = Arrays.asList(this.type.getSuperInterfaceNames());
        return superInterfaceNames.contains("EntryPoint") || superInterfaceNames.contains("IEntryPoint");
    }

    private boolean hasCreateUIMethod() {
        IMethod method = this.type.getMethod("createUI", NO_PARAMETERS);
        return method.exists();
    }

    private boolean extendsAbstractEntryPoint() throws JavaModelException {
        String superClassName = this.type.getSuperclassName();
        return "AbstractEntryPoint".equals(superClassName);
    }

    private boolean hasCreateContentsMethod() {
        IMethod method = this.type.getMethod("createContents", COMPOSITE_PARAMETER);
        return method.exists();
    }

    private boolean isAbstract() throws JavaModelException {
        return Flags.isAbstract((int)this.type.getFlags());
    }

    private boolean implementsApplicationConfiguration() throws JavaModelException {
        List<String> superInterfaceNames = Arrays.asList(this.type.getSuperInterfaceNames());
        return superInterfaceNames.contains("ApplicationConfiguration");
    }

    private boolean hasConfigureMethod() {
        IMethod method = this.type.getMethod("configure", APPLICATION_PARAMETER);
        return method.exists();
    }
}

