/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.environment.IEnvironment;
import org.eclipse.scout.sdk.core.s.environment.IProgress;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.core.s.jaxws.AbstractWebServiceNewOperation;
import org.eclipse.scout.sdk.core.s.jaxws.JaxWsUtils;
import org.eclipse.scout.sdk.core.s.jaxws.WebServiceUpdateOperation;
import org.eclipse.scout.sdk.core.s.util.ITier;
import org.eclipse.scout.sdk.core.s.util.ScoutTier;
import org.eclipse.scout.sdk.core.util.Ensure;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.EclipseEnvironment;
import org.eclipse.scout.sdk.s2e.environment.EclipseProgress;
import org.eclipse.scout.sdk.s2e.environment.WorkingCopyManager;
import org.eclipse.scout.sdk.s2e.operation.jaxws.RebuildArtifactsOperation;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.WebServiceNewWizard;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.WebServiceNewWizardPage;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.ErrorFormPage;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.WebServiceEditorInput;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.WebServiceFormPage;
import org.eclipse.scout.sdk.s2e.ui.internal.jaxws.editor.WebServiceFormPageInput;
import org.eclipse.scout.sdk.s2e.util.ApiHelper;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;
import org.eclipse.scout.sdk.s2e.util.S2eTier;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public class WebServiceEditor
extends FormEditor {
    public static final String WEB_SERVICE_EDITOR_ID = "org.eclipse.scout.sdk.s2e.ui.jaxwsEditor";
    public static final String WEB_SERVICE_FILE_EXTENSION = "jaxws";
    private IJavaProject m_project;
    private IFile m_jaxwsFile;

    protected void addPages() {
        IEditorInput input = this.getEditorInput();
        if (!(input instanceof FileEditorInput)) {
            this.showError("Invalid input for Web Service Editor: " + String.valueOf(input), new IllegalArgumentException());
            return;
        }
        this.m_jaxwsFile = ((IFileEditorInput)input).getFile();
        if (this.getJaxwsFile() == null || !this.getJaxwsFile().exists()) {
            this.showError("Invalid file input for Web Service Editor: " + String.valueOf(this.getJaxwsFile()), new IllegalArgumentException());
            return;
        }
        this.m_project = JavaCore.create((IProject)this.getJaxwsFile().getProject());
        if (!JdtUtils.exists((IJavaElement)this.getJavaProject())) {
            this.showError("Invalid project input for Web Service Editor: " + String.valueOf(this.getJavaProject()), new IllegalArgumentException());
            return;
        }
        if (!S2eTier.wrap((ITier)ScoutTier.Server).test((IJavaElement)this.getJavaProject())) {
            this.showError("Invalid project type: " + this.getJavaProject().getElementName() + " is not a server project", new IllegalArgumentException());
            return;
        }
        this.setPartName(this.getJavaProject().getProject().getName() + " Web Services");
        String idToActivate = null;
        if (input instanceof WebServiceEditorInput) {
            idToActivate = ((WebServiceEditorInput)input).getPageIdToActivate();
        }
        this.reload(idToActivate);
    }

    protected void addPageSafe(IFormPage page) {
        if (this.getContainer().isDisposed()) {
            return;
        }
        try {
            this.addPage(page);
        }
        catch (PartInitException e) {
            SdkLog.error((CharSequence)"Unable to add page to editor.", (Object[])new Object[]{e});
        }
    }

    protected void showError(String msg, Throwable t) {
        this.addPageSafe((IFormPage)new ErrorFormPage(this, msg, t));
        SdkLog.error((CharSequence)msg, (Object[])new Object[]{t});
    }

    protected void rebuildAllArtifacts() {
        EclipseEnvironment.runInEclipseEnvironment((BiConsumer)new EditorOperationWrapper((BiConsumer<? super EclipseEnvironment, ? super EclipseProgress>)new RebuildArtifactsOperation(this.getJavaProject())));
    }

    protected void startNewWebServiceWizard() {
        WebServiceNewWizard wiz = new WebServiceNewWizard();
        StructuredSelection selection = new StructuredSelection((Object)this.getJaxwsFile());
        wiz.init(PlatformUI.getWorkbench(), (IStructuredSelection)selection);
        wiz.getFinishTask().withUiAction((op, d) -> d.asyncExec(() -> this.reload(op.getCreatedWsdlFile().getFileName().toString())));
        WebServiceNewWizardPage wizPage = wiz.getWebServiceNewWizardPage();
        wizPage.setIsCreateNewProject(false);
        wizPage.setExistingJaxWsProject(this.getJavaProject());
        WizardDialog dialog = new WizardDialog(this.getContainer().getShell(), (IWizard)wiz);
        dialog.open();
    }

    protected boolean collectWebServicesAsync(Widget shell, Collection<WebServiceFormPageInput> webServices, IProgressMonitor monitor) {
        Set<WebServiceFormPageInput> result = this.findWebServices(monitor);
        boolean canceled = monitor.isCanceled();
        if (canceled) {
            shell.getDisplay().asyncExec(() -> this.close(false));
        } else {
            webServices.addAll(result);
        }
        return canceled;
    }

    protected void reload(String idToActivate) {
        IFormPage activatedPage;
        this.removeAllPages();
        TreeSet webServices = new TreeSet();
        Shell shell = this.getSite().getShell();
        boolean[] isCanceled = new boolean[1];
        try {
            new ProgressMonitorDialog(shell).run(true, true, monitor -> {
                isCanceled[0] = this.collectWebServicesAsync((Widget)shell, webServices, monitor);
            });
        }
        catch (InterruptedException | InvocationTargetException e) {
            this.showError("Unable to search for web services in project: " + this.getJavaProject().getElementName(), e);
            return;
        }
        if (isCanceled[0]) {
            this.addPageSafe((IFormPage)new ErrorFormPage(this, null, null));
            return;
        }
        if (webServices.isEmpty()) {
            this.showError("No web services found in project " + this.getJavaProject().getElementName(), null);
            return;
        }
        for (WebServiceFormPageInput input : webServices) {
            this.addPageSafe((IFormPage)new WebServiceFormPage(this, input));
        }
        if (this.getContainer().isDisposed()) {
            return;
        }
        if (idToActivate != null && (activatedPage = this.setActivePage(idToActivate)) != null) {
            return;
        }
        if (this.getPageCount() > 0) {
            this.setActivePage(0);
        } else {
            this.showError("No pages found.", null);
        }
    }

    protected IFormPage getPage(int index) {
        Object result = this.pages.get(index);
        if (result instanceof IFormPage) {
            return (IFormPage)result;
        }
        return null;
    }

    protected void removeAllPages() {
        while (this.getPageCount() > 0) {
            IFormPage page = this.getPage(0);
            this.removePage(page.getIndex());
            if (page.isEditor()) continue;
            page.dispose();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<WebServiceFormPageInput> findWebServices(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)"Loading contents", (int)100);
        if (progress.isCanceled()) {
            return Collections.emptySet();
        }
        Path wsdlFolder = AbstractWebServiceNewOperation.getWsdlRootFolder((Path)this.getJavaProject().getProject().getLocation().toFile().toPath());
        progress.worked(5);
        IJavaSearchScope scope = JdtUtils.createJavaSearchScope((IJavaElement[])new IJavaElement[]{this.getJavaProject()});
        IScoutApi scoutApi = ApiHelper.requireScoutApiFor((IJavaElement)this.getJavaProject());
        Set webServiceEntryPointAnnotatedTypes = JdtUtils.findAllTypesAnnotatedWith((String)scoutApi.WebServiceEntryPoint().fqn(), (IJavaSearchScope)scope, (IProgressMonitor)progress.newChild(10));
        Set webServiceClientAnnotatedTypes = JdtUtils.findAllTypesAnnotatedWith((String)scoutApi.WebServiceClient().fqn(), (IJavaSearchScope)scope, (IProgressMonitor)progress.newChild(10));
        Set webServiceAnnotatedTypes = JdtUtils.findAllTypesAnnotatedWith((String)scoutApi.WebService().fqn(), (IJavaSearchScope)scope, (IProgressMonitor)progress.newChild(10));
        if (progress.isCanceled()) {
            return Collections.emptySet();
        }
        try (Stream<Path> content = Files.walk(wsdlFolder, new FileVisitOption[0]);){
            Set services = content.filter(JaxWsUtils::isWsdlFile).map(f -> new P_PreloadedWebServiceData((Path)f, this.getJavaProject(), scoutApi, webServiceEntryPointAnnotatedTypes, webServiceClientAnnotatedTypes, webServiceAnnotatedTypes)).collect(TreeSet::new, Set::add, Set::addAll);
            progress.worked(5);
            if (progress.isCanceled() || services.isEmpty()) {
                Set<WebServiceFormPageInput> set = Collections.emptySet();
                return set;
            }
            int progressPerItem = 50 / services.size();
            for (WebServiceFormPageInput s : services) {
                s.load((IProgressMonitor)progress.newChild(progressPerItem));
                if (!progress.isCanceled()) continue;
                Set<WebServiceFormPageInput> set = Collections.emptySet();
                return set;
            }
            services.removeIf(data -> data.getAllPortTypes().isEmpty());
            Set set = services;
            return set;
        }
        catch (IOException | JavaModelException e) {
            throw new SdkException(e);
        }
    }

    public void doSave(IProgressMonitor monitor) {
        List<WebServiceFormPage> allPages = this.getAllPages();
        ArrayList<WebServiceFormPage> pagesToSave = new ArrayList<WebServiceFormPage>(allPages.size());
        boolean isValid = true;
        for (WebServiceFormPage page : allPages) {
            if (!page.isDirty()) continue;
            if (page.isValid()) {
                pagesToSave.add(page);
                continue;
            }
            this.setActivePage(page.getIndex());
            isValid = false;
            break;
        }
        if (!isValid || pagesToSave.isEmpty()) {
            return;
        }
        EclipseEnvironment.runInEclipseEnvironment((BiConsumer)new EditorOperationWrapper((e, p) -> this.savePages((Collection<WebServiceFormPage>)pagesToSave, (EclipseEnvironment)e, (EclipseProgress)p)));
    }

    protected void savePages(Collection<WebServiceFormPage> pagesToSave, EclipseEnvironment env, EclipseProgress progress) {
        pagesToSave.stream().map(page -> WebServiceEditor.pageToOperation(env, page)).forEach(op -> op.accept(env, progress));
        WorkingCopyManager.currentWorkingCopyManager().checkpoint((IProgressMonitor)progress.monitor());
        new RebuildArtifactsOperation(this.getJavaProject()).accept((IEnvironment)env, (IProgress)progress);
    }

    protected static BiConsumer<IEnvironment, IProgress> pageToOperation(EclipseEnvironment env, WebServiceFormPage page) {
        WebServiceUpdateOperation op = new WebServiceUpdateOperation();
        page.fillOperation(op, env);
        return op;
    }

    public List<WebServiceFormPage> getAllPages() {
        return this.pages.stream().filter(o -> o instanceof WebServiceFormPage).map(o -> (WebServiceFormPage)((Object)((Object)o))).collect(Collectors.toList());
    }

    public void doSaveAs() {
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public IJavaProject getJavaProject() {
        return this.m_project;
    }

    public IFile getJaxwsFile() {
        return this.m_jaxwsFile;
    }

    protected class EditorOperationWrapper
    implements BiConsumer<EclipseEnvironment, EclipseProgress> {
        private final BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> m_wrappedOperation;

        public EditorOperationWrapper(BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> operation) {
            this.m_wrappedOperation = (BiConsumer)Ensure.notNull(operation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void accept(EclipseEnvironment env, EclipseProgress progress) {
            List<WebServiceFormPage> allPages = WebServiceEditor.this.getAllPages();
            Composite c = WebServiceEditor.this.getContainer();
            String idToActivate = WebServiceEditor.this.getActivePageInstance().getId();
            c.getDisplay().syncExec(() -> {
                c.setCursor(c.getDisplay().getSystemCursor(1));
                this.setEnabled(allPages, false);
            });
            try {
                this.getWrappedOperation().accept((EclipseEnvironment)env, (EclipseProgress)progress);
            }
            finally {
                this.refreshAfterSave((Control)c, idToActivate, allPages);
            }
        }

        protected void refreshAfterSave(Control c, String idToActivate, Iterable<WebServiceFormPage> allPages) {
            if (c.isDisposed()) {
                return;
            }
            c.getDisplay().asyncExec(() -> {
                if (c.isDisposed()) {
                    return;
                }
                c.setCursor(null);
                WebServiceEditor.this.reload(idToActivate);
                WebServiceEditor.this.editorDirtyStateChanged();
                this.setEnabled(allPages, true);
            });
        }

        protected void setEnabled(Iterable<WebServiceFormPage> allPages, boolean enabled) {
            WebServiceEditor.this.getContainer().setEnabled(enabled);
            for (WebServiceFormPage page : allPages) {
                page.setEnabled(enabled);
            }
        }

        public BiConsumer<? super EclipseEnvironment, ? super EclipseProgress> getWrappedOperation() {
            return this.m_wrappedOperation;
        }
    }

    private static final class P_PreloadedWebServiceData
    extends WebServiceFormPageInput {
        private final Set<IType> m_typesAnnotatedWithWebServiceEntryPoint;
        private final Set<IType> m_typesAnnotatedWithWebServiceClient;
        private final Set<IType> m_typesAnnotatedWithWebService;

        private P_PreloadedWebServiceData(Path wsdl, IJavaProject javaProject, IScoutApi api, Set<IType> typesAnnotatedWithWebServiceEntryPoint, Set<IType> typesAnnotatedWithWebServiceClient, Set<IType> typesAnnotatedWithWebService) {
            super(wsdl, javaProject, api);
            this.m_typesAnnotatedWithWebServiceEntryPoint = typesAnnotatedWithWebServiceEntryPoint;
            this.m_typesAnnotatedWithWebServiceClient = typesAnnotatedWithWebServiceClient;
            this.m_typesAnnotatedWithWebService = typesAnnotatedWithWebService;
        }

        @Override
        protected Set<IType> findAllTypesAnnotatedWith(String fqn) {
            IScoutApi scoutApi = this.getScoutApi();
            if (scoutApi.WebServiceEntryPoint().fqn().equals(fqn)) {
                return this.m_typesAnnotatedWithWebServiceEntryPoint;
            }
            if (scoutApi.WebServiceClient().fqn().equals(fqn)) {
                return this.m_typesAnnotatedWithWebServiceClient;
            }
            if (scoutApi.WebService().fqn().equals(fqn)) {
                return this.m_typesAnnotatedWithWebService;
            }
            throw new IllegalArgumentException();
        }
    }
}

