/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.ui.internal.template;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.Annotation;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ImportDeclaration;
import org.eclipse.jdt.core.dom.MethodInvocation;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleMemberAnnotation;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.TypeLiteral;
import org.eclipse.jdt.internal.corext.dom.Bindings;
import org.eclipse.scout.sdk.core.s.java.apidef.IScoutApi;
import org.eclipse.scout.sdk.s2e.ui.internal.template.AbstractTypeProposal;
import org.eclipse.scout.sdk.s2e.ui.internal.template.TypeProposalContext;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AbstractAstBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstInnerTypeGetterBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstNodeFactory;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.AstTypeBuilder;
import org.eclipse.scout.sdk.s2e.ui.internal.template.ast.WrappedTrackedNodePosition;
import org.eclipse.scout.sdk.s2e.util.ast.AstUtils;

public class FormFieldProposal
extends AbstractTypeProposal {
    public FormFieldProposal(String name, int relevance, String imageId, ICompilationUnit cu, TypeProposalContext context) {
        super(name, relevance, imageId, cu, context);
    }

    @Override
    protected void fillRewrite(AstNodeFactory factory, Type superType) throws CoreException {
        AST ast = factory.getAst();
        Deque parentTypes = AstUtils.getDeclaringTypes((TypeDeclaration)factory.getType());
        TypeDeclaration formType = (TypeDeclaration)parentTypes.getLast();
        TypeDeclaration formFieldType = this.createFormFieldType(superType);
        this.addFormFieldImport(parentTypes);
        SimpleName formFieldSimpleName = ast.newSimpleName(this.getProposalContext().getDefaultName() + this.getProposalContext().getSuffix());
        Type formFieldGetterReturnType = AstUtils.getInnerTypeReturnType((SimpleName)formFieldSimpleName, (TypeDeclaration)this.getProposalContext().getDeclaringType());
        IScoutApi scoutApi = factory.getScoutApi();
        AstInnerTypeGetterBuilder formFieldGetter = (AstInnerTypeGetterBuilder)((AstInnerTypeGetterBuilder)factory.newInnerTypeGetter().withMethodNameToFindInnerType(scoutApi.IForm().getFieldByClassMethodName()).withName(this.getProposalContext().getDefaultName())).withReadOnlySuffix(this.getProposalContext().getSuffix()).withReturnType(formFieldGetterReturnType);
        ITypeBinding iExtensionSuperType = this.getIExtensionSuperType();
        if (iExtensionSuperType != null) {
            ITypeBinding[] typeArguments;
            MethodInvocation getOwner = ast.newMethodInvocation();
            getOwner.setName(ast.newSimpleName(scoutApi.IExtension().getOwnerMethodName()));
            formFieldGetter.withMethodToFindInnerTypeExpression((Expression)getOwner);
            if (AstUtils.isInstanceOf((ITypeBinding)factory.getDeclaringTypeBinding(), (String)scoutApi.IFormExtension().fqn()) && (typeArguments = iExtensionSuperType.getTypeArguments()).length > 0) {
                ITypeBinding extendedForm = typeArguments[0];
                LinkedHashSet<ITypeBinding> composites = new LinkedHashSet<ITypeBinding>();
                this.collectCompositeTypes(extendedForm, composites);
                if (!composites.isEmpty()) {
                    SingleMemberAnnotation extendsAnnotation = ast.newSingleMemberAnnotation();
                    String extendsTypeName = factory.getImportRewrite().addImport(scoutApi.Extends().fqn(), factory.getContext());
                    extendsAnnotation.setTypeName((Name)ast.newSimpleName(extendsTypeName));
                    ITypeBinding first = (ITypeBinding)composites.iterator().next();
                    TypeLiteral typeLiteral = ast.newTypeLiteral();
                    Type type = factory.newTypeReference(Bindings.getFullyQualifiedName((ITypeBinding)first));
                    typeLiteral.setType(type);
                    extendsAnnotation.setValue((Expression)typeLiteral);
                    AstUtils.addAnnotationTo((Annotation)extendsAnnotation, (BodyDeclaration)formFieldType);
                    this.addLinkedPosition(factory.getRewrite().track((ASTNode)type), false, "EXTENDS_TYPE_GROUP");
                    for (ITypeBinding composite : composites) {
                        this.addLinkedPositionProposal("EXTENDS_TYPE_GROUP", composite);
                    }
                }
            }
        }
        ((AstInnerTypeGetterBuilder)formFieldGetter.in(formType)).insert();
        List bodyDeclarations = formFieldType.bodyDeclarations();
        if (!bodyDeclarations.isEmpty()) {
            this.setEndPosition(this.getRewrite().track((ASTNode)bodyDeclarations.getLast()));
        } else {
            this.setEndPosition(new WrappedTrackedNodePosition(this.getRewrite().track((ASTNode)formFieldType.getSuperclassType()), 2, 0));
        }
    }

    protected void collectCompositeTypes(ITypeBinding owner, Collection<ITypeBinding> collector) {
        if (owner == null) {
            return;
        }
        for (ITypeBinding innerType : owner.getDeclaredTypes()) {
            if (!AstUtils.isInstanceOf((ITypeBinding)innerType, (String)this.getFactory().getScoutApi().ICompositeField().fqn())) continue;
            collector.add(innerType);
            this.collectCompositeTypes(innerType, collector);
        }
    }

    protected ITypeBinding getIExtensionSuperType() {
        ITypeBinding[] result = new ITypeBinding[1];
        AstUtils.visitHierarchy((ITypeBinding)this.getFactory().getDeclaringTypeBinding(), type -> {
            if (this.getFactory().getScoutApi().IExtension().fqn().equals(type.getErasure().getQualifiedName())) {
                result[0] = type;
            }
            return result[0] == null;
        });
        return result[0];
    }

    protected TypeDeclaration createFormFieldType(Type superType) {
        return ((AstTypeBuilder)((AstTypeBuilder)((AstTypeBuilder)((AbstractAstBuilder)((AstTypeBuilder)((AstTypeBuilder)((AstTypeBuilder)((AstTypeBuilder)((AstTypeBuilder)((AstTypeBuilder)((AstTypeBuilder)this.getFactory().newType(this.getProposalContext().getDefaultName()).withModifiers(Modifier.ModifierKeyword.PUBLIC_KEYWORD)).withNlsMethod(this.getNlsMethodName())).withOrder(true)).withClassId(true)).withProposalBaseFqn(this.getProposalContext().getProposalInterfaceFqn())).withOrderDefinitionType(this.getFactory().getScoutApi().IFormField().fqn())).withReadOnlyNameSuffix(this.getProposalContext().getSuffix())).withSuperType(superType)).in(this.getProposalContext().getDeclaringType())).atPosition(this.getProposalContext().getInsertPosition())).insert()).get();
    }

    protected String getNlsMethodName() {
        return this.getFactory().getScoutApi().AbstractFormField().getConfiguredLabelMethodName();
    }

    private void addFormFieldImport(Deque<TypeDeclaration> parentTypes) throws CoreException {
        AstNodeFactory factory = this.getFactory();
        String fullyQualifiedName = AstUtils.getFullyQualifiedName(parentTypes, (CompilationUnit)factory.getRoot(), (char)'.');
        ImportDeclaration formFieldTypeImport = factory.getAst().newImportDeclaration();
        formFieldTypeImport.setStatic(false);
        formFieldTypeImport.setOnDemand(false);
        SimpleName simpleImportName = factory.getAst().newSimpleName(this.getProposalContext().getDefaultName() + this.getProposalContext().getSuffix());
        QualifiedName importName = factory.getAst().newQualifiedName(factory.getAst().newName(fullyQualifiedName), simpleImportName);
        formFieldTypeImport.setName((Name)importName);
        WrappedTrackedNodePosition importPos = new WrappedTrackedNodePosition(this.getRewrite().track((ASTNode)simpleImportName), 0, -this.getProposalContext().getSuffix().length());
        this.addLinkedPosition(importPos, false, "TYPE_NAME");
        factory.getImportsRewriteList().insertLast((ASTNode)formFieldTypeImport, null);
    }
}

