/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.scout.sdk.s2e.dataobject;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.scout.sdk.core.java.model.api.IJavaEnvironment;
import org.eclipse.scout.sdk.core.java.model.api.IType;
import org.eclipse.scout.sdk.core.log.SdkLog;
import org.eclipse.scout.sdk.core.s.dataobject.DoContextResolvers;
import org.eclipse.scout.sdk.core.s.java.apidef.IScout22DoApi;
import org.eclipse.scout.sdk.core.s.java.apidef.ScoutApi;
import org.eclipse.scout.sdk.core.util.SdkException;
import org.eclipse.scout.sdk.s2e.environment.model.JavaEnvironmentWithJdt;
import org.eclipse.scout.sdk.s2e.util.JdtUtils;

public class EclipseDoContextResolver
implements DoContextResolvers.IDoContextResolver {
    public Stream<IType> resolveNamespaceCandidates(IJavaEnvironment environment) {
        if (environment == null) {
            return Stream.empty();
        }
        IJavaProject project = ((JavaEnvironmentWithJdt)environment.unwrap()).javaProject();
        Predicate<org.eclipse.jdt.core.IType> filter = new JdtUtils.PublicPrimaryNonAbstractSourceTypeFilter().and(EclipseDoContextResolver::isInteresting);
        return ScoutApi.allKnown().map(a -> a.api(IScout22DoApi.class)).filter(Optional::isPresent).flatMap(Optional::stream).map(a -> a.INamespace().fqn()).distinct().flatMap(iNamespace -> JdtUtils.findTypesInStrictHierarchy(project, iNamespace, null, filter).stream()).map(org.eclipse.jdt.core.IType::getFullyQualifiedName).map(arg_0 -> ((IJavaEnvironment)environment).findType(arg_0)).filter(Optional::isPresent).flatMap(Optional::stream);
    }

    protected static boolean isInteresting(org.eclipse.jdt.core.IType t) {
        try {
            return !t.isInterface() && !t.isAnnotation();
        }
        catch (JavaModelException e) {
            SdkLog.warning((CharSequence)"Attempt to access flags of type '{}' failed. Type will be skipped.", (Object[])new Object[]{t.getFullyQualifiedName(), e});
            return false;
        }
    }

    public Stream<IType> resolvePrimaryTypesInPackageOf(IType namespace) {
        if (namespace == null) {
            return Stream.empty();
        }
        IJavaEnvironment env = namespace.javaEnvironment();
        IJavaProject project = ((JavaEnvironmentWithJdt)namespace.javaEnvironment().unwrap()).javaProject();
        try {
            org.eclipse.jdt.core.IType type = project.findType(namespace.name());
            if (!JdtUtils.exists((IJavaElement)type)) {
                return Stream.empty();
            }
            return Stream.of(type.getPackageFragment().getCompilationUnits()).map(ITypeRoot::findPrimaryType).filter(Objects::nonNull).map(org.eclipse.jdt.core.IType::getFullyQualifiedName).map(arg_0 -> ((IJavaEnvironment)env).findType(arg_0)).filter(Optional::isPresent).flatMap(Optional::stream);
        }
        catch (JavaModelException e) {
            throw new SdkException((Throwable)e);
        }
    }
}

