/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.common.tools.api.contentassist;

import org.eclipse.sirius.common.tools.api.contentassist.ContentProposal;
import org.eclipse.sirius.common.tools.api.contentassist.ContentProposalWithReplacement;

public final class ContentProposalBuilder {
    private ContentProposalBuilder() {
    }

    public static ProposalBuilder proposal(String proposal, String display, String information) {
        return ContentProposalBuilder.proposal(proposal, display, information, proposal.length());
    }

    public static ProposalBuilder proposal(String proposal, String display, String information, int cursor) {
        return new ProposalBuilder(proposal, display, information, cursor);
    }

    public static final class ProposalBuilder {
        private String proposal;
        private String display;
        private String information;
        private int cursor;
        private boolean shouldBuildAProposalWithReplacement;
        private int replacementOffset;
        private int replacementLength;
        private Object proposalImage;
        private ContentProposalWithReplacement.ImageKind kind;

        private ProposalBuilder(String proposal, String display, String information, int cursor) {
            this.proposal = proposal;
            this.display = display;
            this.information = information;
            this.cursor = cursor;
        }

        public ProposalBuilder withReplacement(int offset, int length) {
            this.shouldBuildAProposalWithReplacement = true;
            this.replacementOffset = offset;
            this.replacementLength = length;
            return this;
        }

        public ProposalBuilder withImage(Object image, ContentProposalWithReplacement.ImageKind imageKind) {
            this.shouldBuildAProposalWithReplacement = true;
            this.proposalImage = image;
            this.kind = imageKind;
            return this;
        }

        public ContentProposal build() {
            if (this.shouldBuildAProposalWithReplacement) {
                return new ContentProposalWithReplacement(this.proposal, this.display, this.information, this.cursor, this.replacementOffset, this.replacementLength, this.proposalImage, this.kind);
            }
            return new ContentProposal(this.proposal, this.display, this.information, this.cursor);
        }
    }
}

