/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.model.business.internal.query;

import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DRepresentationDescriptor;
import org.eclipse.sirius.viewpoint.DView;

public final class DViewQuery {
    private final DView dView;

    public DViewQuery(DView dView) {
        this.dView = Objects.requireNonNull(dView);
    }

    public List<DRepresentation> getLoadedRepresentations() {
        return this.dView.getOwnedRepresentationDescriptors().stream().filter(DRepresentationDescriptor::isLoadedRepresentation).map(DRepresentationDescriptor::getRepresentation).toList();
    }

    public List<DRepresentationDescriptor> getLoadedRepresentationsDescriptors() {
        return this.dView.getOwnedRepresentationDescriptors().stream().filter(DRepresentationDescriptor::isLoadedRepresentation).toList();
    }

    public Iterator<EObject> getAllContentInRepresentations(Predicate<? super EObject> predicate) {
        return this.getLoadedRepresentations().stream().flatMap(representation -> {
            Spliterator allContentsSpliterator = Spliterators.spliteratorUnknownSize(representation.eAllContents(), 1041);
            return StreamSupport.stream(allContentsSpliterator, false).filter(predicate);
        }).iterator();
    }
}

