/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tree.ui.business.internal.refresh;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.business.api.dialect.command.RefreshRepresentationsCommand;
import org.eclipse.sirius.business.api.query.EObjectQuery;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.tools.api.SiriusPlugin;
import org.eclipse.sirius.tree.DTreeItem;
import org.eclipse.sirius.tree.business.api.command.DTreeItemLocalRefreshCommand;
import org.eclipse.sirius.tree.business.internal.dialect.common.tree.TreeRefreshContext;
import org.eclipse.sirius.tree.business.internal.dialect.common.viewpoint.GlobalContext;
import org.eclipse.sirius.tree.ui.provider.Messages;
import org.eclipse.sirius.tree.ui.tools.internal.editor.DTreeEditor;
import org.eclipse.sirius.ui.business.api.action.RefreshActionListenerRegistry;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.swt.widgets.Shell;

public final class TreeRefresherHelper {
    private TreeRefresherHelper() {
    }

    public static void refreshEditor(DTreeEditor treeEditor, IStructuredSelection structuredSelection, IProgressMonitor theMonitor) {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)theMonitor, (int)1);
        IRunnableWithProgress op = TreeRefresherHelper.getRunnable(treeEditor, structuredSelection);
        if (op != null) {
            TreeRefresherHelper.run(op, treeEditor);
        }
        subMonitor.split(1);
    }

    private static void run(IRunnableWithProgress op, DTreeEditor treeEditor) {
        Shell activeShell = treeEditor.getSite().getShell();
        ProgressMonitorDialog monitorDialog = new ProgressMonitorDialog(activeShell);
        try {
            try {
                treeEditor.enablePropertiesUpdate(false);
                monitorDialog.run(true, false, op);
            }
            catch (InvocationTargetException e) {
                MessageDialog.openError((Shell)activeShell, (String)Messages.EditorRefresh_error, (String)e.getTargetException().getMessage());
                SiriusPlugin.getDefault().error(Messages.EditorRefresh_treeRefreshError, (Throwable)e);
                treeEditor.enablePropertiesUpdate(true);
            }
            catch (InterruptedException e) {
                MessageDialog.openInformation((Shell)activeShell, (String)Messages.EditorRefresh_refreshCancelled, (String)e.getMessage());
                treeEditor.enablePropertiesUpdate(true);
            }
        }
        finally {
            treeEditor.enablePropertiesUpdate(true);
        }
    }

    private static IRunnableWithProgress getRunnable(DTreeEditor treeEditor, IStructuredSelection structuredSelection) {
        IRunnableWithProgress op = null;
        LinkedList<Object> minimizedSelection = new LinkedList<Object>(Arrays.asList(structuredSelection.toArray()));
        if (minimizedSelection.isEmpty()) {
            op = monitor -> {
                TransactionalEditingDomain domain = treeEditor.getEditingDomain();
                domain.getCommandStack().execute((Command)new RefreshRepresentationsCommand(domain, monitor, new DRepresentation[]{treeEditor.getTreeModel()}));
            };
            RefreshActionListenerRegistry.INSTANCE.notifyRepresentationIsAboutToBeRefreshed((DRepresentation)treeEditor.getTreeModel());
        } else {
            Collection dTreeItems = minimizedSelection.stream().filter(DTreeItem.class::isInstance).map(DTreeItem.class::cast).collect(Collectors.toList());
            if (!dTreeItems.isEmpty()) {
                op = monitor -> {
                    Session session = new EObjectQuery((EObject)treeEditor.getRepresentation()).getSession();
                    if (session != null) {
                        TreeRefreshContext globalContext = new TreeRefreshContext(session.getModelAccessor(), session.getInterpreter(), session.getSemanticResources(), session.getTransactionalEditingDomain());
                        TransactionalEditingDomain domain = treeEditor.getEditingDomain();
                        DTreeItemLocalRefreshCommand localRefreshCmd = new DTreeItemLocalRefreshCommand(domain, (GlobalContext)globalContext, dTreeItems, false);
                        domain.getCommandStack().execute((Command)localRefreshCmd);
                    }
                };
            }
        }
        return op;
    }
}

