/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.util.Collection;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.services.ILineNumbers;

public class LineNumbersProxy
implements ILineNumbers {
    private final IChannel channel;

    public LineNumbersProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "LineNumbers";
    }

    @Override
    public IToken mapToSource(String context_id, Number start_address, Number end_address, final ILineNumbers.DoneMapToSource done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"mapToSource", (Object[])new Object[]{context_id, start_address, end_address}){

            @Override
            public void done(Exception error, Object[] args) {
                ILineNumbers.CodeArea[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = LineNumbersProxy.this.toTextAreaArray(args[1]);
                }
                done.doneMapToSource(this.token, error, arr);
            }
        }.token;
    }

    @Override
    public IToken mapToMemory(String context_id, String file, int line, int column, final ILineNumbers.DoneMapToMemory done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"mapToMemory", (Object[])new Object[]{context_id, file, Integer.valueOf((int)line), Integer.valueOf((int)column)}){

            @Override
            public void done(Exception error, Object[] args) {
                ILineNumbers.CodeArea[] arr = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    arr = LineNumbersProxy.this.toTextAreaArray(args[1]);
                }
                done.doneMapToMemory(this.token, error, arr);
            }
        }.token;
    }

    private ILineNumbers.CodeArea[] toTextAreaArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        int n = 0;
        ILineNumbers.CodeArea[] arr = new ILineNumbers.CodeArea[c.size()];
        for (Map area : c) {
            arr[n] = new ILineNumbers.CodeArea(area, n > 0 ? arr[n - 1] : null);
            ++n;
        }
        return arr;
    }
}

