/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.internal.debug.ui.model.TCFNode;
import org.eclipse.tcf.internal.debug.ui.model.TCFNodeExecContext;
import org.eclipse.tcf.util.TCFDataCache;
import org.eclipse.tcf.util.TCFTask;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.CompoundContributionItem;
import org.eclipse.ui.menus.CommandContributionItem;
import org.eclipse.ui.menus.CommandContributionItemParameter;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;

public class ResetMenu
extends CompoundContributionItem
implements IWorkbenchContribution {
    private static final IContributionItem[] EMPTY_MENU = new IContributionItem[0];
    private IServiceLocator serviceLocator;

    public void initialize(IServiceLocator serviceLocator) {
        this.serviceLocator = serviceLocator;
    }

    static IStructuredSelection getDebugContext() {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = DebugUITools.getDebugContextManager().getContextService(window).getActiveContext();
        if (selection != null && selection instanceof IStructuredSelection) {
            return (IStructuredSelection)selection;
        }
        return StructuredSelection.EMPTY;
    }

    private IContributionItem makeContributionItem(TCFNodeExecContext exec, Map<String, Object> capability) {
        String type = capability.get("Type").toString();
        String desc = capability.get("Description").toString();
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("org.eclipse.tcf.debug.ui.commands.reset.param.type", type);
        CommandContributionItemParameter itemParameter = new CommandContributionItemParameter(this.serviceLocator, null, null, 0);
        itemParameter.commandId = "org.eclipse.tcf.debug.ui.commands.reset";
        itemParameter.parameters = params;
        itemParameter.label = desc;
        return new CommandContributionItem(itemParameter);
    }

    protected IContributionItem[] getContributionItems() {
        IStructuredSelection sselection = ResetMenu.getDebugContext();
        Object obj = sselection.getFirstElement();
        IContributionItem[] items = EMPTY_MENU;
        if (obj instanceof TCFNode) {
            TCFNode node = (TCFNode)obj;
            while (node != null) {
                if (node instanceof TCFNodeExecContext) {
                    final TCFNodeExecContext exec = (TCFNodeExecContext)node;
                    Collection capabilities = (Collection)new TCFTask<Collection<Map<String, Object>>>(exec.getChannel()){

                        public void run() {
                            TCFDataCache<Collection<Map<String, Object>>> cache = exec.getResetCapabilities();
                            if (!cache.validate((Runnable)((Object)this))) {
                                return;
                            }
                            this.done((Collection)cache.getData());
                        }
                    }.getE();
                    items = new IContributionItem[capabilities.size()];
                    int i = 0;
                    for (Map c : capabilities) {
                        items[i++] = this.makeContributionItem(exec, c);
                    }
                    break;
                }
                node = node.getParent();
            }
        }
        return items;
    }
}

