/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.model.factory;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.factory.IFactory;
import org.eclipse.tcf.te.runtime.model.interfaces.factory.IFactoryDelegate;
import org.eclipse.tcf.te.runtime.model.interfaces.factory.IFactoryDelegate2;
import org.eclipse.tcf.te.runtime.model.internal.factory.FactoryDelegateManager;

public final class Factory
extends PlatformObject
implements IFactory {
    private final FactoryDelegateManager manager = new FactoryDelegateManager();

    public static Factory getInstance() {
        return LazyInstance.instance;
    }

    Factory() {
    }

    @Override
    public <V extends IModelNode> V newInstance(Class<V> nodeInterface) {
        Assert.isNotNull(nodeInterface);
        IFactoryDelegate delegate = this.manager.getFactoryDelegate(nodeInterface);
        return delegate != null ? (V)delegate.newInstance(nodeInterface) : null;
    }

    @Override
    public <V extends IModelNode> V newInstance(Class<V> nodeInterface, Object[] args) {
        Assert.isNotNull(nodeInterface);
        IFactoryDelegate delegate = this.manager.getFactoryDelegate(nodeInterface);
        return delegate instanceof IFactoryDelegate2 ? (V)((IFactoryDelegate2)delegate).newInstance(nodeInterface, args) : null;
    }

    private static class LazyInstance {
        public static Factory instance = new Factory();

        private LazyInstance() {
        }
    }
}

