/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.swt.widgets;

import java.util.Arrays;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleControlAdapter;
import org.eclipse.swt.accessibility.AccessibleControlEvent;
import org.eclipse.swt.accessibility.AccessibleControlListener;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.accessibility.AccessibleTextAdapter;
import org.eclipse.swt.accessibility.AccessibleTextEvent;
import org.eclipse.swt.accessibility.AccessibleTextListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SWTEventListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TypedListener;

public final class ImageCombo
extends Composite {
    Label image;
    Text text;
    Table table;
    int visibleItemCount;
    Shell popup;
    Button arrow;
    boolean hasFocus;
    Listener listener;
    Listener filter;
    Color foreground;
    Color background;
    Font font;

    public ImageCombo(Composite parent, int style) {
        style = ImageCombo.checkStyle(style);
        super(parent, style);
        this.visibleItemCount = 5;
        int textStyle = 4;
        if ((style & 8) != 0) {
            textStyle |= 8;
        }
        if ((style & 0x800000) != 0) {
            textStyle |= 0x800000;
        }
        this.image = new Label((Composite)this, 0);
        this.text = new Text((Composite)this, textStyle);
        int arrowStyle = 1028;
        if ((style & 0x800000) != 0) {
            arrowStyle |= 0x800000;
        }
        this.arrow = new Button((Composite)this, arrowStyle);
        this.listener = new Listener(){

            public void handleEvent(Event event) {
                if (ImageCombo.this.popup == event.widget) {
                    ImageCombo.this.popupEvent(event);
                    return;
                }
                if (ImageCombo.this.text == event.widget) {
                    ImageCombo.this.textEvent(event);
                    return;
                }
                if (ImageCombo.this.table == event.widget) {
                    ImageCombo.this.listEvent(event);
                    return;
                }
                if (ImageCombo.this.arrow == event.widget) {
                    ImageCombo.this.arrowEvent(event);
                    return;
                }
                if (ImageCombo.this == event.widget) {
                    ImageCombo.this.comboEvent(event);
                    return;
                }
                if (ImageCombo.this.getShell() == event.widget) {
                    ImageCombo.this.handleFocus(16);
                }
            }
        };
        this.filter = new Listener(){

            public void handleEvent(Event event) {
                Shell shell = ((Control)event.widget).getShell();
                if (shell == ImageCombo.this.getShell()) {
                    ImageCombo.this.handleFocus(16);
                }
            }
        };
        int[] comboEvents = new int[]{12, 10, 11};
        int i = 0;
        while (i < comboEvents.length) {
            this.addListener(comboEvents[i], this.listener);
            ++i;
        }
        int[] textEvents = new int[]{1, 2, 24, 3, 4, 31, 15};
        int i2 = 0;
        while (i2 < textEvents.length) {
            this.text.addListener(textEvents[i2], this.listener);
            ++i2;
        }
        int[] arrowEvents = new int[]{13, 15};
        int i3 = 0;
        while (i3 < arrowEvents.length) {
            this.arrow.addListener(arrowEvents[i3], this.listener);
            ++i3;
        }
        this.createPopup(-1);
        this.initAccessible();
    }

    static int checkStyle(int style) {
        int mask = 0x6800808;
        return style & mask;
    }

    public void add(String string, Image image) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        TableItem newItem = new TableItem(this.table, 0);
        newItem.setText(string);
        if (image != null) {
            newItem.setImage(image);
        }
    }

    public void add(String string, Image image, int index) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        TableItem newItem = new TableItem(this.table, 0, index);
        if (image != null) {
            newItem.setImage(image);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(24, (Listener)typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        TypedListener typedListener = new TypedListener((SWTEventListener)listener);
        this.addListener(13, (Listener)typedListener);
        this.addListener(14, (Listener)typedListener);
    }

    void arrowEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 13: {
                this.dropDown(!this.isDropped());
            }
        }
    }

    public void clearSelection() {
        this.checkWidget();
        this.text.clearSelection();
        this.table.deselectAll();
    }

    void comboEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.popup != null && !this.popup.isDisposed()) {
                    this.table.removeListener(12, this.listener);
                    this.popup.dispose();
                }
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                this.popup = null;
                this.text = null;
                this.table = null;
                this.arrow = null;
                break;
            }
            case 10: {
                this.dropDown(false);
                break;
            }
            case 11: {
                this.internalLayout(false);
            }
        }
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int width = 0;
        int height = 0;
        String[] items = this.getStringsFromTable();
        int textWidth = 0;
        GC gc = new GC((Drawable)this.text);
        int spacer = gc.stringExtent((String)" ").x;
        int i = 0;
        while (i < items.length) {
            textWidth = Math.max(gc.stringExtent((String)items[i]).x, textWidth);
            ++i;
        }
        gc.dispose();
        Point textSize = this.text.computeSize(-1, -1, changed);
        Point arrowSize = this.arrow.computeSize(-1, -1, changed);
        Point listSize = this.table.computeSize(wHint, -1, changed);
        int borderWidth = this.getBorderWidth();
        height = Math.max(hHint, Math.max(textSize.y, arrowSize.y) + 2 * borderWidth);
        width = Math.max(wHint, Math.max(textWidth + 2 * spacer + arrowSize.x + 2 * borderWidth, listSize.x));
        return new Point(width, height);
    }

    void createPopup(int selectionIndex) {
        this.popup = new Shell(this.getShell(), 16392);
        int style = this.getStyle();
        int listStyle = 516;
        if ((style & 0x800000) != 0) {
            listStyle |= 0x800000;
        }
        if ((style & 0x4000000) != 0) {
            listStyle |= 0x4000000;
        }
        if ((style & 0x2000000) != 0) {
            listStyle |= 0x2000000;
        }
        this.table = new Table((Composite)this.popup, listStyle);
        if (this.font != null) {
            this.table.setFont(this.font);
        }
        if (this.foreground != null) {
            this.table.setForeground(this.foreground);
        }
        if (this.background != null) {
            this.table.setBackground(this.background);
        }
        int[] popupEvents = new int[]{21, 9, 27};
        int i = 0;
        while (i < popupEvents.length) {
            this.popup.addListener(popupEvents[i], this.listener);
            ++i;
        }
        int[] listEvents = new int[]{4, 13, 31, 1, 2, 15, 12};
        int i2 = 0;
        while (i2 < listEvents.length) {
            this.table.addListener(listEvents[i2], this.listener);
            ++i2;
        }
        if (selectionIndex != -1) {
            this.table.setSelection(selectionIndex);
        }
    }

    public void deselect(int index) {
        this.checkWidget();
        this.table.deselect(index);
    }

    public void deselectAll() {
        this.checkWidget();
        this.table.deselectAll();
    }

    void dropDown(boolean drop) {
        if (drop == this.isDropped()) {
            return;
        }
        if (!drop) {
            this.popup.setVisible(false);
            if (!this.isDisposed()) {
                this.arrow.isFocusControl();
            }
            return;
        }
        if (this.getShell() != this.popup.getParent()) {
            int selectionIndex = this.table.getSelectionIndex();
            this.table.removeListener(12, this.listener);
            this.popup.dispose();
            this.popup = null;
            this.table = null;
            this.createPopup(selectionIndex);
        }
        Point size = this.getSize();
        int itemCount = this.table.getItemCount();
        itemCount = itemCount == 0 ? this.visibleItemCount : Math.min(this.visibleItemCount, itemCount);
        int itemHeight = this.table.getItemHeight() * itemCount;
        Point listSize = this.table.computeSize(-1, itemHeight, false);
        this.table.setBounds(1, 1, Math.max(size.x - 2, listSize.x), listSize.y);
        int index = this.table.getSelectionIndex();
        if (index != -1) {
            this.table.setTopIndex(index);
        }
        Display display = this.getDisplay();
        Rectangle listRect = this.table.getBounds();
        Rectangle parentRect = display.map((Control)this.getParent(), null, this.getBounds());
        Point comboSize = this.getSize();
        Rectangle displayRect = this.getMonitor().getClientArea();
        int width = Math.max(comboSize.x, listRect.width + 2);
        int height = listRect.height + 2;
        int x = parentRect.x;
        int y = parentRect.y + comboSize.y;
        if (y + height > displayRect.y + displayRect.height) {
            y = parentRect.y - height;
        }
        this.popup.setBounds(x, y, width, height);
        this.popup.setVisible(true);
        this.table.setFocus();
    }

    Label getAssociatedLabel() {
        Control[] siblings = this.getParent().getChildren();
        int i = 0;
        while (i < siblings.length) {
            if (siblings[i] == this && i > 0 && siblings[i - 1] instanceof Label) {
                return (Label)siblings[i - 1];
            }
            ++i;
        }
        return null;
    }

    public Control[] getChildren() {
        this.checkWidget();
        return new Control[0];
    }

    public boolean getEditable() {
        this.checkWidget();
        return this.text.getEditable();
    }

    public TableItem getItem(int index) {
        this.checkWidget();
        return this.table.getItem(index);
    }

    public int getItemCount() {
        this.checkWidget();
        return this.table.getItemCount();
    }

    public int getItemHeight() {
        this.checkWidget();
        return this.table.getItemHeight();
    }

    public TableItem[] getItems() {
        this.checkWidget();
        return this.table.getItems();
    }

    char getMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return '\u0000';
            }
            if (string.charAt(index) != '&') {
                return string.charAt(index);
            }
            if (++index >= length) break;
        }
        return '\u0000';
    }

    String[] getStringsFromTable() {
        String[] items = new String[this.table.getItems().length];
        int i = 0;
        int n = items.length;
        while (i < n) {
            items[i] = this.table.getItem(i).getText();
            ++i;
        }
        return items;
    }

    public Point getSelection() {
        this.checkWidget();
        return this.text.getSelection();
    }

    public int getSelectionIndex() {
        this.checkWidget();
        return this.table.getSelectionIndex();
    }

    public int getStyle() {
        int style = super.getStyle();
        style &= 0xFFFFFFF7;
        if (!this.getEditable()) {
            style |= 8;
        }
        return style;
    }

    public String getText() {
        this.checkWidget();
        return this.text.getText();
    }

    public int getTextHeight() {
        this.checkWidget();
        return this.text.getLineHeight();
    }

    public int getTextLimit() {
        this.checkWidget();
        return this.text.getTextLimit();
    }

    public int getVisibleItemCount() {
        this.checkWidget();
        return this.visibleItemCount;
    }

    void handleFocus(int type) {
        if (this.isDisposed()) {
            return;
        }
        switch (type) {
            case 15: {
                if (this.hasFocus) {
                    return;
                }
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                this.hasFocus = true;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                shell.addListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                display.addFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(15, e);
                break;
            }
            case 16: {
                if (!this.hasFocus) {
                    return;
                }
                Control focusControl = this.getDisplay().getFocusControl();
                if (focusControl == this.arrow || focusControl == this.table || focusControl == this.text) {
                    return;
                }
                this.hasFocus = false;
                Shell shell = this.getShell();
                shell.removeListener(27, this.listener);
                Display display = this.getDisplay();
                display.removeFilter(15, this.filter);
                Event e = new Event();
                this.notifyListeners(16, e);
            }
        }
    }

    public int indexOf(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        return Arrays.asList(this.getStringsFromTable()).indexOf(string);
    }

    void initAccessible() {
        AccessibleAdapter accessibleAdapter = new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                String name = null;
                Label label = ImageCombo.this.getAssociatedLabel();
                if (label != null) {
                    name = ImageCombo.this.stripMnemonic(label.getText());
                }
                e.result = name;
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                char mnemonic;
                String text;
                String shortcut = null;
                Label label = ImageCombo.this.getAssociatedLabel();
                if (label != null && (text = label.getText()) != null && (mnemonic = ImageCombo.this.getMnemonic(text)) != '\u0000') {
                    shortcut = "Alt+" + mnemonic;
                }
                e.result = shortcut;
            }

            public void getHelp(AccessibleEvent e) {
                e.result = ImageCombo.this.getToolTipText();
            }
        };
        this.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.text.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.table.getAccessible().addAccessibleListener((AccessibleListener)accessibleAdapter);
        this.arrow.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = ImageCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }

            public void getKeyboardShortcut(AccessibleEvent e) {
                e.result = "Alt+Down Arrow";
            }

            public void getHelp(AccessibleEvent e) {
                e.result = ImageCombo.this.getToolTipText();
            }
        });
        this.getAccessible().addAccessibleTextListener((AccessibleTextListener)new AccessibleTextAdapter(){

            public void getCaretOffset(AccessibleTextEvent e) {
                e.offset = ImageCombo.this.text.getCaretPosition();
            }
        });
        this.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getChildAtPoint(AccessibleControlEvent e) {
                Point testPoint = ImageCombo.this.toControl(e.x, e.y);
                if (ImageCombo.this.getBounds().contains(testPoint)) {
                    e.childID = -1;
                }
            }

            public void getLocation(AccessibleControlEvent e) {
                Rectangle location = ImageCombo.this.getBounds();
                Point pt = ImageCombo.this.toDisplay(location.x, location.y);
                e.x = pt.x;
                e.y = pt.y;
                e.width = location.width;
                e.height = location.height;
            }

            public void getChildCount(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getRole(AccessibleControlEvent e) {
                e.detail = 46;
            }

            public void getState(AccessibleControlEvent e) {
                e.detail = 0;
            }

            public void getValue(AccessibleControlEvent e) {
                e.result = ImageCombo.this.getText();
            }
        });
        this.text.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getRole(AccessibleControlEvent e) {
                e.detail = ImageCombo.this.getEditable() ? 42 : 41;
            }
        });
        this.arrow.getAccessible().addAccessibleControlListener((AccessibleControlListener)new AccessibleControlAdapter(){

            public void getDefaultAction(AccessibleControlEvent e) {
                e.result = ImageCombo.this.isDropped() ? SWT.getMessage((String)"SWT_Close") : SWT.getMessage((String)"SWT_Open");
            }
        });
    }

    boolean isDropped() {
        return this.popup.getVisible();
    }

    public boolean isFocusControl() {
        this.checkWidget();
        if (this.text.isFocusControl() || this.arrow.isFocusControl() || this.table.isFocusControl() || this.popup.isFocusControl()) {
            return true;
        }
        return super.isFocusControl();
    }

    void internalLayout(boolean changed) {
        if (this.isDropped()) {
            this.dropDown(false);
        }
        Rectangle rect = this.getClientArea();
        int width = rect.width;
        int height = rect.height;
        Point arrowSize = this.arrow.computeSize(-1, height, changed);
        this.image.setBounds(0, 0, 20, height);
        this.text.setBounds(20, 0, width - 20 - arrowSize.x, height);
        this.arrow.setBounds(width - arrowSize.x, 0, arrowSize.x, arrowSize.y);
    }

    void listEvent(Event event) {
        switch (event.type) {
            case 12: {
                if (this.getShell() == this.popup.getParent()) break;
                int selectionIndex = this.table.getSelectionIndex();
                this.popup = null;
                this.table = null;
                this.createPopup(selectionIndex);
                break;
            }
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                this.dropDown(false);
                break;
            }
            case 13: {
                int index = this.table.getSelectionIndex();
                if (index == -1) {
                    return;
                }
                this.image.setImage(this.table.getItem(index).getImage());
                this.text.setText(this.table.getItem(index).getText());
                if (this.getEditable()) {
                    this.text.selectAll();
                }
                this.table.setSelection(index);
                Event e = new Event();
                e.time = event.time;
                e.stateMask = event.stateMask;
                e.doit = event.doit;
                this.notifyListeners(13, e);
                event.doit = e.doit;
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 2: 
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\u001b') {
                    this.dropDown(false);
                }
                if ((event.stateMask & 0x10000) != 0 && (event.keyCode == 0x1000001 || event.keyCode == 0x1000002)) {
                    this.dropDown(false);
                }
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
            }
        }
    }

    void popupEvent(Event event) {
        switch (event.type) {
            case 9: {
                Rectangle listRect = this.table.getBounds();
                Color black = this.getDisplay().getSystemColor(2);
                event.gc.setForeground(black);
                event.gc.drawRectangle(0, 0, listRect.width + 1, listRect.height + 1);
                break;
            }
            case 21: {
                event.doit = false;
                this.dropDown(false);
                break;
            }
            case 27: {
                this.dropDown(false);
            }
        }
    }

    public void redraw() {
        super.redraw();
        this.image.redraw();
        this.text.redraw();
        this.arrow.redraw();
        if (this.popup.isVisible()) {
            this.table.redraw();
        }
    }

    public void redraw(int x, int y, int width, int height, boolean all) {
        super.redraw(x, y, width, height, true);
    }

    public void remove(int index) {
        this.checkWidget();
        this.table.remove(index);
    }

    public void remove(int start, int end) {
        this.checkWidget();
        this.table.remove(start, end);
    }

    public void remove(String string) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int index = -1;
        int i = 0;
        int n = this.table.getItemCount();
        while (i < n) {
            if (this.table.getItem(i).getText().equals(string)) {
                index = i;
                break;
            }
            ++i;
        }
        this.remove(index);
    }

    public void removeAll() {
        this.checkWidget();
        this.image.setImage(null);
        this.text.setText("");
        this.table.removeAll();
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(24, (SWTEventListener)listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            SWT.error((int)4);
        }
        this.removeListener(13, (SWTEventListener)listener);
        this.removeListener(14, (SWTEventListener)listener);
    }

    public void select(int index) {
        this.checkWidget();
        if (index == -1) {
            this.table.deselectAll();
            this.image.setImage(null);
            this.text.setText("");
            return;
        }
        if (index >= 0 && index < this.table.getItemCount() && index != this.getSelectionIndex()) {
            this.image.setImage(this.table.getItem(index).getImage());
            this.text.setText(this.table.getItem(index).getText());
            if (this.getEditable()) {
                this.text.selectAll();
            }
            this.table.select(index);
            this.table.showSelection();
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        this.background = color;
        if (this.image != null) {
            this.image.setBackground(color);
        }
        if (this.text != null) {
            this.text.setBackground(color);
        }
        if (this.table != null) {
            this.table.setBackground(color);
        }
        if (this.arrow != null) {
            this.arrow.setBackground(color);
        }
    }

    public void setEditable(boolean editable) {
        this.checkWidget();
        this.text.setEditable(editable);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
        if (this.image != null) {
            this.image.setEnabled(enabled);
        }
        if (this.text != null) {
            this.text.setEnabled(enabled);
        }
        if (this.arrow != null) {
            this.arrow.setEnabled(enabled);
        }
    }

    public boolean setFocus() {
        this.checkWidget();
        return this.text.setFocus();
    }

    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.text.setFont(font);
        this.table.setFont(font);
        this.internalLayout(true);
    }

    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
        if (this.image != null) {
            this.image.setForeground(color);
        }
        if (this.text != null) {
            this.text.setForeground(color);
        }
        if (this.table != null) {
            this.table.setForeground(color);
        }
        if (this.arrow != null) {
            this.arrow.setForeground(color);
        }
    }

    public void setItem(int index, String string, Image image) {
        this.checkWidget();
        this.remove(index);
        this.add(string, image, index);
    }

    public void setItems(String[] items) {
        this.checkWidget();
        this.table.removeAll();
        int i = 0;
        int n = items.length;
        while (i < n) {
            this.add(items[i], null);
            ++i;
        }
        if (!this.getEditable()) {
            this.image.setImage(null);
            this.text.setText("");
        }
    }

    public void setLayout(Layout layout) {
        this.checkWidget();
    }

    public void setSelection(Point selection) {
        this.checkWidget();
        if (selection == null) {
            SWT.error((int)4);
        }
        this.text.setSelection(selection.x, selection.y);
    }

    public void setText(String string, Image icon) {
        this.checkWidget();
        if (string == null) {
            SWT.error((int)4);
        }
        int index = -1;
        int i = 0;
        int n = this.table.getItemCount();
        while (i < n) {
            if (this.table.getItem(i).getText().equals(string)) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            this.table.deselectAll();
            this.image.setImage(icon);
            this.text.setText(string);
            return;
        }
        this.image.setImage(icon);
        this.text.setText(string);
        if (this.getEditable()) {
            this.text.selectAll();
        }
        this.table.setSelection(index);
        this.table.showSelection();
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        this.text.setTextLimit(limit);
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        super.setToolTipText(string);
        this.arrow.setToolTipText(string);
        this.image.setToolTipText(string);
        this.text.setToolTipText(string);
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (!visible) {
            this.popup.setVisible(false);
        }
    }

    public void setVisibleItemCount(int count) {
        this.checkWidget();
        if (count < 0) {
            return;
        }
        this.visibleItemCount = count;
    }

    String stripMnemonic(String string) {
        int index = 0;
        int length = string.length();
        while (true) {
            if (index < length && string.charAt(index) != '&') {
                ++index;
                continue;
            }
            if (++index >= length) {
                return string;
            }
            if (string.charAt(index) != '&') {
                return String.valueOf(string.substring(0, index - 1)) + string.substring(index, length);
            }
            if (++index >= length) break;
        }
        return string;
    }

    void textEvent(Event event) {
        switch (event.type) {
            case 15: {
                this.handleFocus(15);
                break;
            }
            case 1: {
                Event e;
                if (event.character == '\r') {
                    this.dropDown(false);
                    e = new Event();
                    e.time = event.time;
                    e.stateMask = event.stateMask;
                    this.notifyListeners(14, e);
                }
                if (this.isDisposed()) break;
                if (event.keyCode == 0x1000001 || event.keyCode == 0x1000002) {
                    event.doit = false;
                    if ((event.stateMask & 0x10000) != 0) {
                        boolean dropped = this.isDropped();
                        if (this.getEditable()) {
                            this.text.selectAll();
                        }
                        if (!dropped) {
                            this.setFocus();
                        }
                        this.dropDown(!dropped);
                        break;
                    }
                    int oldIndex = this.getSelectionIndex();
                    if (event.keyCode == 0x1000001) {
                        this.select(Math.max(oldIndex - 1, 0));
                    } else {
                        this.select(Math.min(oldIndex + 1, this.getItemCount() - 1));
                    }
                    if (oldIndex != this.getSelectionIndex()) {
                        Event e2 = new Event();
                        e2.time = event.time;
                        e2.stateMask = event.stateMask;
                        this.notifyListeners(13, e2);
                    }
                    if (this.isDisposed()) break;
                }
                e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(1, e);
                break;
            }
            case 2: {
                Event e = new Event();
                e.time = event.time;
                e.character = event.character;
                e.keyCode = event.keyCode;
                e.stateMask = event.stateMask;
                this.notifyListeners(2, e);
                break;
            }
            case 24: {
                this.table.deselectAll();
                Event e = new Event();
                e.time = event.time;
                this.notifyListeners(24, e);
                break;
            }
            case 3: {
                if (event.button != 1) {
                    return;
                }
                if (this.getEditable()) {
                    return;
                }
                boolean dropped = this.isDropped();
                this.text.selectAll();
                if (!dropped) {
                    this.setFocus();
                }
                this.dropDown(!dropped);
                break;
            }
            case 4: {
                if (event.button != 1) {
                    return;
                }
                if (this.getEditable()) {
                    return;
                }
                this.text.selectAll();
                break;
            }
            case 31: {
                switch (event.detail) {
                    case 4: 
                    case 32: 
                    case 64: {
                        event.doit = false;
                    }
                }
                Event e = new Event();
                e.time = event.time;
                e.detail = event.detail;
                e.doit = event.doit;
                e.character = event.character;
                e.keyCode = event.keyCode;
                this.notifyListeners(31, e);
                event.doit = e.doit;
                event.detail = e.detail;
            }
        }
    }
}

