/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.ui.views.handler;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.tcf.te.ui.dialogs.FilteredCheckedListDialog;
import org.eclipse.tcf.te.ui.views.handler.UpdateActiveFiltersOperation;
import org.eclipse.tcf.te.ui.views.nls.Messages;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.internal.navigator.NavigatorFilterService;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;
import org.eclipse.ui.navigator.ICommonFilterDescriptor;
import org.eclipse.ui.navigator.IDescriptionProvider;
import org.eclipse.ui.navigator.INavigatorContentService;

public class ConfigFiltersHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        NavigatorFilterService filterService;
        Object[] visibleFilters;
        Shell shell = HandlerUtil.getActiveShellChecked((ExecutionEvent)event);
        CommonNavigator navigator = (CommonNavigator)HandlerUtil.getActivePartChecked((ExecutionEvent)event);
        FilteredCheckedListDialog filterDialog = new FilteredCheckedListDialog(shell);
        filterDialog.setTitle(Messages.ConfigFiltersHandler_DialogTitle);
        filterDialog.setFilterText(Messages.ConfigFiltersHandler_InitialFilter);
        filterDialog.setMessage(Messages.ConfigFiltersHandler_PromptMessage);
        filterDialog.setStatusLineAboveButtons(true);
        filterDialog.setLabelProvider((ILabelProvider)new CommonFilterDescriptorLabelProvider());
        INavigatorContentService contentService = navigator.getNavigatorContentService();
        if (contentService != null && (visibleFilters = (filterService = (NavigatorFilterService)contentService.getFilterService()).getVisibleFilterDescriptorsForUI()) != null && visibleFilters.length > 0) {
            Object[] result;
            filterDialog.setElements(visibleFilters);
            ArrayList<Object> activeFilters = new ArrayList<Object>();
            Object[] objectArray = visibleFilters;
            int n = visibleFilters.length;
            int n2 = 0;
            while (n2 < n) {
                Object filter = objectArray[n2];
                if (filterService.isActive(filter.getId())) {
                    activeFilters.add(filter);
                }
                ++n2;
            }
            filterDialog.setInitialElementSelections(activeFilters);
            if (filterDialog.open() == 0 && (result = filterDialog.getResult()) != null) {
                this.activateFilters(navigator.getCommonViewer(), result);
            }
        }
        return null;
    }

    private void activateFilters(CommonViewer commonViewer, Object[] elements) {
        String[] filterIdsToActivate = new String[elements.length];
        int i = 0;
        while (i < elements.length) {
            ICommonFilterDescriptor descriptor = (ICommonFilterDescriptor)elements[i];
            filterIdsToActivate[i] = descriptor.getId();
            ++i;
        }
        UpdateActiveFiltersOperation updateFilters = new UpdateActiveFiltersOperation(commonViewer, filterIdsToActivate);
        updateFilters.execute(null, null);
    }

    class CommonFilterDescriptorLabelProvider
    extends LabelProvider
    implements IDescriptionProvider {
        CommonFilterDescriptorLabelProvider() {
        }

        public String getDescription(Object element) {
            if (element instanceof ICommonFilterDescriptor) {
                return ((ICommonFilterDescriptor)element).getDescription();
            }
            return null;
        }

        public String getText(Object element) {
            if (element instanceof ICommonFilterDescriptor) {
                return ((ICommonFilterDescriptor)element).getName();
            }
            return null;
        }
    }
}

