/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.terminal.view.ui.internal.actions;

import org.eclipse.swt.custom.CTabItem;
import org.eclipse.terminal.connector.TerminalState;
import org.eclipse.terminal.control.ITerminalViewControl;
import org.eclipse.terminal.view.ui.ITerminalsView;
import org.eclipse.terminal.view.ui.internal.Messages;
import org.eclipse.terminal.view.ui.internal.UIPlugin;
import org.eclipse.terminal.view.ui.internal.actions.AbstractTerminalAction;
import org.eclipse.terminal.view.ui.internal.tabs.TabCommandFieldHandler;
import org.eclipse.terminal.view.ui.internal.tabs.TabFolderManager;

public class ToggleCommandFieldAction
extends AbstractTerminalAction {
    private ITerminalsView view = null;

    public ToggleCommandFieldAction(ITerminalsView view) {
        super(null, ToggleCommandFieldAction.class.getName(), 2);
        this.view = view;
        this.setupAction(Messages.ToggleCommandFieldAction_menu, Messages.ToggleCommandFieldAction_toolTip, null, UIPlugin.getImageDescriptor("ToggleCommandField_enabled"), UIPlugin.getImageDescriptor("ToggleCommandField_disabled"), true);
        TabCommandFieldHandler handler = this.getCommandFieldHandler();
        this.setChecked(handler != null && handler.hasCommandInputField());
    }

    @Override
    public void run() {
        TabCommandFieldHandler handler = this.getCommandFieldHandler();
        if (handler != null) {
            handler.setCommandInputField(!handler.hasCommandInputField());
        }
        this.setChecked(handler != null && handler.hasCommandInputField());
    }

    @Override
    public void updateAction(boolean aboutToShow) {
        TabCommandFieldHandler handler = this.getCommandFieldHandler();
        ITerminalViewControl target = this.getTarget();
        this.setEnabled(aboutToShow && handler != null && target != null && target.getState() == TerminalState.CONNECTED);
        this.setChecked(handler != null && handler.hasCommandInputField());
    }

    protected TabCommandFieldHandler getCommandFieldHandler() {
        CTabItem activeTabItem;
        TabCommandFieldHandler handler = null;
        TabFolderManager manager = (TabFolderManager)((Object)this.view.getAdapter(TabFolderManager.class));
        if (manager != null && (activeTabItem = manager.getActiveTabItem()) != null && !activeTabItem.isDisposed()) {
            handler = manager.getTabCommandFieldHandler(activeTabItem);
        }
        return handler;
    }
}

